/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateHelper;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AtmAccessControlSettingsState;
import com.pingidentity.fsm.state.impl.AtmContractState;
import com.pingidentity.fsm.state.impl.AtmSelectionSettingsState;
import com.pingidentity.fsm.state.impl.AtmTokenEndpointContractState;
import com.pingidentity.fsm.state.impl.PolicyManagementTasklet;
import com.pingidentity.fsm.state.impl.SessionValidationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import java.security.cert.CertificateException;
import java.util.Optional;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;

public class BearerAccessTokenMgmtPluginTasklet
extends PluginInstanceTasklet {
    private static final long serialVersionUID = 20050130L;
    public static final String MENU_NAME = "Create Access Token Management Instance";
    protected SessionValidationState sessionValidationState;
    protected AtmContractState atmContractState;
    protected AtmTokenEndpointContractState atmTokenEndpointContractState;
    protected AtmSelectionSettingsState selectionSettingsState;
    protected AtmAccessControlSettingsState accessControlSettingsState;
    private static final Log log = LogFactory.getLog(BearerAccessTokenMgmtPluginTasklet.class);

    public BearerAccessTokenMgmtPluginTasklet(Visit visit) {
        super(visit);
    }

    @Override
    protected void initTransitions() {
        this.selectionSettingsState = new AtmSelectionSettingsState(this);
        this.accessControlSettingsState = new AtmAccessControlSettingsState(this);
        this.sessionValidationState = new SessionValidationState(this);
        this.atmContractState = new AtmContractState(this);
        this.atmTokenEndpointContractState = new AtmTokenEndpointContractState(this);
        this.selectPluginTypeState.addOutgoingTransition(this, this.configureAdapterState);
        this.configureAdapterState.addOutgoingTransition(this, this.sessionValidationState);
        this.sessionValidationState.addOutgoingTransition(this, this.atmContractState);
        this.atmContractState.addOutgoingTransition(this, this.atmTokenEndpointContractState);
        this.atmTokenEndpointContractState.addOutgoingTransition(this, this.selectionSettingsState);
        this.selectionSettingsState.addOutgoingTransition(this, this.accessControlSettingsState);
        this.accessControlSettingsState.addOutgoingTransition(this, this.summaryState);
    }

    @Override
    public boolean isSaveAllAvailable() {
        boolean isCalledFromOidcPolicyMgmt = Optional.of(this.getParentTasklet()).map(Tasklet::getParentTasklet).filter(tasklet -> tasklet instanceof PolicyManagementTasklet).isPresent();
        if (isCalledFromOidcPolicyMgmt) {
            return false;
        }
        return !this.hasConnectionWizard();
    }

    @Override
    public boolean isItInUse() {
        return false;
    }

    @Override
    public Cert getCertForExpiryNotification() {
        ConfigurablePluginInstance atmInstance;
        Cert encryptionCert = null;
        if (this.getPluginId() != null && (atmInstance = this.getPluginManager().getInstance(this.getPluginId())) != null) {
            Field encryptionField = atmInstance.getConfiguration().getField("Asymmetric Encryption Key");
            try {
                encryptionCert = CertificateHelper.getCertForPluginField((Field)encryptionField);
            }
            catch (CertificateException e) {
                log.debug((Object)("Unable to display certificate warning for access token management plugin instance with Id '" + atmInstance.getId() + "'."));
            }
        }
        return encryptionCert;
    }
}

