/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.cert.CertificateExpiryDisplay;
import com.pingidentity.fsm.state.impl.ManageCertificateRevocationState;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.sourceid.saml20.domain.ConnectionCerts;

public class CertificateRevocationCheckingTasklet
extends SingleStateTasklet
implements InUseCertsApi,
CertificateExpiryDisplay {
    private static final long serialVersionUID = 1L;
    private final ManageCertificateRevocationState manageCertificateRevocationState;
    private ConnectionCerts dsigConnectionCerts = new ConnectionCerts();
    private CertificateType expiryNotificationCertType;
    private String expiryNotificationCertId;

    public CertificateRevocationCheckingTasklet(Visit visit) {
        super("CertificateRevocationCheckingTasklet", "Certificate Revocation Checking");
        this.setSystemVisit(visit);
        this.manageCertificateRevocationState = new ManageCertificateRevocationState(this);
        this.setInitialState(this.manageCertificateRevocationState);
    }

    @Override
    public ConnectionCerts getDsigConnectionCerts() {
        return this.dsigConnectionCerts;
    }

    @Override
    public void setDsigConnectionCerts(ConnectionCerts certs) {
        this.dsigConnectionCerts = certs;
    }

    public Cert getInUseSecondaryVerificationCert() {
        return null;
    }

    @Override
    public LinkedHashSet<Cert> getInUseVerificationCerts() {
        LinkedHashSet<Cert> inUseCerts = new LinkedHashSet<Cert>();
        if (this.findState(this.manageCertificateRevocationState.getStateName()) != null && this.manageCertificateRevocationState.getSelectedCert() != null) {
            inUseCerts.add(this.manageCertificateRevocationState.getSelectedCert());
        }
        return inUseCerts;
    }

    @Override
    public Cert getInUseXmlEncryptionCert() {
        Cert inUseXmlEncryptionCert = null;
        if (this.findState(this.manageCertificateRevocationState.getStateName()) != null) {
            inUseXmlEncryptionCert = this.manageCertificateRevocationState.getSelectedCert();
        }
        return inUseXmlEncryptionCert;
    }

    @Override
    public Set<Cert> getInUseXmlEncryptionCerts() {
        HashSet<Cert> inUseCerts = new HashSet<Cert>();
        Cert tempCert = this.getInUseXmlEncryptionCert();
        if (tempCert != null) {
            inUseCerts.add(tempCert);
        }
        return inUseCerts;
    }

    @Override
    public Cert getCertForExpiryNotification() {
        if (this.expiryNotificationCertId != null) {
            for (Cert currentCert : this.getDsigConnectionCerts().getAllVerificationCerts()) {
                if (!this.expiryNotificationCertId.equals(currentCert.getId())) continue;
                return currentCert;
            }
        }
        return null;
    }

    @Override
    public void setCertIdForExpiryNotification(String certId) {
        this.expiryNotificationCertId = certId;
    }

    @Override
    public CertificateType getCertTypeForExpiryNotification() {
        return this.expiryNotificationCertType;
    }

    @Override
    public void setCertTypeForExpiryNotification(CertificateType expiryNotificationCertType) {
        this.expiryNotificationCertType = expiryNotificationCertType;
    }
}

