/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.PkCert;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CertSummaryState;
import com.pingidentity.fsm.state.impl.GenerateCsrState;
import com.pingidentity.fsm.state.impl.ImportCsrRespState;
import com.pingidentity.fsm.state.impl.SelectCertifyCertState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.impl.AbstractExportTasklet;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;

public class CertifyCertTasklet
extends AbstractExportTasklet
implements CertApi {
    private static final long serialVersionUID = 20050515L;
    private SelectCertifyCertState selectCertifyCertState;
    private GenerateCsrState generateCsrState;
    private ImportCsrRespState importCsrRespState;
    private CertSummaryState certSummaryState;
    private CertItem certItem;
    private static final String IMPORT_CSR = "importCsr";
    private static final Log log = LogFactory.getLog(CertifyCertTasklet.class);

    public CertifyCertTasklet(Visit visit) {
        super("CertifyCertTasklet", "Certificate Signing");
        this.setSystemVisit(visit);
        this.selectCertifyCertState = new SelectCertifyCertState(this);
        this.generateCsrState = new GenerateCsrState(this);
        this.importCsrRespState = new ImportCsrRespState(this, "importCsrResp");
        this.certSummaryState = new CertSummaryState(this);
        this.certSummaryState.setSummaryTitle("Import CSR Response Details");
        this.certSummaryState.setDownloadButtonVisible(false);
        this.setInitialState(this.selectCertifyCertState);
        this.selectCertifyCertState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.generateCsrState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !CertifyCertTasklet.this.selectCertifyCertState.importSelected();
            }
        });
        this.selectCertifyCertState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importCsrRespState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CertifyCertTasklet.this.selectCertifyCertState.importSelected();
            }
        });
        this.importCsrRespState.addOutgoingTransition(this, this.certSummaryState);
        this.setCancelAvailable(true);
    }

    public String getFilename() {
        this.generateCsrState.getCertItem();
        PkCert pkCert = (PkCert)this.certItem.getCert();
        return pkCert.getSerialNumberAsHex() + ".p10";
    }

    public byte[] getRawBytes() {
        this.setExported(true);
        byte[] rawBytes = null;
        try {
            PkCert pkCert = (PkCert)this.certItem.getCert();
            String csr = pkCert.exportCSR();
            rawBytes = csr.getBytes("UTF-8");
        }
        catch (IOException io) {
            log.error((Object)("Exporting this file caused an IOException! " + io), (Throwable)io);
        }
        catch (CertificateException certEx) {
            log.error((Object)("Exporting this file caused an CertificateException! " + certEx), (Throwable)certEx);
        }
        catch (KeyStoreException keyStoreEx) {
            log.error((Object)("Exporting this file caused an KeyStoreException! " + keyStoreEx), (Throwable)keyStoreEx);
        }
        catch (NoSuchAlgorithmException algEx) {
            log.error((Object)("Exporting this file caused an NoSuchAlgorithmException! " + algEx), (Throwable)algEx);
        }
        catch (GeneralSecurityException gse) {
            log.error((Object)("Exporting this file caused a General Security Exception! " + gse), (Throwable)gse);
        }
        return rawBytes;
    }

    @Override
    public void finish() {
        if (IMPORT_CSR.equals(this.selectCertifyCertState.getSelectedCsrOper())) {
            this.certItem.setCert(this.importCsrRespState.getNewPkCert());
            this.certItem.setImported(true);
            this.getParentTasklet().save(null);
        }
        super.finish();
    }

    @Override
    public CertItem getCertItem() {
        return null;
    }

    public void setCertToCertify(CertItem certItem) {
        this.certItem = certItem;
        this.selectCertifyCertState.setCertItem(certItem);
        this.generateCsrState.setCertItem(certItem);
        this.importCsrRespState.setCertItem(certItem);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isActivatable() {
        return false;
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        boolean continueProcessing = super.onFinish(cycle);
        this.setDoneClicked(true);
        return continueProcessing;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean isFinishAvailable() {
        return this.getCurrentState() instanceof GenerateCsrState || this.getCurrentState() instanceof CertSummaryState;
    }
}

