/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.c2ccontract.mgmt.C2cContractManager;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConnMappingContractInfoState;
import com.pingidentity.fsm.state.impl.ConnMappingCreateContractState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ConnMappingContractTasklet
extends Tasklet {
    private final transient C2cContractManager contractManager = MgmtFactory.getC2cContractManager();
    private static final long serialVersionUID = 1L;
    private final ConnMappingContractInfoState infoState;
    private final ConnMappingCreateContractState attrState;
    private final SummaryCardState summaryState;

    public ConnMappingContractTasklet(Visit visit) {
        super("ConnMappingContractTasklet", "Authentication Policy Contract");
        this.setSystemVisit(visit);
        this.infoState = new ConnMappingContractInfoState(this);
        this.attrState = new ConnMappingCreateContractState(this);
        this.summaryState = new SummaryCardState(this);
        this.createTransitions();
        this.setCancelAvailable(true);
    }

    private void createTransitions() {
        this.infoState.addOutgoingTransition(this, this.attrState);
        this.attrState.addOutgoingTransition(this, this.summaryState);
        this.setInitialState(this.infoState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void finish() {
        C2cContract contract = new C2cContract();
        this.save(contract);
        this.contractManager.saveContract(contract);
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)contract, DependencyType.c2c);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)contract, DependencyType.AUTHN_POLICY_ATTRS);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)contract, DependencyType.FRAGMENT_ATTRS);
        super.finish();
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        boolean continueProcessing = super.onFinish(cycle);
        this.infoState.setOriginalName(this.infoState.getName());
        return continueProcessing;
    }

    public String getContractId() {
        return this.infoState.getId();
    }

    public void createIdIfNeeded() {
        this.infoState.createIdIfNeeded();
    }

    public String getContractName() {
        return this.infoState.getName();
    }

    public boolean isInUse() {
        return MgmtFactory.getC2cContractManager().isContractInUse(this.getContractId());
    }
}

