/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CertSummaryState;
import com.pingidentity.fsm.state.impl.CreateCertState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.CertApi;
import com.pingidentity.fsm.tasklet.data.CertItem;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import java.util.List;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationDelegate;

public class CreateCertTasklet
extends Tasklet
implements CertApi {
    private static final long serialVersionUID = 20050515L;
    final CreateCertState createCertState;
    final CertSummaryState certSummaryState;
    private boolean globalEditing = false;
    private boolean activatable = true;
    private CertificateTypes.ValidTypes certType;

    public CreateCertTasklet(Visit visit) {
        super("CreateCertTasklet", "Create Certificate");
        this.setSystemVisit(visit);
        this.createCertState = new CreateCertState(this);
        this.certSummaryState = new CertSummaryState(this);
        this.certSummaryState.setSummaryTitle("Certificate Details");
        this.setInitialState(this.createCertState);
        this.setCancelAvailable(true);
        this.createCertState.addOutgoingTransition(this, this.certSummaryState);
    }

    @Override
    public void finish() {
        List<String> certErrors = this.createCertState.generate(this.certType);
        if (certErrors.isEmpty()) {
            if (this.createCertState.getCertItem() != null) {
                CertItem certItem = this.createCertState.getCertItem();
                certItem.setActive(this.certSummaryState.isActive());
                certItem.setActiveAdminSslCert(this.certSummaryState.isActiveAdminSslCert());
            }
            super.finish();
            this.getParentTasklet().save(null);
        } else {
            this.setHasErrors(true);
            ValidationDelegate delegate = this.getDelegate();
            if (delegate != null) {
                TaskletState.recordErrorMsgs(certErrors, (IValidationDelegate)delegate);
            }
        }
    }

    @Override
    public CertItem getCertItem() {
        return this.createCertState.getCertItem();
    }

    public boolean isGlobalEditing() {
        return this.globalEditing;
    }

    public void setGlobalEditing(boolean globalEditing) {
        this.globalEditing = globalEditing;
    }

    public CertificateTypes.ValidTypes getCertType() {
        return this.certType;
    }

    public void setCertType(CertificateTypes.ValidTypes certType) {
        this.certType = certType;
    }

    @Override
    public boolean isActivatable() {
        return this.activatable;
    }

    public boolean isSslCert() {
        return this.certType == CertificateTypes.ValidTypes.sslServerCerts;
    }

    public boolean isVerificationCertImport() {
        return this.certType == CertificateTypes.ValidTypes.dsigVerificationCert || this.certType == CertificateTypes.ValidTypes.ocspDsigVerificationCert || this.certType == CertificateTypes.ValidTypes.wsTrustDsigVerificationCert;
    }

    public void setActivatable() {
        if (this.globalEditing) {
            if (this.certType != CertificateTypes.ValidTypes.sslServerCerts) {
                this.activatable = false;
            }
        } else if (this.certType == CertificateTypes.ValidTypes.trustedCAs) {
            this.activatable = false;
        }
        if (!this.activatable) {
            this.certSummaryState.setActive(false);
            this.certSummaryState.setActiveAdminSslCert(false);
        }
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return !this.hasConnectionWizard() && !this.hasServerSettingWizard();
    }

    public boolean isHybridMode() {
        return PropertyInfo.isHSMHybrid();
    }
}

