/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.BackChannelAuthenticationState;
import com.pingidentity.fsm.state.impl.CertificateState;
import com.pingidentity.fsm.state.impl.GenericDsigCertState;
import com.pingidentity.fsm.state.impl.SelectXmlDecryptionKeyState;
import com.pingidentity.fsm.state.impl.SelectXmlEncryptionCertState;
import com.pingidentity.fsm.state.impl.SignatureVerificationSettingsState;
import com.pingidentity.fsm.state.impl.SigningCertState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsFedJwtSigningCertState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.data.CertificateTypes;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import com.pingidentity.validator.SummaryInfoPFValidationDelegate;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.ConnectionCerts;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class CredentialsTasklet
extends MultiProtocolTasklet
implements InUseCertsApi {
    private static final long serialVersionUID = 20050515L;
    private ConnectionCerts dsigConnectionCerts = new ConnectionCerts();
    final BackChannelAuthenticationState backChannelAuthnState;
    final SigningCertState signingCertState;
    final WsFedJwtSigningCertState jwtSigningCertState;
    final SignatureVerificationSettingsState signatureVerificationSettingsState;
    final SelectXmlEncryptionCertState selectXmlEncryptionCertState;
    final SelectXmlDecryptionKeyState selectXmlDecryptionKeyState;
    final SummaryCardState summaryCardState;

    public CredentialsTasklet(Visit visit) {
        super("CredentialsTasklet", "Credentials");
        this.setSystemVisit(visit);
        this.backChannelAuthnState = new BackChannelAuthenticationState(this);
        this.signingCertState = new SigningCertState(this);
        this.jwtSigningCertState = new WsFedJwtSigningCertState(this);
        this.signatureVerificationSettingsState = new SignatureVerificationSettingsState(this);
        this.selectXmlEncryptionCertState = new SelectXmlEncryptionCertState(this);
        this.selectXmlEncryptionCertState.setCertType(CertificateTypes.ValidTypes.xmlEncryptionCert);
        this.selectXmlDecryptionKeyState = new SelectXmlDecryptionKeyState(this);
        this.selectXmlDecryptionKeyState.setCertType(CertificateTypes.ValidTypes.xmlDecryptionCert);
        this.summaryCardState = new SummaryCardState(this);
        this.backChannelAuthnState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.signingCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.showDsigSigningKey();
            }
        });
        this.backChannelAuthnState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.signatureVerificationSettingsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.showSignatureVerificationSettingsInfo();
            }
        });
        this.backChannelAuthnState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlEncryptionCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isEncryptionCertificateNeeded();
            }
        });
        this.backChannelAuthnState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlDecryptionKeyState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isDecryptionKeyNeeded();
            }
        });
        this.backChannelAuthnState.addOutgoingTransition(this, this.summaryCardState);
        this.signingCertState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.signatureVerificationSettingsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.showSignatureVerificationSettingsInfo();
            }
        });
        this.signingCertState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlEncryptionCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isEncryptionCertificateNeeded();
            }
        });
        this.signingCertState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlDecryptionKeyState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isDecryptionKeyNeeded();
            }
        });
        this.signingCertState.addOutgoingTransition(this, this.summaryCardState);
        this.jwtSigningCertState.addOutgoingTransition(this, this.summaryCardState);
        this.signatureVerificationSettingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlEncryptionCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isEncryptionCertificateNeeded();
            }
        });
        this.signatureVerificationSettingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlDecryptionKeyState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isDecryptionKeyNeeded();
            }
        });
        this.signatureVerificationSettingsState.addOutgoingTransition(this, this.summaryCardState);
        this.selectXmlEncryptionCertState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectXmlDecryptionKeyState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return CredentialsTasklet.this.findParent(NeededCredentialsApi.class).isDecryptionKeyNeeded();
            }
        });
        this.selectXmlEncryptionCertState.addOutgoingTransition(this, this.summaryCardState);
        this.selectXmlDecryptionKeyState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.backChannelAuthnState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        IdpConnection connectionBase = null;
        switch (this.findParent(ConnectionTasklet.class).getConnectionType()) {
            case IDP: {
                connectionBase = new IdpConnection();
                break;
            }
            case SP: {
                connectionBase = new SpConnection();
            }
        }
        if (connectionBase != null) {
            this.save(connectionBase);
            this.setPopulateData(connectionBase);
        }
        super.finish();
    }

    @Override
    public String getHelpName() {
        return this.findParent(ConnectionTasklet.class).getConnectionType() + "_" + super.getHelpName();
    }

    public boolean showSignatureVerificationSettingsInfo() {
        return this.findParent(NeededCredentialsApi.class).isDigitalSignatureVerificationNeeded() || this.anySsoSelected() && this.backChannelAuthnState.outboundArtifactUsesDsigAuth();
    }

    public boolean showEncryptionCertificate() {
        return this.findParent(NeededCredentialsApi.class).isEncryptionCertificateNeeded();
    }

    public boolean showDecryptionCertificate() {
        return this.findParent(NeededCredentialsApi.class).isDecryptionKeyNeeded();
    }

    public boolean showSecondaryDigitalSignature() {
        GenericDsigCertState state = this.isWsFedJwt() ? (GenericDsigCertState)this.findState(this.jwtSigningCertState.getStateName()) : (GenericDsigCertState)this.findState(this.signingCertState.getStateName());
        if (state != null) {
            return state.getSecondarySelectedCert() != null && state.isShowSecondaryCertDropDown();
        }
        return false;
    }

    public boolean showInboundBackChannel() {
        NeededCredentialsApi nca = this.findParent(NeededCredentialsApi.class);
        return nca.isBackChannelAuthenticationNeeded() && this.backChannelAuthnState.isOutboundArtifactSelected();
    }

    public boolean showOutboundBackChannel() {
        NeededCredentialsApi nca = this.findParent(NeededCredentialsApi.class);
        return nca.isBackChannelAuthenticationNeeded() && this.backChannelAuthnState.isInboundArtifactSelected();
    }

    private boolean anySsoSelected() {
        return this.findParent(SamlProfilesApi.class).isAnySsoSelected() || this.isConnectionProtocol1x();
    }

    public boolean showDsigSigningKey() {
        return this.findParent(NeededCredentialsApi.class).isDigitalSignatureNeeded() || this.anySsoSelected() && this.backChannelAuthnState.inboundArtifactUsesDsigAuth();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void populate(Object dataFromDisk) {
        this.dsigConnectionCerts = ((ConnectionBase)dataFromDisk).getDsigVerificationCerts();
        super.populate(dataFromDisk);
    }

    @Override
    public boolean populateAllStates(Object dataFromDisk) {
        this.dsigConnectionCerts = ((ConnectionBase)dataFromDisk).getDsigVerificationCerts();
        super.populateAllStates(dataFromDisk);
        return true;
    }

    @Override
    public boolean save(Object dataToDisk) {
        if (this.showSignatureVerificationSettingsInfo() || this.showEncryptionCertificate()) {
            ((ConnectionBase)dataToDisk).setDsigVerificationCerts(this.dsigConnectionCerts);
        } else {
            ((ConnectionBase)dataToDisk).setDsigVerificationCerts(new ConnectionCerts());
        }
        return super.save(dataToDisk);
    }

    @Override
    public void reconfigureTransitions() {
        NeededCredentialsApi nca = this.findParent(NeededCredentialsApi.class);
        if (this.isWsFedJwt()) {
            this.setInitialState(this.jwtSigningCertState);
        } else if (nca.isBackChannelAuthenticationNeeded()) {
            this.setInitialState(this.backChannelAuthnState);
        } else if (nca.isDigitalSignatureNeeded()) {
            this.setInitialState(this.signingCertState);
        } else if (nca.isDigitalSignatureVerificationNeeded()) {
            this.setInitialState(this.signatureVerificationSettingsState);
        } else if (nca.isEncryptionCertificateNeeded()) {
            this.setInitialState(this.selectXmlEncryptionCertState);
        } else if (nca.isDecryptionKeyNeeded()) {
            this.setInitialState(this.selectXmlDecryptionKeyState);
        } else {
            this.setInitialState(this.summaryCardState);
        }
    }

    private boolean isWsFedJwt() {
        SpConnectionConfigTasklet spConnTasklet = this.findParent(SpConnectionConfigTasklet.class);
        return spConnTasklet != null && spConnTasklet.isWsFedJwt() && this.isWsFedProtocol();
    }

    @Override
    public void configureTasklet() {
        this.signingCertState.setProtocol(this.getProtocolType());
    }

    @Override
    public Protocol getProtocolType() {
        return ((ConnectionTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public ConnectionCerts getDsigConnectionCerts() {
        return this.dsigConnectionCerts;
    }

    @Override
    public void setDsigConnectionCerts(ConnectionCerts certs) {
        this.dsigConnectionCerts = certs;
    }

    @Override
    public Cert getInUseXmlEncryptionCert() {
        Cert inUseXmlEncryptionCert = null;
        if (this.findState(this.selectXmlEncryptionCertState.getStateName()) != null) {
            inUseXmlEncryptionCert = this.selectXmlEncryptionCertState.getSelectedCert();
        }
        return inUseXmlEncryptionCert;
    }

    @Override
    public LinkedHashSet<Cert> getInUseVerificationCerts() {
        return this.signatureVerificationSettingsState.getInUseVerificationCerts();
    }

    @Override
    public Set<Cert> getInUseXmlEncryptionCerts() {
        HashSet<Cert> inUseCerts = new HashSet<Cert>();
        Cert tempCert = this.getInUseXmlEncryptionCert();
        if (tempCert != null) {
            inUseCerts.add(tempCert);
        }
        return inUseCerts;
    }

    public String getBackChannelAuthenticationConfigured() {
        String text = "Not Configured";
        if (this.findState(this.backChannelAuthnState.getStateName()) != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            this.backChannelAuthnState.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (!tempDelegate.getHasErrors()) {
                text = "Configured";
            }
        }
        return text;
    }

    public String getInboundBackChannelAuthenticationConfigured() {
        SamlProfilesApi spa;
        Object text = "Not Configured";
        if (this.findState(this.backChannelAuthnState.getStateName()) != null) {
            if (!this.backChannelAuthnState.isConfigured()) {
                return text;
            }
            text = "";
            if (this.backChannelAuthnState.outboundArtifactUsesBasic()) {
                text = (String)text + "HTTP Basic";
            }
            if (this.backChannelAuthnState.outboundArtifactUsesSSLCert()) {
                if (!((String)text).equals("")) {
                    text = (String)text + ", ";
                }
                text = (String)text + "SSL Client Certificate";
            }
            if (this.backChannelAuthnState.outboundArtifactUsesDsigAuth()) {
                if (!((String)text).equals("")) {
                    text = (String)text + ", ";
                }
                text = (String)text + "Digital Signature";
            }
        }
        if ((spa = this.findParent(SamlProfilesApi.class)).isAttributeQuerySelected() && !spa.isAnySsoSelected() && this.backChannelAuthnState.outboundArtifactUsesDsigAuth()) {
            text = "None";
        }
        return text;
    }

    public String getOutboundBackChannelAuthenticationConfigured() {
        SamlProfilesApi spa;
        Object text = "Not Configured";
        if (this.findState(this.backChannelAuthnState.getStateName()) != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            this.backChannelAuthnState.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (tempDelegate.getHasErrors()) {
                if (!this.backChannelAuthnState.isInboundArtifactSelected()) {
                    return text;
                }
                for (String message : tempDelegate.getErrorMsgs()) {
                    if (!message.contains("inbound")) continue;
                    return text;
                }
            }
            text = "";
            if (this.backChannelAuthnState.inboundArtifactUsesBasic()) {
                text = (String)text + "HTTP Basic";
            }
            if (this.backChannelAuthnState.inboundArtifactUsesSSLCert()) {
                if (!((String)text).equals("")) {
                    text = (String)text + ", ";
                }
                text = (String)text + "SSL Client Certificate";
            }
            if (this.backChannelAuthnState.inboundArtifactUsesDsigAuth()) {
                if (!((String)text).equals("")) {
                    text = (String)text + ", ";
                }
                text = (String)text + "Digital Signature";
            }
        }
        if ((spa = this.findParent(SamlProfilesApi.class)).isAttributeQuerySelected() && !spa.isAnySsoSelected() && this.backChannelAuthnState.inboundArtifactUsesDsigAuth()) {
            text = "None";
        }
        return text;
    }

    public String getDigitalSignatureConfigured() {
        String text = "Not Configured";
        CertificateState state = this.isWsFedJwt() ? (CertificateState)this.findState(this.jwtSigningCertState.getStateName()) : (CertificateState)this.findState(this.signingCertState.getStateName());
        if (state != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            state.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (!tempDelegate.getHasErrors()) {
                text = state.getSelectedCert().getDescriptionForDisplay();
            }
        }
        return text;
    }

    public String getSecondaryDigitalSignatureConfigured() {
        String text = "Not Configured";
        CertificateState state = this.isWsFedJwt() ? (CertificateState)this.findState(this.jwtSigningCertState.getStateName()) : (CertificateState)this.findState(this.signingCertState.getStateName());
        if (state != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            state.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (!tempDelegate.getHasErrors() && state.getSecondarySelectedCert() != null) {
                text = state.getSecondarySelectedCert().getDescriptionForDisplay();
            }
        }
        return text;
    }

    public List<String> getActiveSignatureVerificationCertStrings() {
        return this.signatureVerificationSettingsState.getActiveSignatureVerificationCertStrings();
    }

    public boolean isAnchored() {
        return this.signatureVerificationSettingsState.isAnchored();
    }

    public String getSubjectDn() {
        return this.signatureVerificationSettingsState.getSubjectDn();
    }

    public String getEncryptionCertificateConfigured() {
        String text = "Not Configured";
        CertificateState state = (CertificateState)this.findState(this.selectXmlEncryptionCertState.getStateName());
        if (state != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            this.selectXmlEncryptionCertState.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (!tempDelegate.getHasErrors()) {
                Cert cert = state.getSelectedCert();
                text = cert.getDescriptionForDisplay();
            }
        }
        return text;
    }

    private String getDecryptionCertName(boolean useSecondaryDecryptCert) {
        String text = "Not Configured";
        CertificateState state = (CertificateState)this.findState(this.selectXmlDecryptionKeyState.getStateName());
        if (state != null) {
            SummaryInfoPFValidationDelegate tempDelegate = new SummaryInfoPFValidationDelegate();
            this.selectXmlDecryptionKeyState.appendErrors((IValidationDelegate)tempDelegate, null, false);
            if (!tempDelegate.getHasErrors()) {
                Cert cert = null;
                cert = useSecondaryDecryptCert ? state.getSecondarySelectedCert() : state.getSelectedCert();
                if (cert != null) {
                    text = cert.getDescriptionForDisplay();
                }
            }
        }
        return text;
    }

    public String getDecryptionCertificatesConfigured() {
        String text = "Primary " + this.getDecryptionCertName(false) + ", Secondary " + this.getDecryptionCertName(true);
        return text;
    }

    public boolean isPingOneConnection() {
        SpConnectionConfigTasklet tasklet = this.findParent(SpConnectionConfigTasklet.class);
        if (tasklet == null) {
            return false;
        }
        String pingOneTargetType = MgmtFactory.getPingOneAdminService().getSpConnectionFactory().getFactoryMetadata().getConnectionTargetType();
        return pingOneTargetType.equals(tasklet.getSelectedTargetType());
    }

    public void metaDataReset() {
        this.signatureVerificationSettingsState.metaDataReset();
    }
}

