/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.DSignRotationState;
import com.pingidentity.fsm.state.impl.DSignRotationSummaryState;
import com.pingidentity.fsm.state.impl.EnableDSignRotationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.sourceid.saml20.domain.DSignRotationSetting;
import org.sourceid.saml20.domain.mgmt.DSignRotationSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DSignRotationTasklet
extends Tasklet {
    private static final long serialVersionUID = 1L;
    private DSignRotationState dsignCertRotationState;
    private EnableDSignRotationState enableCertRotationState;
    private DSignRotationSummaryState summaryState;
    private Cert originalCert;

    public DSignRotationTasklet(Visit visit) {
        super("CertificateRotationTasklet", "Certificate Rotation");
        this.setSystemVisit(visit);
        this.dsignCertRotationState = new DSignRotationState(this);
        this.enableCertRotationState = new EnableDSignRotationState(this);
        this.summaryState = new DSignRotationSummaryState(this);
        this.setInitialState(this.enableCertRotationState);
        this.setCancelAvailable(true);
    }

    @Override
    public void reconfigureTransitions() {
        this.clearAllStatesOutgoingTransitions();
        if (this.enableCertRotationState.isEnableCertRotation()) {
            this.enableCertRotationState.addOutgoingTransition(this, this.dsignCertRotationState);
            this.dsignCertRotationState.setEnableCertRotation(this.enableCertRotationState.isEnableCertRotation());
            this.dsignCertRotationState.addOutgoingTransition(this, this.summaryState);
        } else {
            this.dsignCertRotationState.reset();
        }
    }

    public void loadStates() {
        DSignRotationSettingsManager rotationMgr;
        DSignRotationSetting rotationSetting;
        if (this.originalCert != null && (rotationSetting = (rotationMgr = MgmtFactory.getDSignRotationSettingsManager()).getRotationSetting(this.originalCert.getAlias())) != null) {
            this.enableCertRotationState.setEnableCertRotation(rotationSetting.isEnableCertRotation());
            this.dsignCertRotationState.setEnableCertRotation(rotationSetting.isEnableCertRotation());
            this.dsignCertRotationState.setActivationBufferDays(String.valueOf(rotationSetting.getActivationBufferDays().intValue()));
            this.dsignCertRotationState.setCreationBufferDays(String.valueOf(rotationSetting.getRotationBufferDays().intValue()));
            this.dsignCertRotationState.setKeySize(String.valueOf(rotationSetting.getKeySize()));
            this.dsignCertRotationState.setKeyAlgorithm(rotationSetting.getKeyAlgorithm());
            this.dsignCertRotationState.setValidityPeriodDays(String.valueOf(rotationSetting.getValidityPeriodDays()));
            this.dsignCertRotationState.setSignatureAlgorithm(rotationSetting.getSignatureAlgorithm());
        }
    }

    public Cert getOriginalCert() {
        return this.originalCert;
    }

    public void setOriginalCert(Cert originalCert) {
        this.originalCert = originalCert;
        if (this.dsignCertRotationState != null) {
            this.dsignCertRotationState.setOriginalCert(originalCert);
        }
        if (this.enableCertRotationState != null) {
            this.enableCertRotationState.setOriginalCertAlias(originalCert.getAlias());
        }
    }

    public EnableDSignRotationState getEnableCertRotationState() {
        return this.enableCertRotationState;
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }

    @Override
    public void finish() {
        this.dsignCertRotationState.save(null);
        this.enableCertRotationState.save(null);
        super.finish();
    }

    @Override
    public boolean save(Object dataToDisk) {
        this.dsignCertRotationState.save(null);
        this.enableCertRotationState.save(null);
        return true;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletState state = (TaskletState)this.getSourceState();
        TaskletTransition tt = null;
        do {
            state.getSummary(summaryList);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public void cancel() {
        this.resetAllStates();
    }
}

