/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AttributeSourceAdapterActionState;
import com.pingidentity.fsm.state.impl.ConfigureAttributeSourceAdapterState;
import com.pingidentity.fsm.state.impl.CustomDataBaseConfigState;
import com.pingidentity.fsm.state.impl.LdapConfigState;
import com.pingidentity.fsm.state.impl.LdapGatewayConfigState;
import com.pingidentity.fsm.state.impl.ManageDataSourcesState;
import com.pingidentity.fsm.state.impl.SelectDataSourceTypeState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.RetrieveAttributeSourceInstance;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.module.connection.ConnectionModuleSupport;
import com.pingidentity.sources.SourceDescriptor;
import org.apache.commons.lang.StringUtils;
import org.sourceid.common.Util;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class DataSourceTasklet
extends Tasklet
implements RetrieveAttributeSourceInstance {
    private static final long serialVersionUID = 20050515L;
    final SelectDataSourceTypeState selectDataSourceTypeState;
    final CustomDataBaseConfigState customDataBaseConfigState;
    final ConfigureAttributeSourceAdapterState configureAdapterState;
    final AttributeSourceAdapterActionState adapterActionState;
    final LdapConfigState ldapConfigState;
    final LdapGatewayConfigState ldapGatewayConfigState;
    final SummaryCardState summaryState;
    private boolean disabled;

    public DataSourceTasklet(Visit visit) {
        super("DataSourceTasklet", "Data Store");
        this.setSystemVisit(visit);
        this.selectDataSourceTypeState = new SelectDataSourceTypeState(this);
        this.customDataBaseConfigState = new CustomDataBaseConfigState(this);
        this.configureAdapterState = new ConfigureAttributeSourceAdapterState(this);
        this.adapterActionState = new AttributeSourceAdapterActionState(this);
        this.ldapConfigState = new LdapConfigState(this);
        this.ldapGatewayConfigState = new LdapGatewayConfigState(this);
        this.summaryState = new SummaryCardState(this);
        this.setInitialState(this.selectDataSourceTypeState);
        this.createJdbcTransitions();
        this.setCancelAvailable(true);
    }

    @Override
    public void reconfigureTransitions() {
        this.clearAllStatesOutgoingTransitions();
        switch (this.getType()) {
            case Other: {
                this.createCustomTransitions();
                this.selectDataSourceTypeState.setItClickable(true);
                break;
            }
            case Database: {
                this.createJdbcTransitions();
                this.selectDataSourceTypeState.setItClickable(true);
                break;
            }
            case LDAP_GATEWAY: {
                this.createLdapGatewayTransitions();
                this.selectDataSourceTypeState.setItClickable(true);
                break;
            }
            case LDAP: {
                this.createLdapTransitions();
                this.selectDataSourceTypeState.setItClickable(true);
                break;
            }
            default: {
                this.createJdbcTransitions();
            }
        }
    }

    private void createLdapTransitions() {
        this.selectDataSourceTypeState.addOutgoingTransition(this, this.ldapConfigState);
        this.ldapConfigState.addOutgoingTransition(this, this.summaryState);
    }

    private void createLdapGatewayTransitions() {
        this.selectDataSourceTypeState.addOutgoingTransition(this, this.ldapGatewayConfigState);
        this.ldapGatewayConfigState.addOutgoingTransition(this, this.summaryState);
    }

    private void createJdbcTransitions() {
        this.selectDataSourceTypeState.addOutgoingTransition(this, this.customDataBaseConfigState);
        this.customDataBaseConfigState.addOutgoingTransition(this, this.summaryState);
    }

    private void createCustomTransitions() {
        this.selectDataSourceTypeState.addOutgoingTransition(this, this.configureAdapterState);
        this.configureAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.adapterActionState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = DataSourceTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                return instance != null && descriptor != null && descriptor.hasActions();
            }
        });
        this.adapterActionState.addOutgoingTransition(this, this.summaryState);
        this.configureAdapterState.addOutgoingTransition(this, this.summaryState);
    }

    public void setDataSourceTaskletInitialState(SelectDataSourceTypeState.DSType initialState) {
        switch (initialState) {
            case Other: {
                this.configureAdapterState.setItClickable(true);
                this.setInitialState(this.configureAdapterState);
                break;
            }
            case Database: {
                this.customDataBaseConfigState.setItClickable(true);
                this.setInitialState(this.customDataBaseConfigState);
                break;
            }
            case LDAP: {
                this.ldapConfigState.setItClickable(true);
                this.setInitialState(this.ldapConfigState);
                break;
            }
            case LDAP_GATEWAY: {
                this.ldapConfigState.setItClickable(true);
                this.setInitialState(this.ldapGatewayConfigState);
                break;
            }
            default: {
                this.customDataBaseConfigState.setItClickable(true);
                this.setInitialState(this.customDataBaseConfigState);
            }
        }
    }

    public String getDesc() {
        switch (this.getType()) {
            case Database: {
                return this.customDataBaseConfigState.getSourceName();
            }
            case LDAP: {
                return this.ldapConfigState.getSourceName();
            }
            case LDAP_GATEWAY: {
                return this.ldapGatewayConfigState.getSourceName();
            }
            case Other: {
                return this.configureAdapterState.getSourceName();
            }
        }
        return this.selectDataSourceTypeState.getSourceName();
    }

    public String getUser() {
        switch (this.getType()) {
            case Database: {
                return this.customDataBaseConfigState.getUserName();
            }
            case LDAP: {
                String username = this.ldapConfigState.getUserName();
                if (StringUtils.isNotBlank((String)username)) {
                    String cn = Util.getCN((String)username);
                    if (cn == null) {
                        return username;
                    }
                    return cn;
                }
                if (!this.ldapConfigState.getBindAnon()) break;
                return "Anonymous";
            }
        }
        return "";
    }

    public String getId() {
        switch (this.getType()) {
            case Database: {
                return this.customDataBaseConfigState.getId();
            }
            case LDAP: {
                return this.ldapConfigState.getId();
            }
            case LDAP_GATEWAY: {
                return this.ldapGatewayConfigState.getId();
            }
            case Other: {
                return this.configureAdapterState.getId();
            }
        }
        return "";
    }

    public boolean isInUse() {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        ConnectionModuleSupport moduleSupport = ConnectionModuleSupport.getInstance();
        switch (this.getType()) {
            case Database: {
                return dsMgr.isInUse((DataSource)this.customDataBaseConfigState.getJdbc()) || moduleSupport.isDataSourceInUse((DataSource)this.customDataBaseConfigState.getJdbc());
            }
            case LDAP: {
                return dsMgr.isInUse((DataSource)this.ldapConfigState.getLdapDS()) || moduleSupport.isDataSourceInUse((DataSource)this.ldapConfigState.getLdapDS());
            }
            case LDAP_GATEWAY: {
                return dsMgr.isInUse((DataSource)this.ldapGatewayConfigState.getLdapDS()) || moduleSupport.isDataSourceInUse((DataSource)this.ldapGatewayConfigState.getLdapDS());
            }
            case Other: {
                return dsMgr.isInUse((DataSource)this.configureAdapterState.getCustomAttributeSource()) || moduleSupport.isDataSourceInUse((DataSource)this.configureAdapterState.getCustomAttributeSource());
            }
        }
        return false;
    }

    public SelectDataSourceTypeState.DSType getType() {
        return this.selectDataSourceTypeState.getSelectedDataSourceType();
    }

    public String getLdapTypeDesc() {
        switch (this.getType()) {
            case LDAP: {
                return this.ldapConfigState.getSelectedLdapTypeDesc();
            }
            case LDAP_GATEWAY: {
                return this.ldapGatewayConfigState.getSelectedLdapTypeDesc();
            }
        }
        return "";
    }

    public SelectDataSourceTypeState.DSType getSelectedDataSourceType() {
        return this.selectDataSourceTypeState.getSelectedDataSourceType();
    }

    public boolean getAnonymousBinding() {
        return this.getType() == SelectDataSourceTypeState.DSType.LDAP && this.ldapConfigState.getBindAnon();
    }

    public String getUnalteredLdapUserName() {
        if (this.getType() == SelectDataSourceTypeState.DSType.LDAP) {
            return this.ldapConfigState.getUserName();
        }
        return null;
    }

    public boolean isDuplicate(String sourceName, ManageDataSourcesState parentState, boolean isExistingDs) {
        if (isExistingDs) {
            return parentState.isDuplicate(sourceName, this);
        }
        return parentState.isDuplicate(sourceName);
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        if (this.getType() == SelectDataSourceTypeState.DSType.Other) {
            return (CustomDataSource)this.selectDataSourceTypeState.getSelectedDataSource();
        }
        return null;
    }

    public Configuration buildCustomConfiguration() {
        return this.configureAdapterState.buildConfiguration();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public String getDisabled() {
        return "disabled";
    }

    @Override
    public void finish() {
        DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
        switch (this.getSelectedDataSourceType()) {
            case Database: {
                JdbcDataSource jdbcDataSource = new JdbcDataSource();
                this.setMode(Mode.edit);
                this.save(jdbcDataSource);
                this.populate(jdbcDataSource);
                if (jdbcDataSource.getId() == null) {
                    dsMgr.saveJdbcDataSource(jdbcDataSource);
                    this.customDataBaseConfigState.setId(jdbcDataSource.getId());
                    break;
                }
                dsMgr.saveJdbcDataSource(jdbcDataSource);
                break;
            }
            case LDAP: {
                LdapDataSource ldapDataSource = new LdapDataSource();
                this.setMode(Mode.edit);
                this.save(ldapDataSource);
                this.populate(ldapDataSource);
                if (ldapDataSource.getId() == null) {
                    dsMgr.saveLdapDataSource(ldapDataSource);
                    this.ldapConfigState.setId(ldapDataSource.getId());
                    break;
                }
                dsMgr.saveLdapDataSource(ldapDataSource);
                break;
            }
            case LDAP_GATEWAY: {
                LdapDataSource ldapGatewayDataSource = new LdapDataSource();
                this.setMode(Mode.edit);
                this.save(ldapGatewayDataSource);
                this.populate(ldapGatewayDataSource);
                if (ldapGatewayDataSource.getId() == null) {
                    dsMgr.saveLdapDataSource(ldapGatewayDataSource);
                    this.ldapGatewayConfigState.setId(ldapGatewayDataSource.getId());
                    break;
                }
                dsMgr.saveLdapDataSource(ldapGatewayDataSource);
                break;
            }
            case Other: {
                CustomDataSource tempSource = new CustomDataSource();
                this.setMode(Mode.edit);
                this.save(tempSource);
                this.populate(tempSource);
                if (tempSource.getId() == null) {
                    dsMgr.saveCustomDataSource(tempSource);
                    this.configureAdapterState.setAdapterInstance(tempSource);
                    this.configureAdapterState.setId(tempSource.getId());
                    break;
                }
                dsMgr.saveCustomDataSource(tempSource);
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid data source type: " + this.getSelectedDataSourceType());
            }
        }
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.FRAGMENT_ATTRS);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)null, DependencyType.AUTHN_POLICY_ATTRS);
        super.finish();
    }

    public boolean isInconsistentLdapType(Tasklet taskletToBeCompared) {
        return this.getType() == SelectDataSourceTypeState.DSType.LDAP && this.ldapConfigState.isInconsistentLdapType(taskletToBeCompared);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return !this.hasConnectionWizard();
    }

    public String getSourceName() {
        return this.selectDataSourceTypeState.getSourceName();
    }

    public boolean isMaskAttributeValues() {
        return this.selectDataSourceTypeState.isMaskAttributeValues();
    }
}

