/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.IdpC2cContractFulfillmentState;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.SelectAdditionalAttributesState;
import com.pingidentity.fsm.state.impl.SelectC2cContractDataSourceState;
import com.pingidentity.fsm.state.impl.SelectC2cContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigSessionMappingTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.websso.Protocol;

public class IdpC2cContractMappingTasklet
extends IdpConfigSessionMappingTasklet {
    private static final long serialVersionUID = 1L;
    private final SelectC2cContractState selectContractState;

    public IdpC2cContractMappingTasklet(Visit visit) {
        super(visit);
        this.setMenuName("Authentication Policy Mapping");
        this.selectContractState = new SelectC2cContractState(this);
        this.setInitialState(this.selectContractState);
        this.initTransitions();
        this.setTaskletId(this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
    }

    public boolean equals(Object o) {
        return this.getDescription().equals(((IdpC2cContractMappingTasklet)o).getDescription());
    }

    public int hashCode() {
        return this.selectContractState != null ? this.selectContractState.hashCode() : 0;
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getDescription().toLowerCase().compareTo(((IdpC2cContractMappingTasklet)o).getDescription().toLowerCase());
    }

    @Override
    public String getDescription() {
        String name = this.selectContractState.getSelectedContractName();
        return name != null ? name : "";
    }

    @Override
    public List<String> getContractToFulfill() {
        return this.selectContractState.getAttributeList();
    }

    public void setNewContract(boolean newContract) {
        this.selectContractState.setNewContract(newContract);
    }

    public String getContractId() {
        return this.selectContractState.getSelectedContractId();
    }

    public String getContractName() {
        return this.selectContractState.getSelectedContractName();
    }

    @Override
    public AttributeMapping newDomainMapping() {
        return new C2cContractAttributeMapping();
    }

    @Override
    public SelectAdditionalAttributesState newAdditionalAttrsState() {
        return new SelectC2cContractDataSourceState(this);
    }

    @Override
    public MappingState newMappingFulfillmentState() {
        return new IdpC2cContractFulfillmentState(this);
    }

    @Override
    public boolean isInitialState(TaskletState state) {
        return state instanceof SelectC2cContractState;
    }

    public void refreshName() {
        this.selectContractState.refreshName();
    }

    @Override
    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        super.addStandardSourcesToPropertySelectionSources(sources);
        ConnectionTasklet connectionTasklet = this.findParent(ConnectionTasklet.class);
        List contextTypes = SourceContextType.getProtocolDependentContextTypesForIdpBrowserSSO((Protocol)connectionTasklet.getProtocolType());
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : contextTypes) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
        this.addExtendedPropertiesToSelectionSources(sources);
    }
}

