/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.IdpAdapterContractMappingState;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.OverrideInstanceState;
import com.pingidentity.fsm.state.impl.SelectAdapterDataSourceState;
import com.pingidentity.fsm.state.impl.SelectAdapterState;
import com.pingidentity.fsm.state.impl.SelectAdditionalAttributesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AccountLinkingApi;
import com.pingidentity.fsm.tasklet.api.PluginMappingApi;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigSessionMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.PluginInstanceTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.TargetAttributeMapping;

public class IdpConfigAdapterMappingTasklet
extends IdpConfigSessionMappingTasklet
implements PluginMappingApi {
    private static final long serialVersionUID = 20050515L;
    private final SelectAdapterState selectAdapterState;
    private final OverrideInstanceState overrideInstanceState;

    public IdpConfigAdapterMappingTasklet(Visit visit) {
        super(visit);
        this.setMenuName("Adapter Mapping & User Lookup");
        this.selectAdapterState = new SelectAdapterState(this);
        this.selectAdapterState.setAdapterType(SelectAdapterState.ADAPTER_TYPE.AUTHN);
        this.overrideInstanceState = new OverrideInstanceState(this);
        this.setInitialState(this.selectAdapterState);
        this.setCancelAvailable(true);
        this.initTransitions();
        this.setTaskletId(this.getClass().getName() + "@" + Integer.toHexString(this.hashCode()));
    }

    @Override
    protected void initInitialTransitions() {
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.overrideInstanceState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return IdpConfigAdapterMappingTasklet.this.isOverridePluginConnectionSettings();
            }
        });
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = IdpConfigAdapterMappingTasklet.this.getParentTasklet().findParent(IdpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.selectAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectAdditionalAttrSourceState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !IdpConfigAdapterMappingTasklet.this.isOverridePluginConnectionSettings();
            }
        });
        this.overrideInstanceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = IdpConfigAdapterMappingTasklet.this.getParentTasklet().findParent(IdpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.overrideInstanceState.addOutgoingTransition(this, this.selectAdditionalAttrSourceState);
    }

    public boolean equals(Object o) {
        return this.getDescription().equals(((IdpConfigAdapterMappingTasklet)o).getDescription());
    }

    public int hashCode() {
        int result = this.selectAdapterState != null ? this.selectAdapterState.hashCode() : 0;
        result = 31 * result + (this.overrideInstanceState != null ? this.overrideInstanceState.hashCode() : 0);
        return result;
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getDescription().toLowerCase().compareTo(((IdpConfigAdapterMappingTasklet)o).getDescription().toLowerCase());
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.selectAdapterState.getSelectedAdapter();
    }

    public String getNonCBPOAdapterId() {
        return this.selectAdapterState.getNonCBPOAdapterId();
    }

    @Override
    public String getDescription() {
        if (this.isOverridePluginConnectionSettings() && this.overrideInstanceState.getTaskletToEdit() != null) {
            return ((PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit()).getName();
        }
        return this.getSelectedPlugin() != null ? this.getSelectedPlugin().getName() : "";
    }

    @Override
    public List<String> getContractToFulfill() {
        return this.selectAdapterState.getAttributeList();
    }

    public void setNewAdapter(boolean val) {
        this.selectAdapterState.setNewAdapter(val);
    }

    @Override
    public boolean isNewAdapter() {
        return this.selectAdapterState.isNewAdapter();
    }

    @Override
    public boolean isOverridePluginConnectionSettings() {
        return this.selectAdapterState.isOverrideAdapterConnectionSettings();
    }

    @Override
    public boolean isOverridePluginPopulated() {
        return this.isOverridePluginConnectionSettings() && this.overrideInstanceState.getTaskletToEdit() != null && this.overrideInstanceState.getTaskletToEdit().getPopulateData() != null;
    }

    @Override
    public List<String> getPluginContract() {
        if (this.isOverridePluginPopulated()) {
            PluginInstanceTasklet pluginInstanceTasklet = (PluginInstanceTasklet)this.overrideInstanceState.getTaskletToEdit();
            return pluginInstanceTasklet.getAdapterAttributeList();
        }
        return this.selectAdapterState.getAttributeList();
    }

    @Override
    public void refreshAttributeOverrides() {
        this.selectAdapterState.createAdapterAttributeList();
    }

    @Override
    public void removeConnectionOverride() {
        this.overrideInstanceState.setTaskletToEditToNull();
    }

    @Override
    public void cancel() {
        TargetAttributeMapping mapping;
        if (this.getPopulateData() != null && (mapping = (TargetAttributeMapping)this.getPopulateData()).isSavedConnectionOverride()) {
            mapping.resetAdapterInstanceId();
        }
        super.cancel();
    }

    @Override
    public AttributeMapping newDomainMapping() {
        return new TargetAttributeMapping();
    }

    @Override
    public SelectAdditionalAttributesState newAdditionalAttrsState() {
        return new SelectAdapterDataSourceState(this);
    }

    @Override
    public MappingState newMappingFulfillmentState() {
        return new IdpAdapterContractMappingState(this);
    }

    @Override
    public boolean isInitialState(TaskletState state) {
        return state instanceof SelectAdapterState;
    }

    @Override
    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        super.addStandardSourcesToPropertySelectionSources(sources);
        AccountLinkingApi ala = this.findParent(AccountLinkingApi.class);
        if (ala.isAccountLinkingEnabled()) {
            String[] alValues = new String[]{IdpConnection.getLocalIdSubstitutionKey()};
            sources.addPropertySelectionSource("AccountLink", new StringPairPropertySelectionModel(true, alValues));
        }
        this.addExtendedPropertiesToSelectionSources(sources);
    }
}

