/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.ConfigureCustomSourceFiltersState;
import com.pingidentity.fsm.state.impl.IdpConfigDatabaseFilterState;
import com.pingidentity.fsm.state.impl.IdpConfigLdapDirSearchState;
import com.pingidentity.fsm.state.impl.IdpConfigLdapFilterState;
import com.pingidentity.fsm.state.impl.MappingState;
import com.pingidentity.fsm.state.impl.SelectAdditionalAttributesState;
import com.pingidentity.fsm.state.impl.SelectCustomSourceFieldsState;
import com.pingidentity.fsm.state.impl.SelectDataSourceState;
import com.pingidentity.fsm.state.impl.SelectDatabaseTableAndColumnsState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.VirtualServerIdMappingState;
import com.pingidentity.fsm.state.issuancecriteria.impl.IdpConfigIssuanceCriteriaState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.AbstractViewOnlyTasklet;
import com.pingidentity.sources.CustomDataSourceDriverDescriptor;
import com.pingidentity.sources.SourceDescriptor;
import com.pingidentity.util.MappingUtil;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.mgmt.DataSourceManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;
import org.sourceid.websso.Protocol;

public abstract class IdpConfigSessionMappingTasklet
extends AbstractViewOnlyTasklet
implements AttributeSourceApi {
    private static final long serialVersionUID = 1L;
    protected final VirtualServerIdMappingState virtualServerIdMappingState;
    protected final SelectAdditionalAttributesState selectAdditionalAttrSourceState;
    private final SelectDataSourceState selectDataSourceState;
    private final SelectDatabaseTableAndColumnsState selectDatabaseTableAndColumnsState;
    private final IdpConfigDatabaseFilterState configDatabaseFilterState;
    private final MappingState databaseConfigAttributeMappingState;
    private final ConfigLdapDirSearchState configLdapDirSearchState;
    private final IdpConfigLdapFilterState idpConfigLdapFilterState;
    private final MappingState ldapConfigAttributeMappingState;
    private final ConfigureCustomSourceFiltersState customConfigFilterFieldsState;
    private final MappingState customConfigAttributeMappingState;
    private final SelectCustomSourceFieldsState selectCustomFieldsState;
    private final MappingState onlyAssertionConfigAttributeMappingState;
    private final IdpConfigIssuanceCriteriaState issuanceCriteriaState;
    private final SummaryCardState summaryCardState;

    public abstract AttributeMapping newDomainMapping();

    public abstract SelectAdditionalAttributesState newAdditionalAttrsState();

    public abstract MappingState newMappingFulfillmentState();

    public abstract boolean isInitialState(TaskletState var1);

    public IdpConfigSessionMappingTasklet(Visit visit) {
        this.setSystemVisit(visit);
        this.virtualServerIdMappingState = new VirtualServerIdMappingState(this);
        this.selectAdditionalAttrSourceState = this.newAdditionalAttrsState();
        this.selectDataSourceState = new SelectDataSourceState(this, "idpSelectDataSource");
        this.selectDatabaseTableAndColumnsState = new SelectDatabaseTableAndColumnsState(this);
        this.configDatabaseFilterState = new IdpConfigDatabaseFilterState(this, "idpConfigDatabaseFilter");
        this.configLdapDirSearchState = new IdpConfigLdapDirSearchState(this);
        this.idpConfigLdapFilterState = new IdpConfigLdapFilterState(this, "idpConfigLdapFilter");
        this.databaseConfigAttributeMappingState = this.newMappingFulfillmentState();
        this.ldapConfigAttributeMappingState = this.newMappingFulfillmentState();
        this.onlyAssertionConfigAttributeMappingState = this.newMappingFulfillmentState();
        this.customConfigFilterFieldsState = new ConfigureCustomSourceFiltersState(this);
        this.customConfigAttributeMappingState = this.newMappingFulfillmentState();
        this.selectCustomFieldsState = new SelectCustomSourceFieldsState(this);
        this.issuanceCriteriaState = new IdpConfigIssuanceCriteriaState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.setCancelAvailable(true);
    }

    protected void initTransitions() {
        this.initInitialTransitions();
        this.createNoAdditionalValuesTransitions();
    }

    protected void initInitialTransitions() {
        this.getInitialState().addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.virtualServerIdMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                ConnectionTasklet connectionTasklet = IdpConfigSessionMappingTasklet.this.getParentTasklet().findParent(IdpConnectionConfigTasklet.class);
                return connectionTasklet != null && !connectionTasklet.getVirtualEntityIds().isEmpty();
            }
        });
        this.getInitialState().addOutgoingTransition(this, this.selectAdditionalAttrSourceState);
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletState state = (TaskletState)this.getSourceState();
        TaskletTransition tt = null;
        do {
            state.getSummary(summaryList);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        AdministrativeUser user = this.getSystemVisit().getCurrentUser();
        return !user.isAuditor();
    }

    @Override
    public void finish() {
        AttributeMapping mapping = this.newDomainMapping();
        this.save(mapping);
        this.setPopulateData(mapping);
        super.finish();
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        if (!this.isInitialState(curState)) {
            this.clearAllStatesOutgoingTransitions(curState);
        }
        if (curState instanceof SelectAdditionalAttributesState) {
            SelectAdditionalAttributesState state = (SelectAdditionalAttributesState)curState;
            if (state.includeAdditionalAttributes()) {
                this.selectAdditionalAttrSourceState.addOutgoingTransition(this, this.selectDataSourceState);
                this.configureSelectDataSourceStateTransitions();
            } else {
                this.createNoAdditionalValuesTransitions();
            }
        } else if (curState instanceof SelectDataSourceState) {
            this.configureSelectDataSourceStateTransitions();
        }
    }

    protected void configureSelectDataSourceStateTransitions() {
        DataSource.DSType curType = this.selectDataSourceState.getDataSourceType();
        switch (curType) {
            case Other: {
                this.createCustomTransitions();
                break;
            }
            case JDBC: {
                this.createJdbcTransitions();
                break;
            }
            case LDAP: {
                this.createLdapTransitions();
                break;
            }
            case None: {
                this.selectDataSourceState.addOutgoingTransition(this, this.summaryCardState);
            }
        }
    }

    protected void createNoAdditionalValuesTransitions() {
        this.virtualServerIdMappingState.addOutgoingTransition(this, this.selectAdditionalAttrSourceState);
        this.selectAdditionalAttrSourceState.addOutgoingTransition(this, this.onlyAssertionConfigAttributeMappingState);
        this.onlyAssertionConfigAttributeMappingState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createLdapTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.configLdapDirSearchState);
        this.selectDataSourceState.setMode(this.getMode());
        this.configLdapDirSearchState.addOutgoingTransition(this, this.idpConfigLdapFilterState);
        this.idpConfigLdapFilterState.addOutgoingTransition(this, this.ldapConfigAttributeMappingState);
        this.ldapConfigAttributeMappingState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createJdbcTransitions() {
        this.selectDataSourceState.addOutgoingTransition(this, this.selectDatabaseTableAndColumnsState);
        this.selectDataSourceState.setMode(this.getMode());
        this.selectDatabaseTableAndColumnsState.addOutgoingTransition(this, this.configDatabaseFilterState);
        this.configDatabaseFilterState.addOutgoingTransition(this, this.databaseConfigAttributeMappingState);
        this.databaseConfigAttributeMappingState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createCustomTransitions() {
        this.selectDataSourceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.customConfigFilterFieldsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = IdpConfigSessionMappingTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                return instance == null || descriptor == null ? false : descriptor instanceof CustomDataSourceDriverDescriptor;
            }
        });
        this.selectDataSourceState.addOutgoingTransition(this, this.selectCustomFieldsState);
        this.selectDataSourceState.setMode(this.getMode());
        this.customConfigFilterFieldsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectCustomFieldsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                CustomDataSource instance = IdpConfigSessionMappingTasklet.this.getSelectedCustomDataSource();
                SourceDescriptor descriptor = null;
                if (instance != null && instance.getDriverClassName() != null) {
                    DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
                    descriptor = dsMgr.getSourceDescriptor(instance.getDriverClassName());
                }
                if (instance == null || descriptor == null) {
                    return true;
                }
                if (descriptor instanceof CustomDataSourceDriverDescriptor) {
                    return ((CustomDataSourceDriverDescriptor)descriptor).isShowSelectCustomSourceFields();
                }
                return true;
            }
        });
        this.customConfigFilterFieldsState.addOutgoingTransition(this, this.customConfigAttributeMappingState);
        this.selectCustomFieldsState.addOutgoingTransition(this, this.customConfigAttributeMappingState);
        this.customConfigAttributeMappingState.addOutgoingTransition(this, this.issuanceCriteriaState);
        this.issuanceCriteriaState.addOutgoingTransition(this, this.summaryCardState);
    }

    @Override
    public boolean isDataStoreAvailable(DataSource dataSource) {
        if (dataSource != null) {
            DataSourceManager dsMgr = MgmtFactory.getDataSourceManager();
            return dsMgr.test(dataSource);
        }
        return false;
    }

    @Override
    public boolean setStatesToVOMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(true, this.getTaskletName() + "_SelectDataSourceStateVo");
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(true, this.getTaskletName() + "_SelectDatabaseTableAndColumnsStateVo");
            this.configDatabaseFilterState.setViewOnly(true, this.getTaskletName() + "_IdpConfigDatabaseFilterStateVo");
            this.databaseConfigAttributeMappingState.setViewOnly(true, this.getTaskletName() + "_MappingStateVo");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(true, this.getTaskletName() + "_ConfigLdapDirSearchStateVo");
            this.idpConfigLdapFilterState.setViewOnly(true, this.getTaskletName() + "_ConfigLdapFilterStateVo");
            this.ldapConfigAttributeMappingState.setViewOnly(true, this.getTaskletName() + "_MappingStateVo");
        }
        return false;
    }

    @Override
    public boolean setStatesToEditMode(DataSource dataSource) {
        this.selectDataSourceState.setViewOnly(false, this.getTaskletName() + "_SelectDataSourceState");
        if (dataSource instanceof JdbcDataSource) {
            this.selectDatabaseTableAndColumnsState.setViewOnly(false, this.getTaskletName() + "_SelectDatabaseTableAndColumnsState");
            this.configDatabaseFilterState.setViewOnly(false, this.getTaskletName() + "_IdpConfigDatabaseFilterState");
            this.databaseConfigAttributeMappingState.setViewOnly(false, this.getTaskletName() + "_MappingState");
        } else if (dataSource instanceof LdapDataSource) {
            this.configLdapDirSearchState.setViewOnly(false, this.getTaskletName() + "_ConfigLdapDirSearchState");
            this.idpConfigLdapFilterState.setViewOnly(false, this.getTaskletName() + "_ConfigLdapFilterState");
            this.ldapConfigAttributeMappingState.setViewOnly(false, this.getTaskletName() + "_MappingState");
        }
        return false;
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return this.selectAdditionalAttrSourceState.getSelectedRadioValue();
    }

    @Override
    public boolean includeAdditionalValues() {
        return this.selectAdditionalAttrSourceState.includeAdditionalAttributes();
    }

    @Override
    public String getDataSourceType() {
        return this.selectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.selectDataSourceState.getSelectedDataSource();
    }

    @Override
    public List<String> getSelectedColumns() {
        return this.selectDatabaseTableAndColumnsState.getSelectedColumns();
    }

    @Override
    public List<String> getSelectedAttributes() {
        return this.configLdapDirSearchState.getSelectedAttributes();
    }

    @Override
    public List<String> getAllColumns() {
        return this.selectDatabaseTableAndColumnsState.getAllColumns();
    }

    @Override
    public List<String> getAllAttributes() {
        return this.configLdapDirSearchState.getAllAttributes();
    }

    @Override
    public String getTableName() {
        return this.selectDatabaseTableAndColumnsState.getSelectedTable();
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return AttributeSourceApi.ConnectionType.IDP;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    public List<String> getVirtualServerIds() {
        return this.virtualServerIdMappingState.getRestrictedVirtualServerIds();
    }

    @Override
    public String getType() {
        return this.selectDataSourceState.getDataSourceTypeString();
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return this.selectDataSourceState.getSelectedCustomAttributeSource();
    }

    @Override
    public List<String> getSelectedFields() {
        return this.selectCustomFieldsState.getSelectedFields();
    }

    @Override
    public List<String> getAllFields() {
        return this.selectCustomFieldsState.getAllFields();
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        AttributeNamesApi ana = this.findParent(AttributeNamesApi.class);
        List<String> attrNamesSorted = ana.getAllAttrNamesSorted();
        String[] values = attrNamesSorted.toArray(new String[attrNamesSorted.size()]);
        StringPairPropertySelectionModel assertionSelModel = new StringPairPropertySelectionModel(true, values);
        String assertionLabel = "Assertion";
        ConnectionTasklet connectionTasklet = this.getParentTasklet().findParent(ConnectionTasklet.class);
        if (connectionTasklet.isConnectionProtocolOIDC()) {
            assertionLabel = "Provider Claims";
        }
        sources.addPropertySelectionSource(assertionLabel, assertionSelModel);
        if (this.includeAdditionalValues()) {
            String[] dsValues = null;
            if ("JDBC".equals(this.getDataSourceType())) {
                List<String> selectedColumns = this.getSelectedColumns();
                dsValues = selectedColumns.toArray(new String[selectedColumns.size()]);
            } else if ("LDAP".equals(this.getType())) {
                List<String> selectedAttributes = this.getSelectedAttributes();
                dsValues = selectedAttributes.toArray(new String[selectedAttributes.size()]);
            } else {
                List<String> selectedFields = this.getSelectedFields();
                dsValues = selectedFields.toArray(new String[selectedFields.size()]);
            }
            sources.addPropertySelectionSource(this.getDataSourceType(), new StringPairPropertySelectionModel(true, dsValues));
        }
        List contextTypes = SourceContextType.getProtocolDependentContextTypesForIdpBrowserSSO((Protocol)connectionTasklet.getProtocolType());
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : contextTypes) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        contextSelectionModel.sort();
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    public String getLdapSearchScope() {
        return this.configLdapDirSearchState.getSelectedSearchScope();
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        DataSource.DSType curType = this.selectDataSourceState.getDataSourceType();
        switch (curType) {
            case Other: {
                return this.customConfigAttributeMappingState.getModel();
            }
            case JDBC: {
                return this.databaseConfigAttributeMappingState.getModel();
            }
            case LDAP: {
                return this.ldapConfigAttributeMappingState.getModel();
            }
        }
        return null;
    }

    public void addExtendedPropertiesToSelectionSources(DataMap.Sources sources) {
        MappingUtil util = new MappingUtil();
        util.addExtendedPropertiesToSelectionSources(sources);
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return this.issuanceCriteriaState.getIssuanceCriteriaList();
    }
}

