/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ImportMetadataCertState;
import com.pingidentity.fsm.state.impl.ImportMetadataState;
import com.pingidentity.fsm.state.impl.MetadataSummaryState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.util.ArrayList;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.ConnectionBase;

public class ImportMetadataTasklet
extends Tasklet
implements ImportMetadataApi {
    private static final long serialVersionUID = 1L;
    private final ImportMetadataState importMetadataState = new ImportMetadataState(this);
    private final ImportMetadataCertState importMetadataCertState;
    private final MetadataSummaryState metadataSummaryState;
    private ConnectionBase connection;

    public ImportMetadataTasklet(Visit visit) {
        super("ImportMetadataTasklet", "Import Metadata");
        this.importMetadataState.setUpdateMetadata(true);
        this.importMetadataCertState = new ImportMetadataCertState(this);
        this.metadataSummaryState = new MetadataSummaryState(this);
        this.setSystemVisit(visit);
        this.setInitialState(this.importMetadataState);
        this.setCancelAvailable(true);
        this.reconfigureTransitions();
    }

    @Override
    public void reconfigureTransitions() {
        this.clearAllStatesOutgoingTransitions();
        if (this.importMetadataState.isSignedMetadataWoKeyInfo()) {
            this.importMetadataState.addOutgoingTransition(this, this.importMetadataCertState);
            this.importMetadataCertState.addOutgoingTransition(this, this.metadataSummaryState);
        } else if (this.importMetadataState.isMetadataSummaryRequired()) {
            this.importMetadataState.addOutgoingTransition(this, this.metadataSummaryState);
        }
    }

    public void setConnection(ConnectionBase connection) {
        this.connection = connection;
    }

    public ConnectionBase getConnection() {
        return this.connection;
    }

    @Override
    public XmlObject getMetadataXml() {
        return this.importMetadataState.getMetadataXml();
    }

    @Override
    public String getMetadataUrlId() {
        return this.importMetadataState.getMetadataUrlId();
    }

    @Override
    public ArrayList<SummaryInfo> getMetadataSummary() {
        ArrayList<SummaryInfo> summaryList = this.importMetadataState.getMetadataSummary();
        if (this.importMetadataState.isSignedMetadataWoKeyInfo()) {
            this.importMetadataCertState.getSummary(summaryList);
        }
        return summaryList;
    }

    @Override
    public void importConnection() {
        this.importMetadataState.importConnection();
    }

    @Override
    public void finish() {
        ConnectionBase mergedConnection = this.importMetadataState.getImportedConnection();
        this.save(mergedConnection);
        this.setPopulateData(mergedConnection);
        super.finish();
    }

    @Override
    public Integer getMetadataType() {
        return this.importMetadataState.getMetadataType();
    }

    @Override
    public boolean save(Object dataToDisk) {
        boolean saveSuccesful = super.save(dataToDisk);
        this.importMetadataState.reset();
        return saveSuccesful;
    }
}

