/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.InboundProvisioningAttributeContractState;
import com.pingidentity.fsm.state.impl.InboundProvisioningMappingState;
import com.pingidentity.fsm.state.impl.InboundProvisioningOperationState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.UserProvisioningAttributesState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.api.IdentityStoreProvisionerApi;
import com.pingidentity.fsm.tasklet.impl.InboundProvisioningTasklet;
import com.pingidentity.util.SAML2MappingModel;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.BaseComponent;
import org.apache.tapestry.form.IPropertySelectionModel;
import org.apache.tapestry.valid.IValidationDelegate;
import org.sourceid.saml20.domain.AttributeContract;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.GroupConstants;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.InboundProvisioningUserRepositoryType;
import org.sourceid.saml20.domain.LdapDataSource;
import org.sourceid.saml20.domain.ScimUserConstants;
import org.sourceid.saml20.domain.ScimUserConstantsFactory;
import org.sourceid.saml20.domain.SourceContextType;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;
import org.sourceid.saml20.domain.UserConstants;
import org.sourceid.saml20.domain.scim.ScimUserProvisioning;
import org.sourceid.saml20.domain.scim.ScimVersion;

public class InboundProvisioningOperationTasklet
extends Tasklet
implements AttributeSourceApi,
IdentityStoreProvisionerApi {
    private static final long serialVersionUID = 1L;
    final InboundProvisioningAttributeContractState inboundProvisioningAttributeContractState;
    final UserProvisioningAttributesState userProvisioningAttributesState;
    final InboundProvisioningMappingState mappingState;
    final SummaryCardState summaryCardState;
    private InboundProvisioningOperationState.OperationType operationType;
    private InboundProvisioningUserRepositoryType userRepositoryType = InboundProvisioningUserRepositoryType.NONE;
    private ScimVersion scimVersion = ScimVersion.SCIM11;

    public InboundProvisioningOperationTasklet(Visit visit) {
        super("InboundProvisioningOperationTasklet");
        this.setSystemVisit(visit);
        this.inboundProvisioningAttributeContractState = new InboundProvisioningAttributeContractState(this);
        this.userProvisioningAttributesState = new UserProvisioningAttributesState(this);
        this.mappingState = new InboundProvisioningMappingState(this, "ldapUserProvisioningAdapterContractMapping");
        this.summaryCardState = new SummaryCardState(this);
        this.setCancelAvailable(true);
    }

    public void configureTasklet() {
        if (this.operationType == InboundProvisioningOperationState.OperationType.READ_USERS) {
            this.inboundProvisioningAttributeContractState.setHelpId("InboundProvisioningAttributeContractReadUsersState");
            this.userProvisioningAttributesState.setHelpId("UserProvisioningAttributesReadUsersState");
            this.mappingState.setHelpId("InboundProvisioningMappingReadUsersState");
            this.summaryCardState.setHelpId("SummaryCardReadUsersState");
            this.setInitialState(this.inboundProvisioningAttributeContractState);
        } else if (this.operationType == InboundProvisioningOperationState.OperationType.READ_GROUPS) {
            this.inboundProvisioningAttributeContractState.setHelpId("InboundProvisioningAttributeContractReadGroupsState");
            this.userProvisioningAttributesState.setHelpId("userProvisioningAttributesReadGroupsState");
            this.mappingState.setHelpId("InboundProvisioningMappingReadGroupsState");
            this.summaryCardState.setHelpId("SummaryCardReadGroupsState");
            this.setInitialState(this.inboundProvisioningAttributeContractState);
        } else if (this.operationType == InboundProvisioningOperationState.OperationType.WRITE_GROUPS) {
            this.userProvisioningAttributesState.setHelpId("UserProvisioningAttributesWriteGroupsState");
            this.mappingState.setHelpId("InboundProvisioningMappingWriteGroupsState");
            this.summaryCardState.setHelpId("SummaryCardWriteGroupsState");
            if (this.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
                this.setInitialState(this.mappingState);
            } else {
                this.setInitialState(this.userProvisioningAttributesState);
            }
        } else {
            this.userProvisioningAttributesState.setHelpId("UserProvisioningAttributesWriteUsersState");
            this.mappingState.setHelpId("InboundProvisioningMappingWriteUsersState");
            this.summaryCardState.setHelpId("SummaryCardWriteUsersState");
            if (this.getUserRepositoryType() == InboundProvisioningUserRepositoryType.IDENTITY_STORE) {
                this.setInitialState(this.mappingState);
            } else {
                this.setInitialState(this.userProvisioningAttributesState);
            }
        }
        this.reconfigureTransitions(this.getInitialState());
    }

    protected void createLdapTransitions() {
        this.inboundProvisioningAttributeContractState.addOutgoingTransition(this, this.userProvisioningAttributesState);
        this.userProvisioningAttributesState.addOutgoingTransition(this, this.mappingState);
        this.mappingState.addOutgoingTransition(this, this.summaryCardState);
    }

    protected void createIdentityStoreProvisionerTransitions() {
        switch (this.operationType) {
            case READ_USERS: {
                this.inboundProvisioningAttributeContractState.addOutgoingTransition(this, this.mappingState);
                this.mappingState.addOutgoingTransition(this, this.summaryCardState);
                break;
            }
            case WRITE_USERS: {
                this.mappingState.addOutgoingTransition(this, this.summaryCardState);
                break;
            }
            case READ_GROUPS: {
                this.inboundProvisioningAttributeContractState.addOutgoingTransition(this, this.mappingState);
                this.mappingState.addOutgoingTransition(this, this.summaryCardState);
                break;
            }
            case WRITE_GROUPS: {
                this.inboundProvisioningAttributeContractState.addOutgoingTransition(this, this.mappingState);
                this.mappingState.addOutgoingTransition(this, this.summaryCardState);
                break;
            }
            default: {
                throw new RuntimeException("invalid operation type");
            }
        }
    }

    public boolean setStatesToVOMode(DataSource dataSource) {
        if (dataSource instanceof LdapDataSource) {
            this.userProvisioningAttributesState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningAttributesStateVo");
            this.mappingState.setViewOnly(true, this.getTaskletName() + "_UserProvisioningAdapterContractMappingStateVo");
        }
        return false;
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        idpConnection.setInboundProvisioning(new ScimUserProvisioning());
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    protected void createDefaultTransitions() {
        this.userProvisioningAttributesState.addOutgoingTransition(this, this.summaryCardState);
    }

    public DataSource.DSType getUserRepoDataSourceType() {
        InboundProvisioningTasklet tasklet = this.findParent(InboundProvisioningTasklet.class);
        return tasklet.getUserRepoDataSourceType();
    }

    public void addStandardSourcesToPropertySelectionSources(DataMap.Sources sources) {
        block0 : switch (this.operationType) {
            case WRITE_USERS: {
                sources.addPropertySelectionSource("SCIM User", this.getScimUserMessageValues());
                break;
            }
            case READ_USERS: {
                StringPairPropertySelectionModel model;
                List<String> attributes;
                switch (this.getUserRepositoryType()) {
                    case ACTIVE_DIRECTORY: {
                        sources.addPropertySelectionSource("LDAP", this.getSelectedLdapValues());
                        break block0;
                    }
                    case IDENTITY_STORE: {
                        attributes = this.getContractAttributes();
                        model = new StringPairPropertySelectionModel(true, attributes);
                        sources.addPropertySelectionSource("Identity Store User", model);
                        break block0;
                    }
                }
                break;
            }
            case WRITE_GROUPS: {
                sources.addPropertySelectionSource("SCIM Group", this.getScimGroupMessageValues());
                break;
            }
            case READ_GROUPS: {
                StringPairPropertySelectionModel model;
                List<String> attributes;
                switch (this.getUserRepositoryType()) {
                    case ACTIVE_DIRECTORY: {
                        sources.addPropertySelectionSource("LDAP", this.getSelectedLdapValues());
                        break block0;
                    }
                    case IDENTITY_STORE: {
                        attributes = this.getGroupContractAttributes();
                        model = new StringPairPropertySelectionModel(true, attributes);
                        sources.addPropertySelectionSource("Identity Store Group", model);
                        break block0;
                    }
                }
                break;
            }
        }
        StringPairPropertySelectionModel contextSelectionModel = new StringPairPropertySelectionModel(true);
        for (SourceContextType sct : SourceContextType.getContextTypesForInboundProv()) {
            contextSelectionModel.add(sct.getDescription(), sct.getId());
        }
        sources.addPropertySelectionSource("Context", contextSelectionModel);
    }

    public Set<String> getWriteContractAttributeFulfillmentValues() {
        return this.mappingState.getWriteContractAttributeFulfillmentValues();
    }

    private IPropertySelectionModel getScimUserMessageValues() {
        LinkedList<String> ids = new LinkedList<String>();
        ScimUserConstants scimUserConstants = ScimUserConstantsFactory.getScimUserConstants((ScimVersion)this.getScimVersion());
        switch (this.getUserRepositoryType()) {
            case ACTIVE_DIRECTORY: {
                ids.addAll(scimUserConstants.getAllMappableIdsForWriteUsers());
                ids.addAll(this.getCustomAttributeIds());
                break;
            }
            case IDENTITY_STORE: {
                ids.addAll(scimUserConstants.getAllMappableIdsForIdentityStorePluginWriteUsers());
                ids.addAll(this.getCustomAttributeIds());
                break;
            }
        }
        return new StringPairPropertySelectionModel(true, ids);
    }

    private IPropertySelectionModel getScimGroupMessageValues() {
        LinkedList<String> ids = new LinkedList<String>();
        switch (this.getUserRepositoryType()) {
            case ACTIVE_DIRECTORY: {
                ids.addAll(GroupConstants.getAllMappableIdsForWriteGroups());
                break;
            }
            case IDENTITY_STORE: {
                ids.addAll(GroupConstants.getAllMappableIdsForIdentityStorePluginWriteGroups());
                break;
            }
        }
        return new StringPairPropertySelectionModel(true, ids);
    }

    private IPropertySelectionModel getSelectedLdapValues() {
        List<String> values = this.getSelectedAttributes();
        if (values != null) {
            return new StringPairPropertySelectionModel(true, values.toArray(new String[0]));
        }
        return new StringPairPropertySelectionModel(true, new String[0]);
    }

    public InboundProvisioningOperationState.OperationType getOperationType() {
        return this.operationType;
    }

    public void setOperationType(InboundProvisioningOperationState.OperationType operationType) {
        this.operationType = operationType;
    }

    public InboundProvisioningUserRepositoryType getUserRepositoryType() {
        return this.userRepositoryType;
    }

    public void setUserRepositoryType(InboundProvisioningUserRepositoryType userRepositoryType) {
        this.userRepositoryType = userRepositoryType;
    }

    public ScimVersion getScimVersion() {
        return this.scimVersion;
    }

    public void setScimVersion(ScimVersion version) {
        this.scimVersion = version;
    }

    public AttributeContract getContract() {
        return this.inboundProvisioningAttributeContractState.getContract();
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions();
        block0 : switch (this.getUserRepositoryType()) {
            case ACTIVE_DIRECTORY: {
                switch (this.getUserRepoDataSourceType()) {
                    case LDAP: {
                        this.createLdapTransitions();
                        break block0;
                    }
                }
                this.createDefaultTransitions();
                break;
            }
            case IDENTITY_STORE: {
                this.createIdentityStoreProvisionerTransitions();
                break;
            }
            default: {
                this.createDefaultTransitions();
            }
        }
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return this.findParent(InboundProvisioningTasklet.class).getSelectedCustomDataSource();
    }

    @Override
    public boolean includeAdditionalValues() {
        return this.findParent(InboundProvisioningTasklet.class).includeAdditionalValues();
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return this.findParent(InboundProvisioningTasklet.class).getConnectionType();
    }

    @Override
    public String getDescription() {
        return this.findParent(InboundProvisioningTasklet.class).getDescription();
    }

    @Override
    public String getType() {
        return this.findParent(InboundProvisioningTasklet.class).getType();
    }

    @Override
    public String getDataSourceType() {
        return this.findParent(InboundProvisioningTasklet.class).getDataSourceType();
    }

    @Override
    public List<String> getSelectedColumns() {
        return this.findParent(InboundProvisioningTasklet.class).getSelectedColumns();
    }

    @Override
    public List<String> getSelectedAttributes() {
        switch (this.getUserRepoDataSourceType()) {
            case LDAP: {
                return this.userProvisioningAttributesState.getSelectedAttributes();
            }
        }
        return null;
    }

    @Override
    public List<String> getSelectedFields() {
        return this.findParent(InboundProvisioningTasklet.class).getSelectedFields();
    }

    @Override
    public List<String> getAllColumns() {
        return this.findParent(InboundProvisioningTasklet.class).getAllColumns();
    }

    @Override
    public List<String> getAllAttributes() {
        return this.findParent(InboundProvisioningTasklet.class).getAllAttributes();
    }

    @Override
    public List<String> getAllFields() {
        return this.findParent(InboundProvisioningTasklet.class).getAllFields();
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.findParent(InboundProvisioningTasklet.class).getSelectedDataSource();
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return this.findParent(InboundProvisioningTasklet.class).getSelectedPlugin();
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return this.findParent(InboundProvisioningTasklet.class).getSelectedAdapterDataSource();
    }

    @Override
    public List<String> getContractToFulfill() {
        LinkedList<String> contract = new LinkedList<String>();
        List all = null;
        ScimUserConstants userConstants = ScimUserConstantsFactory.getScimUserConstants((ScimVersion)this.getScimVersion());
        block0 : switch (this.operationType) {
            case READ_USERS: {
                all = this.getContract().getAllAttrNamesSorted();
                all.remove(UserConstants.PASSWORD.toString());
                contract.addAll(all);
                break;
            }
            case WRITE_USERS: {
                switch (this.getUserRepositoryType()) {
                    case ACTIVE_DIRECTORY: {
                        contract.addAll(userConstants.getAllMappableIdsForWriteUsers());
                        break;
                    }
                    case IDENTITY_STORE: {
                        contract.addAll(userConstants.getAllMappableIdsForIdentityStorePluginWriteUsers());
                        break;
                    }
                }
                if (this.getCustomAttributeIds().isEmpty()) break;
                contract.add("CUSTOM ATTRIBUTES WITH EXTENSION SCHEMA NAME: " + this.getCustomAttributeSchemaName());
                contract.addAll(this.getCustomAttributeIds());
                break;
            }
            case READ_GROUPS: {
                all = this.getContract().getAllAttrNamesSorted();
                contract.addAll(all);
                break;
            }
            case WRITE_GROUPS: {
                switch (this.getUserRepositoryType()) {
                    case ACTIVE_DIRECTORY: {
                        contract.addAll(GroupConstants.getAllMappableIdsForWriteGroups());
                        break block0;
                    }
                    case IDENTITY_STORE: {
                        contract.addAll(GroupConstants.getAllMappableIdsForIdentityStorePluginWriteGroups());
                        break block0;
                    }
                }
                break;
            }
        }
        return contract;
    }

    @Override
    public boolean isDataStoreAvailable(DataSource dataSource) {
        return this.findParent(InboundProvisioningTasklet.class).isDataStoreAvailable(dataSource);
    }

    @Override
    public List<String> getContractAttributes() {
        return this.findParent(InboundProvisioningTasklet.class).getContractAttributes();
    }

    @Override
    public List<String> getGroupContractAttributes() {
        return this.findParent(InboundProvisioningTasklet.class).getGroupContractAttributes();
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return this.mappingState.getModel();
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return null;
    }

    private List<String> getCustomAttributeIds() {
        return this.findParent(InboundProvisioningTasklet.class).getCustomAttributeIds();
    }

    private String getCustomAttributeSchemaName() {
        return this.findParent(InboundProvisioningTasklet.class).getCustomAttributeSchema();
    }

    @Override
    public void appendErrors(IValidationDelegate delegate, BaseComponent component, boolean fastFail) {
        this.inboundProvisioningAttributeContractState.checkErrors(delegate);
        super.appendErrors(delegate, component, fastFail);
    }
}

