/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.KerberosRealmsSettingsState;
import com.pingidentity.fsm.state.impl.KerberosRealmsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.sourceid.saml20.domain.KerberosRealm;
import org.sourceid.saml20.domain.KerberosRealmsSettings;

public class KerberosRealmsTasklet
extends Tasklet {
    private static final long serialVersionUID = 5L;
    private KerberosRealmsState kerberosRealmsState;
    private KerberosRealmsSettingsState kerberosRealmsSettingsState;

    public KerberosRealmsTasklet(Visit visit) {
        this.setSystemVisit(visit);
        this.setFinishLabel("Save");
        this.kerberosRealmsState = new KerberosRealmsState(this);
        this.kerberosRealmsSettingsState = new KerberosRealmsSettingsState(this);
        this.setInitialState(this.kerberosRealmsState);
        this.kerberosRealmsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.kerberosRealmsSettingsState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                List<Tasklet> kerberosRealmTasklets = KerberosRealmsTasklet.this.kerberosRealmsState.getTasklets();
                if (kerberosRealmTasklets != null && !kerberosRealmTasklets.isEmpty()) {
                    for (Tasklet t : kerberosRealmTasklets) {
                        if (t.isItDeleted()) continue;
                        return true;
                    }
                }
                return false;
            }
        });
        this.setCancelAvailable(true);
    }

    public boolean kerberosRealmNameExists(String kerberosRealmName, String taskletId) {
        return this.kerberosRealmsState.kerberosRealmNameExists(kerberosRealmName, taskletId);
    }

    public KerberosRealmsSettings getKerberosRealmsSettings() {
        return this.kerberosRealmsSettingsState.getKerberosRealmsSettings();
    }

    public Map<String, KerberosRealm> getKerberosRealms() {
        HashMap<String, KerberosRealm> kerberosRealms = new HashMap<String, KerberosRealm>();
        for (KerberosRealm kerberosRealm : this.kerberosRealmsState.getKerberosRealms()) {
            kerberosRealms.put(kerberosRealm.getKerberosRealmName(), kerberosRealm);
        }
        return kerberosRealms;
    }

    @Override
    public void finish() {
        if (this.isAuthorizedForAction()) {
            this.saveAllStates(null);
        }
        super.finish();
    }

    @Override
    public boolean isAuthorizedForAction() {
        return this.getCurrentUser().isAdmin();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }
}

