/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AffiliationActivationState;
import com.pingidentity.fsm.state.impl.AffiliationGeneralInfoState;
import com.pingidentity.fsm.state.impl.CreateAffiliationState;
import com.pingidentity.fsm.state.impl.ImportAffiliationMetadataState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.sourceid.saml20.domain.Affiliation;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ManageAffiliationsTasklet
extends Tasklet {
    private static final long serialVersionUID = 20050515L;
    final ImportAffiliationMetadataState importAffiliationMetadataState;
    final AffiliationGeneralInfoState affiliationGeneralInfoState;
    final CreateAffiliationState createAffiliationState;
    final AffiliationActivationState affiliationActivationState;

    public ManageAffiliationsTasklet(Visit visit) {
        super("ManageAffiliationsTasklet", "Create an Affiliation");
        this.setSystemVisit(visit);
        this.setFinishLabel("Save");
        this.importAffiliationMetadataState = new ImportAffiliationMetadataState(this);
        this.affiliationGeneralInfoState = new AffiliationGeneralInfoState(this);
        this.createAffiliationState = new CreateAffiliationState(this);
        this.affiliationActivationState = new AffiliationActivationState(this);
        this.setInitialState(this.importAffiliationMetadataState);
        this.setCancelAvailable(true);
        this.importAffiliationMetadataState.addOutgoingTransition(this, this.affiliationGeneralInfoState);
        this.affiliationGeneralInfoState.addOutgoingTransition(this, this.createAffiliationState);
        this.createAffiliationState.addOutgoingTransition(this, this.affiliationActivationState);
    }

    public void skipImportState() {
        this.setInitialState(this.affiliationGeneralInfoState);
    }

    @Override
    public void finish() {
        Affiliation affiliation = new Affiliation();
        this.setMode(Mode.edit);
        this.save(affiliation);
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        connectionManager.saveAffiliation(affiliation);
        super.finish();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public TaskletState getSummaryState() {
        return this.affiliationActivationState;
    }
}

