/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.cert.CertificateExpiryDisplay;
import com.pingidentity.fsm.state.impl.ImportMetadataState;
import com.pingidentity.fsm.state.impl.MetadataUrlCertSummaryState;
import com.pingidentity.fsm.state.impl.MetadataUrlImportCertState;
import com.pingidentity.fsm.state.impl.MetadataUrlState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.data.MetadataUrlCertItem;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.common.dsig.SignatureStatus;
import org.sourceid.common.dsig.XmlSignatureVerifier;
import org.sourceid.saml20.domain.MetadataUrlCertPair;
import org.sourceid.saml20.domain.mgmt.MetadataUrlManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;

public class MetadataUrlCertTasklet
extends Tasklet
implements ImportMetadataApi,
CertificateExpiryDisplay {
    private static final long serialVersionUID = 1L;
    private final MetadataUrlState metadataUrlState;
    private final MetadataUrlCertSummaryState metadataCertState;
    private final MetadataUrlImportCertState metadataImportCertState;
    private final SummaryCardState summaryState;
    private Cert signingCert = null;
    private boolean certTrusted = false;
    private boolean certUpdated = false;
    private boolean certUpdatedFromMetadata = true;
    private CertificateType expiryNotificationCertType;
    private final transient MetadataUrlManager metadataUrlManager = MgmtFactory.getMetadataUrlManager();

    public MetadataUrlCertTasklet(Visit visit) {
        super("MetadataUrlCertTasklet", "Metadata URL");
        this.setSystemVisit(visit);
        this.metadataUrlState = new MetadataUrlState(this);
        this.metadataCertState = new MetadataUrlCertSummaryState(this);
        this.metadataImportCertState = new MetadataUrlImportCertState(this);
        this.summaryState = new SummaryCardState(this);
        this.setInitialState(this.metadataUrlState);
        this.configureTransitions();
        this.setCancelAvailable(true);
    }

    public void configureTransitions() {
        this.metadataUrlState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.metadataImportCertState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                XmlSignatureVerifier signVerifier = MetadataUrlCertTasklet.this.metadataUrlState.getSignatureVerifier();
                return MetadataUrlCertTasklet.this.metadataUrlState.isValidateSignature() && signVerifier != null && signVerifier.hasSignature() && !signVerifier.getSignatureStatus().equals((Object)SignatureStatus.VALID);
            }
        });
        this.metadataUrlState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.metadataCertState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return MetadataUrlCertTasklet.this.metadataUrlState.isValidateSignature();
            }
        });
        this.metadataImportCertState.addOutgoingTransition(this, this.summaryState);
        this.metadataCertState.addOutgoingTransition(this, this.summaryState);
        this.metadataUrlState.addOutgoingTransition(this, this.summaryState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void resetCertSummaryPageState() {
        this.metadataCertState.resetPageState();
    }

    public String getUrl() {
        return this.metadataUrlState.getUrl();
    }

    @Override
    public String getMetadataUrlId() {
        return this.metadataUrlState.getId();
    }

    public String getMetadataUrlCertAlias() {
        Cert cert = this.getSigningCert();
        if (cert == null) {
            return null;
        }
        return cert.getAlias();
    }

    public String getName() {
        return this.metadataUrlState.getName();
    }

    public boolean isInUse() {
        return MgmtFactory.getMetadataUrlManager().isMetadataUrlInUse(this.getMetadataUrlId());
    }

    @Override
    public XmlObject getMetadataXml() {
        XmlObject metadataXml = null;
        XmlSignatureVerifier urlSignatureVerifier = this.metadataUrlState.getSignatureVerifier();
        if (urlSignatureVerifier != null) {
            metadataXml = urlSignatureVerifier.getXmlObject();
        }
        return metadataXml;
    }

    @Override
    public ArrayList<SummaryInfo> getMetadataSummary() {
        return null;
    }

    @Override
    public void importConnection() {
    }

    public Cert getSigningCert() {
        return this.signingCert;
    }

    public String getCertExpiry() {
        Cert signingCert;
        if (this.isValidateSignature() && (signingCert = this.getSigningCert()) != null) {
            Date expiration = signingCert.getX509Certificate().getNotAfter();
            return expiration.toString();
        }
        return "";
    }

    public String getCertSubjectDN() {
        Cert signingCert;
        if (this.metadataUrlState.isValidateSignature() && (signingCert = this.getSigningCert()) != null) {
            Principal principal = signingCert.getX509Certificate().getSubjectDN();
            return principal.getName();
        }
        return "";
    }

    public void setSigningCert(Cert signingCert, boolean fromMetadata) {
        this.signingCert = signingCert;
        this.certUpdatedFromMetadata = fromMetadata;
    }

    public void updateSigningCert(Cert signingCert, boolean trusted, boolean fromMetadata) {
        this.setSigningCert(signingCert, fromMetadata);
        this.certTrusted = trusted;
        this.certUpdated = true;
    }

    public boolean isCertTrusted() {
        return this.certTrusted;
    }

    public boolean isCertUpdated() {
        return this.certUpdated;
    }

    public boolean isCertUpdatedFromMetadata() {
        return this.certUpdatedFromMetadata;
    }

    public void setCertUpdatedFromMetadata(boolean updated) {
        this.certUpdatedFromMetadata = updated;
    }

    public XmlSignatureVerifier getSignatureVerifier() {
        return this.metadataUrlState.getSignatureVerifier();
    }

    @Override
    public Integer getMetadataType() {
        return ImportMetadataState.NONE;
    }

    @Override
    public void finish() {
        MetadataUrlCertItem metadataUrlCertItem = new MetadataUrlCertItem();
        this.save(metadataUrlCertItem);
        this.setPopulateData(metadataUrlCertItem);
        HashSet<Cert> certs = new HashSet<Cert>();
        if (metadataUrlCertItem.getCert() != null) {
            certs.add(metadataUrlCertItem.getCert());
        }
        ((PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager()).saveCertsForFeature(certs, metadataUrlCertItem.getId());
        String certAlias = metadataUrlCertItem.getCert() != null ? metadataUrlCertItem.getCert().getAlias() : null;
        MetadataUrlCertPair metadataUrlCertPair = new MetadataUrlCertPair(metadataUrlCertItem.getId(), metadataUrlCertItem.getUrl(), certAlias, metadataUrlCertItem.getName(), metadataUrlCertItem.isValidateSignature());
        this.metadataUrlManager.saveMetadataUrl(metadataUrlCertPair);
        super.finish();
    }

    public boolean isValidateSignature() {
        return this.metadataUrlState.isValidateSignature();
    }

    @Override
    public Cert getCertForExpiryNotification() {
        return this.getSigningCert();
    }

    @Override
    public void setCertIdForExpiryNotification(String certId) {
    }

    @Override
    public CertificateType getCertTypeForExpiryNotification() {
        return this.expiryNotificationCertType;
    }

    @Override
    public void setCertTypeForExpiryNotification(CertificateType expiryNotificationCertType) {
        this.expiryNotificationCertType = expiryNotificationCertType;
    }
}

