/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState;
import com.pingidentity.fsm.state.impl.OAuthDynamicClientRegistrationDefaultsState;
import com.pingidentity.fsm.state.impl.OAuthDynamicClientRegistrationPoliciesState;
import com.pingidentity.fsm.state.impl.OAuthDynamicClientRegistrationScopeConstraintsState;
import com.pingidentity.fsm.state.impl.OAuthDynamicClientRegistrationState;
import com.pingidentity.fsm.state.impl.OAuthDynamicClientRegistrationSummaryState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.ClientSettingManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class OAuthClientTasklet
extends Tasklet {
    private final OAuthDynamicClientRegistrationState oAuthDynamicClientRegistrationState;
    private final OAuthDynamicClientRegistrationPoliciesState oAuthDynamicClientRegistrationPoliciesState;
    private final OAuthDynamicClientRegistrationScopeConstraintsState oAuthDynamicClientRegistrationScopeConstraintsState;
    private final OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState oAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState;
    private final OAuthDynamicClientRegistrationDefaultsState oAuthDynamicClientRegistrationDefaultsState;
    private OAuthDynamicClientRegistrationSummaryState summaryCardState;

    public OAuthClientTasklet(Visit visit) {
        this.setSystemVisit(visit);
        this.setFinishLabel("Save");
        this.setCancelAvailable(true);
        ClientSettingManager clientSettingManager = MgmtFactory.getClientSettingManager();
        this.oAuthDynamicClientRegistrationState = new OAuthDynamicClientRegistrationState((IWizard)this, clientSettingManager);
        this.oAuthDynamicClientRegistrationPoliciesState = new OAuthDynamicClientRegistrationPoliciesState((IWizard)this, clientSettingManager);
        this.oAuthDynamicClientRegistrationScopeConstraintsState = new OAuthDynamicClientRegistrationScopeConstraintsState((IWizard)this, clientSettingManager);
        this.oAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState = new OAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState((IWizard)this, clientSettingManager);
        this.oAuthDynamicClientRegistrationDefaultsState = new OAuthDynamicClientRegistrationDefaultsState((IWizard)this, clientSettingManager);
        this.summaryCardState = new OAuthDynamicClientRegistrationSummaryState(this);
        this.createTransitions();
    }

    @Override
    public boolean isAuthorizedForAction() {
        return this.getCurrentUser().isAdmin();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void reconfigureTransitions(TaskletState curState) {
        this.clearAllStatesOutgoingTransitions(curState);
        this.createTransitions();
    }

    private void createTransitions() {
        this.oAuthDynamicClientRegistrationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.oAuthDynamicClientRegistrationScopeConstraintsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return OAuthClientTasklet.this.oAuthDynamicClientRegistrationState.isEnableDynamicClientRegistration();
            }
        });
        this.oAuthDynamicClientRegistrationScopeConstraintsState.addOutgoingTransition(this, this.oAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState);
        this.oAuthDynamicClientRegistrationAuthorizationDetailTypesConstraintsState.addOutgoingTransition(this, this.oAuthDynamicClientRegistrationDefaultsState);
        this.oAuthDynamicClientRegistrationDefaultsState.addOutgoingTransition(this, this.oAuthDynamicClientRegistrationPoliciesState);
        this.oAuthDynamicClientRegistrationPoliciesState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !OAuthClientTasklet.this.isSkipPopToParent();
            }
        });
        this.setInitialState(this.oAuthDynamicClientRegistrationState);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void finish() {
        if (this.isAuthorizedForAction()) {
            ClientSettingManager clientSettingManager = MgmtFactory.getClientSettingManager();
            ClientSetting clientSetting = clientSettingManager.getClientSetting();
            this.setMode(Mode.edit);
            this.saveAllStates(clientSetting);
            clientSettingManager.saveClientSetting(clientSetting);
            DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
            DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
            dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)clientSetting, DependencyType.OAUTH_CLIENT_SETTINGS);
        }
        super.finish();
    }

    @Override
    public String getFinishLabel() {
        return this.isAuthorizedForAction() ? "Save" : "Next";
    }

    @Override
    public void setSkipPopToParent(boolean skipPopToParent) {
        super.setSkipPopToParent(skipPopToParent);
        this.summaryCardState = null;
    }

    public OAuthDynamicClientRegistrationState getOAuthDynamicClientRegistrationState() {
        return this.oAuthDynamicClientRegistrationState;
    }

    public boolean isBackendDatabase() {
        return MgmtFactory.getClientManager().isBackendDatabase();
    }
}

