/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.OAuthSAML2TargetMappingListState;
import com.pingidentity.fsm.state.impl.OAuthSAML2TargetMappingTasklet;
import com.pingidentity.fsm.state.impl.OAuthSAMLCreateAttributeContractState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;

public class OAuthSAMLGrantAttributeMappingTasklet
extends MultiProtocolTasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 20050547L;
    final CreateAttributeContractState createAttributeContractState;
    final OAuthSAML2TargetMappingListState oAuthSAML2TargetMappingListState;
    final SummaryCardState summaryCardState;

    public OAuthSAMLGrantAttributeMappingTasklet(Visit visit) {
        super("OAuthSAMLGrantAttributeMappingTasklet", "OAuth Assertion Grant Attribute Mapping");
        this.setSystemVisit(visit);
        this.createAttributeContractState = new OAuthSAMLCreateAttributeContractState(this, "createAttributeContract");
        this.oAuthSAML2TargetMappingListState = new OAuthSAML2TargetMappingListState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.createAttributeContractState.addOutgoingTransition(this, this.oAuthSAML2TargetMappingListState);
        this.oAuthSAML2TargetMappingListState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.createAttributeContractState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    public StringPairPropertySelectionModel getTokenManagerList() {
        StringPairPropertySelectionModel tokenManagerList = new StringPairPropertySelectionModel(true);
        List<Tasklet> tasklets = this.oAuthSAML2TargetMappingListState.getTasklets();
        Collection instances = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getInstances();
        for (BearerAccessTokenMgmtPluginInstance tokenManagerMapping : instances) {
            boolean tokenManagerInUse = this.isTokenManagerInUseByThisConnection(tokenManagerMapping, tasklets);
            if (tokenManagerInUse) continue;
            tokenManagerList.add(tokenManagerMapping.getName(), tokenManagerMapping);
        }
        tokenManagerList.sort();
        return tokenManagerList;
    }

    private boolean isTokenManagerInUseByThisConnection(BearerAccessTokenMgmtPluginInstance tokenMgrMapping, List<Tasklet> tasklets) {
        if (tasklets != null) {
            for (Tasklet t : tasklets) {
                OAuthSAML2TargetMappingTasklet mappingTasklet = (OAuthSAML2TargetMappingTasklet)t;
                if (mappingTasklet.getSelectedTokenManager() == null || !tokenMgrMapping.getId().equals(mappingTasklet.getSelectedTokenManagerId())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getTokenManagerIdsUsedInMappings() {
        ArrayList<String> tokenManagerIds = new ArrayList<String>();
        List<Tasklet> tasklets = this.oAuthSAML2TargetMappingListState.getTasklets();
        if (tasklets != null) {
            for (Tasklet tasklet : tasklets) {
                OAuthSAML2TargetMappingTasklet mappingTasklet = (OAuthSAML2TargetMappingTasklet)tasklet;
                BearerAccessTokenMgmtPluginInstance instance = mappingTasklet.getSelectedTokenManager();
                if (instance == null) continue;
                tokenManagerIds.add(instance.getId());
            }
        }
        return tokenManagerIds;
    }

    @Override
    public Protocol getProtocolType() {
        return ((MultiProtocolTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.createAttributeContractState.getContract().getImmutableAttributeNames();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.createAttributeContractState.getContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.createAttributeContractState.getContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.createAttributeContractState.getContract().getSortedMutableAttributeNames();
    }
}

