/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.crypto.CertificateType;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.cert.CertificateExpiryDisplay;
import com.pingidentity.fsm.state.impl.AttributeValueMaskState;
import com.pingidentity.fsm.state.impl.AuthnAdapterActionState;
import com.pingidentity.fsm.state.impl.BaseSelectPluginTypeState;
import com.pingidentity.fsm.state.impl.ConfigureAuthnAdapterState;
import com.pingidentity.fsm.state.impl.CreateAdapterContractState;
import com.pingidentity.fsm.state.impl.PluginContractState;
import com.pingidentity.fsm.state.impl.SelectAdapterTypeState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.TokenPluginMgmtState;
import com.pingidentity.fsm.state.impl.WsTrustTokenProcessorInstanceState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletListState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.PluginInstanceApi;
import com.pingidentity.fsm.tasklet.comparator.PluginHierarchyComparator;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.WsTrustSpTokenCreationTasklet;
import com.pingidentity.fsm.tasklet.impl.WsTrustTokenGenerationTasklet;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.valid.ValidationDelegate;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.gui.EncryptionCertificateFieldDescriptor;
import org.sourceid.saml20.adapter.gui.FieldDescriptor;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PkCertAndConnectionCertManager;
import org.sourceid.saml20.domain.mgmt.PluginManager;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.util.IdUtil;

public class PluginInstanceTasklet
extends Tasklet
implements PluginInstanceApi,
CertificateExpiryDisplay {
    private static final long serialVersionUID = 20050515L;
    private boolean saveCalled;
    protected final BaseSelectPluginTypeState selectPluginTypeState = this.createSelectTypeState();
    protected final ConfigureAuthnAdapterState configureAdapterState = new ConfigureAuthnAdapterState(this);
    protected final AuthnAdapterActionState adapterActionState = new AuthnAdapterActionState(this);
    protected final CreateAdapterContractState createAdapterContractState = new CreateAdapterContractState(this);
    protected final PluginContractState pluginContractState = new PluginContractState(this);
    protected final AttributeValueMaskState attributeValueMaskState = new AttributeValueMaskState(this);
    protected final SummaryCardState summaryState = new SummaryCardState(this);
    private final transient PkCertAndConnectionCertManager certManager = (PkCertAndConnectionCertManager)MgmtFactory.getDsigPkCertManager();
    private transient PluginManager<?, ?> pluginManager;
    private boolean isTokenProcessorInstanceTasklet;
    private int pluginDepth;
    private boolean isNewTasklet = false;
    private boolean connectionOverrideMode;
    private boolean defaultInstance = false;
    private boolean disabled;
    private PluginManagementSupport.PluginManagementType pluginType;
    private AdminAuditLogger.Component auditLoggerComponent;
    private boolean overrideAutoSave = false;
    private CertificateType expiryNotificationCertType;
    private String expiryNotificationCertId;

    public PluginInstanceTasklet(Visit visit) {
        this("PluginInstanceTasklet", "Plug-in Instance", visit);
    }

    public PluginInstanceTasklet(String taskletName, String menuName, Visit visit) {
        super(taskletName, menuName);
        this.setSystemVisit(visit);
        this.initTransitions();
        this.setInitialState(this.selectPluginTypeState);
        this.setCancelAvailable(true);
    }

    public void initPluginConnectionOverride(ConfigurablePluginInstance instance, String connectionId, PluginDescriptor descriptor) {
        this.setGeneratedPluginConnectionId(instance.getId(), connectionId);
        this.selectPluginTypeState.setPluginName(instance.getName() + " (with override)");
        this.selectPluginTypeState.setDescriptor(descriptor);
        this.setParentPluginInstanceId(instance.getId());
        this.connectionOverrideMode = true;
    }

    public void setGeneratedPluginConnectionId(String adapterId, String connectionId) {
        this.selectPluginTypeState.setPluginId(IdUtil.generatePluginConnectionId((String)adapterId, (String)connectionId, this.pluginManager));
    }

    protected BaseSelectPluginTypeState createSelectTypeState() {
        return new SelectAdapterTypeState(this);
    }

    @Override
    public String getParentPluginInstanceId() {
        if (this.selectPluginTypeState instanceof SelectAdapterTypeState) {
            return ((SelectAdapterTypeState)this.selectPluginTypeState).getParentPluginInstanceId();
        }
        return null;
    }

    public void setParentPluginInstanceId(String parentPluginInstanceId) {
        if (this.selectPluginTypeState instanceof SelectAdapterTypeState) {
            ((SelectAdapterTypeState)this.selectPluginTypeState).setParentPluginInstanceId(parentPluginInstanceId);
        }
    }

    protected void initTransitions() {
        this.selectPluginTypeState.addOutgoingTransition(this, this.configureAdapterState);
        this.configureAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.adapterActionState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PluginInstanceTasklet.this.getSelectedDescriptor() != null && PluginInstanceTasklet.this.getSelectedDescriptor().getGuiConfigDescriptorBuilder().buildNewGuiDescriptor().hasActions();
            }
        });
        this.configureAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.createAdapterContractState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PluginInstanceTasklet.this.getSelectedDescriptor() != null && PluginInstanceTasklet.this.getSelectedDescriptor().isSupportsExtendedContract();
            }
        });
        this.configureAdapterState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeValueMaskState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PluginInstanceTasklet.this.usingTokenProcessors();
            }
        });
        this.configureAdapterState.addOutgoingTransition(this, this.summaryState);
        this.adapterActionState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.createAdapterContractState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PluginInstanceTasklet.this.getSelectedDescriptor() != null && PluginInstanceTasklet.this.getSelectedDescriptor().isSupportsExtendedContract();
            }
        });
        this.adapterActionState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeValueMaskState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PluginInstanceTasklet.this.usingTokenProcessors();
            }
        });
        this.adapterActionState.addOutgoingTransition(this, this.summaryState);
        this.createAdapterContractState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeValueMaskState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return PluginInstanceTasklet.this.usingTokenProcessors();
            }
        });
        this.attributeValueMaskState.addOutgoingTransition(this, this.summaryState);
        this.createAdapterContractState.addOutgoingTransition(this, this.summaryState);
    }

    public List<String> getAdapterAttributeList() {
        if (this.findState(this.createAdapterContractState.getStateName()) != null && this.createAdapterContractState.getContract() != null) {
            return new LinkedList<String>(this.createAdapterContractState.getContract().getMutableAttributeNames());
        }
        return new LinkedList<String>();
    }

    public List<String> getAllContractAttrNamesSorted() {
        if (this.createAdapterContractState.getContract() != null) {
            return this.createAdapterContractState.getContract().getAllAttrNamesSorted();
        }
        return Collections.emptyList();
    }

    @Override
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Override
    public boolean isDisabled() {
        return this.disabled;
    }

    @Override
    public String getDisabled() {
        return "disabled";
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void initDescriptorTypeList(Collection<? extends PluginDescriptor> descriptors) {
        this.selectPluginTypeState.initDescriptorTypeList(descriptors);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }

    @Override
    public String getPluginId() {
        return this.selectPluginTypeState.getPluginId();
    }

    @Override
    public String getName() {
        return this.selectPluginTypeState.getPluginName();
    }

    @Override
    public String getType() {
        return this.selectPluginTypeState.getDescriptor().getType();
    }

    @Override
    public boolean isNewPlugin() {
        return this.selectPluginTypeState.isNewPlugin();
    }

    @Override
    public PluginDescriptor getSelectedDescriptor() {
        return this.selectPluginTypeState.getDescriptor();
    }

    @Override
    public Configuration getConfiguration() {
        return this.configureAdapterState.buildConfiguration();
    }

    @Override
    public boolean performSaveEvent(ValidationDelegate delegate) {
        return this.configureAdapterState.performSaveEvent(delegate);
    }

    @Override
    public boolean performDeleteEvent(ValidationDelegate delegate) {
        return this.configureAdapterState.performDeleteEvent(delegate);
    }

    @Override
    public PluginManager<?, ?> getPluginManager() {
        return this.pluginManager;
    }

    public void setPluginManager(PluginManager<?, ?> pluginManager) {
        this.pluginManager = pluginManager;
    }

    public boolean usingTokenProcessors() {
        IWizardState state = this.getParentTasklet().getSourceState();
        if (state instanceof TokenPluginMgmtState || state instanceof WsTrustTokenProcessorInstanceState) {
            return this.isTokenProcessorInstanceTasklet;
        }
        return false;
    }

    public boolean isItInUse() {
        String pluginId = this.getPluginId();
        return this.getPluginManager().isPluginInUse(pluginId) || this.isItUsedButNotSaved(pluginId);
    }

    protected boolean isItUsedButNotSaved(String id) {
        Tasklet t = this.findParent(WsTrustSpTokenCreationTasklet.class);
        if (t != null) {
            WsTrustSpTokenCreationTasklet wsTrustSpTokenCreationTasklet = (WsTrustSpTokenCreationTasklet)t;
            List<String> processorIdsInLocalUse = wsTrustSpTokenCreationTasklet.getProcessorsInUseByConnection();
            return processorIdsInLocalUse.contains(id);
        }
        t = this.findParent(WsTrustTokenGenerationTasklet.class);
        if (t != null) {
            WsTrustTokenGenerationTasklet wsTrustTokenGenerationTasklet = (WsTrustTokenGenerationTasklet)t;
            List<String> generatorIdsInLocalUse = wsTrustTokenGenerationTasklet.getGeneratorsInUseByConnection();
            return generatorIdsInLocalUse.contains(id);
        }
        return false;
    }

    @Override
    public boolean save(Object instance) {
        if (instance instanceof ConfigurablePluginInstance) {
            ((ConfigurablePluginInstance)instance).setDefaultInstance(this.defaultInstance);
        }
        return super.save(instance);
    }

    @Override
    public void populate(Object dataFromDisk) {
        ConfigurablePluginInstance defaultInstance = this.pluginManager.getDefaultInstance();
        if (defaultInstance != null && dataFromDisk instanceof ConfigurablePluginInstance && ((ConfigurablePluginInstance)dataFromDisk).getId().equals(defaultInstance.getId())) {
            this.setDefaultInstance(true);
        }
        super.populate(dataFromDisk);
    }

    public boolean isSaveCalled() {
        return this.saveCalled;
    }

    public void setSaveCalled(boolean saveCalled) {
        this.saveCalled = saveCalled;
    }

    @Override
    public void finish() {
        this.setSaveCalled(true);
        ConfigurablePluginInstance tmpInstance = this.pluginManager.newInstance();
        this.save(tmpInstance);
        if (!this.isOverrideAutoSave()) {
            this.setMode(Mode.edit);
            if (this.isSaveCalled() && this.performSaveEvent(this.getDelegate())) {
                this.pluginManager.saveInstance(tmpInstance);
                PluginManagementSupport.PluginManagementType type = this.getPluginType();
                DependencyType dependencyType = this.getDepType(type);
                if (dependencyType != null) {
                    DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
                    DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
                    dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)tmpInstance, dependencyType);
                    if (dependencyType == DependencyType.SP_ADAPTER) {
                        DependencyErrorHandler depErrorUtil = new DependencyErrorHandler();
                        depErrorUtil.updateDependenciesForSpAdapter(tmpInstance);
                    }
                }
            }
            this.selectPluginTypeState.setNewPlugin(false);
        }
        this.setPopulateData(tmpInstance);
        this.populate(tmpInstance);
        super.finish();
    }

    public boolean isOverrideAutoSave() {
        return this.overrideAutoSave;
    }

    public void setOverrideAutoSave(boolean overrideAutoSave) {
        this.overrideAutoSave = overrideAutoSave;
    }

    private AdminAuditLogger.Component getAuditLoggerComponent() {
        return this.auditLoggerComponent;
    }

    public void setAuditLoggerComponent(AdminAuditLogger.Component auditLoggerComponent) {
        this.auditLoggerComponent = auditLoggerComponent;
    }

    private PluginManagementSupport.PluginManagementType getPluginType() {
        return this.pluginType;
    }

    public void setPluginType(PluginManagementSupport.PluginManagementType pluginType) {
        this.pluginType = pluginType;
    }

    DependencyType getDepType(PluginManagementSupport.PluginManagementType pluginType) {
        if (pluginType == null) {
            return null;
        }
        switch (pluginType) {
            case TOKEN_GENERATOR: {
                return DependencyType.TOKEN_GENERATOR;
            }
            case TOKEN_PROCESSOR: {
                return DependencyType.TOKEN_PROCESSOR;
            }
            case PCV: {
                return DependencyType.PCV;
            }
            case IDENTITY_STORE_PROVISIONER: {
                return DependencyType.IDENTITY_STORE_PROVISIONER;
            }
            case OOB_AUTH_PLUGIN: {
                return DependencyType.OOB_AUTH_PLUGIN;
            }
            case IDP_ADAPTER: {
                return DependencyType.IDP_ADAPTER;
            }
            case SP_ADAPTER: {
                return DependencyType.SP_ADAPTER;
            }
            case ADAPTER_SELECTOR: {
                return DependencyType.AUTHN_POLICY_ATTRS;
            }
            case ACCESS_TOKEN_MANAGEMENT: {
                return DependencyType.ACCESS_TOKEN_MANAGEMENT_ATTRS;
            }
        }
        return null;
    }

    public void setPluginDepth(int pluginDepth) {
        this.pluginDepth = pluginDepth;
    }

    public String getIndentedPrefix() {
        TaskletListState s = (TaskletListState)this.getParentTasklet().getCurrentState();
        if (!(s.getComparator() instanceof PluginHierarchyComparator)) {
            return "";
        }
        String space = "&nbsp;";
        StringBuilder indentedName = new StringBuilder();
        for (int i = 0; i < this.pluginDepth * 4; ++i) {
            indentedName.append("&nbsp;");
        }
        return indentedName.toString();
    }

    public boolean isInheritingContract() {
        return this.createAdapterContractState.isInheritingContract();
    }

    public void setTokenProcessorInstanceTasklet(boolean isTokenProcessorInstanceTasklet) {
        this.isTokenProcessorInstanceTasklet = isTokenProcessorInstanceTasklet;
    }

    public boolean isNewTasklet() {
        return this.isNewTasklet;
    }

    public void setNewTasklet(boolean isNewTasklet) {
        this.isNewTasklet = isNewTasklet;
    }

    @Override
    public boolean onFinish(IRequestCycle cycle) {
        boolean continueProcessing = super.onFinish(cycle);
        this.isNewTasklet = false;
        this.selectPluginTypeState.setOrigPluginName(this.selectPluginTypeState.getPluginName());
        return continueProcessing;
    }

    public boolean isConnectionOverrideMode() {
        return this.connectionOverrideMode;
    }

    public void setConnectionOverrideMode(boolean connectionOverrideMode) {
        this.connectionOverrideMode = connectionOverrideMode;
    }

    public void setDefaultInstance(boolean defaultInstance) {
        this.defaultInstance = defaultInstance;
    }

    public boolean isDefaultInstance() {
        return this.defaultInstance;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }

    public void setOverrideAttributeMaskSettings(boolean isOverriding) {
        this.attributeValueMaskState.setOverridingAttributeMasks(isOverriding);
    }

    public void refreshPlugin() {
        ConfigurablePluginInstance plugin = this.getPluginManager().getInstance(this.getPluginId());
        if (plugin != null && StringUtils.isNotBlank((String)plugin.getParentId())) {
            this.populate(plugin);
        }
    }

    @Override
    public Cert getCertForExpiryNotification() {
        if (this.expiryNotificationCertId != null) {
            for (PluginDescriptor descriptor : this.getPluginManager().getInstalledDescriptors()) {
                GuiConfigDescriptorBuilder guiConfigDescriptor = descriptor.getGuiConfigDescriptorBuilder();
                if (!guiConfigDescriptor.buildNewGuiDescriptor().getAllDescriptorTypesInUse().contains(EncryptionCertificateFieldDescriptor.class)) continue;
                for (FieldDescriptor fieldDescriptor : guiConfigDescriptor.buildNewGuiDescriptor().getFields()) {
                    if (!(fieldDescriptor instanceof EncryptionCertificateFieldDescriptor)) continue;
                    String featureId = ((EncryptionCertificateFieldDescriptor)fieldDescriptor).getCertificateFeatureName();
                    Set certs = this.certManager.getCertsForFeature(featureId);
                    for (Cert currentCert : certs) {
                        if (!this.expiryNotificationCertId.equals(currentCert.getId())) continue;
                        return currentCert;
                    }
                }
            }
        }
        return null;
    }

    @Override
    public void setCertIdForExpiryNotification(String certId) {
        this.expiryNotificationCertId = certId;
    }

    @Override
    public CertificateType getCertTypeForExpiryNotification() {
        return this.expiryNotificationCertType;
    }

    @Override
    public void setCertTypeForExpiryNotification(CertificateType expiryNotificationCertType) {
        this.expiryNotificationCertType = expiryNotificationCertType;
    }

    public void turnOnValidationForAdapterContract() {
        this.pluginContractState.turnOnValidation(true);
    }
}

