/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigIdpDiscoveryState;
import com.pingidentity.fsm.state.impl.FederationInfoState;
import com.pingidentity.fsm.state.impl.WsTrustStsSettingsState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.module.connection.admin.AdminConnectionModuleSupport;
import com.pingidentity.module.connection.admin.ServerSettingsState;
import com.pingidentity.page.Login;
import java.util.List;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class ProtocolSettingsTasklet
extends Tasklet {
    private static final long serialVersionUID = 20050515L;
    private final FederationInfoState federationInfoState;
    private final WsTrustStsSettingsState wsTrustStsSettingsState;
    private final ConfigIdpDiscoveryState configIdpDiscoveryState;
    private final List<ServerSettingsState> connectionModuleStates;

    public ProtocolSettingsTasklet(Visit visit) {
        super("ProtocolSettingsTasklet", "Protocol Settings");
        this.setSystemVisit(visit);
        this.connectionModuleStates = AdminConnectionModuleSupport.getInstance().getServerSettingsStates(this);
        this.configIdpDiscoveryState = new ConfigIdpDiscoveryState(this);
        this.federationInfoState = new FederationInfoState(this);
        this.wsTrustStsSettingsState = new WsTrustStsSettingsState(this);
        this.federationInfoState.addOutgoingTransition(this, this.wsTrustStsSettingsState);
        for (ServerSettingsState serverSettingsState : this.connectionModuleStates) {
            this.federationInfoState.addOutgoingTransition(this, (TaskletState)((Object)serverSettingsState));
        }
        this.federationInfoState.addOutgoingTransition(this, this.configIdpDiscoveryState);
        for (ServerSettingsState serverSettingsState : this.connectionModuleStates) {
            this.wsTrustStsSettingsState.addOutgoingTransition(this, (TaskletState)((Object)serverSettingsState));
        }
        this.wsTrustStsSettingsState.addOutgoingTransition(this, this.configIdpDiscoveryState);
        for (int i = 0; i < this.connectionModuleStates.size(); ++i) {
            TaskletState currentModuleState = (TaskletState)((Object)this.connectionModuleStates.get(i));
            for (int k = i + 1; k < this.connectionModuleStates.size(); ++k) {
                ServerSettingsState transitionState = this.connectionModuleStates.get(k);
                currentModuleState.addOutgoingTransition(this, (IWizardState)((Object)transitionState));
            }
            currentModuleState.addOutgoingTransition(this, this.configIdpDiscoveryState);
        }
        this.setInitialState(this.federationInfoState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        if (this.isAuthorizedForAction()) {
            LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
            LocalSettings localSettings = localSettingsMgr.getLocalSettings();
            this.setMode(Mode.edit);
            this.saveAllStates(localSettings);
            localSettingsMgr.saveLocalSettings(localSettings);
        }
        super.finish();
    }

    @Override
    public String getFinishLabel() {
        return this.isAuthorizedForAction() ? "Save" : "Next";
    }

    @Override
    public void onCancel(IRequestCycle cycle) {
        if (this.isPostInstallWizard()) {
            Visit visit = this.getSystemVisit();
            visit.logout(cycle.getRequestContext().getSession());
            Login login = (Login)cycle.getPage("login");
            throw new PageRedirectException((IPage)login);
        }
        super.onCancel(cycle);
    }

    @Override
    public boolean isFinishAvailable() {
        if (this.hideFinishButtonIfAuditor()) {
            return false;
        }
        TaskletState currentState = (TaskletState)this.getCurrentState();
        return (!this.isPostInstallWizard() || currentState.getOutgoingTransition() == null) && super.isFinishAvailable();
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void gotoSummaryState(IRequestCycle cycle) {
        this.setGotoState(this.federationInfoState.getTaskletId());
        this.goToState(cycle);
    }

    @Override
    public boolean isAuthorizedForAction() {
        return this.getCurrentUser().isAdmin();
    }

    public String getDescription() {
        return "Protocol Settings";
    }

    public boolean isProtocolRequiringBaseUrlEnabled() {
        return true;
    }

    public boolean isSaml2Enabled() {
        return true;
    }

    public boolean isSaml1xEnabled() {
        return true;
    }

    public boolean isSaml1xApEnabled() {
        return true;
    }

    public boolean isWsFedEnabled() {
        return true;
    }

    public boolean isWsTrustStsEnabled() {
        return true;
    }

    public boolean isSpEnabled() {
        return true;
    }

    public boolean isIdpEnabled() {
        return true;
    }
}

