/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.PartnerRedirectValidationState;
import com.pingidentity.fsm.state.impl.RedirectValidationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.log.AuditLoggerScope;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class RedirectValidationTasklet
extends Tasklet {
    private static final long serialVersionUID = 1L;
    private RedirectValidationState redirectValidationState;
    private PartnerRedirectValidationState partnerRedirectValidationState;

    public RedirectValidationTasklet(Visit visit) {
        super("RedirectValidationTasklet", "Redirect Validation");
        this.setSystemVisit(visit);
        this.setCancelAvailable(true);
        this.setFinishAvailable(true);
        this.setFinishLabel("Save");
        this.setSaveDraftAvailable(false);
        this.redirectValidationState = new RedirectValidationState(this);
        this.setInitialState(this.redirectValidationState);
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        if (localSettings.isEnableWsFedIdP() || localSettings.isEnableWsFedSp()) {
            this.partnerRedirectValidationState = new PartnerRedirectValidationState(this);
            this.redirectValidationState.addOutgoingTransition(this, this.partnerRedirectValidationState);
        }
    }

    @Override
    public void finish() {
        try (AuditLoggerScope auditLoggerScope = new AuditLoggerScope();){
            if (this.save(null)) {
                super.finish();
                auditLoggerScope.log(AdminAuditLogger.Component.REDIRECT_VALIDATION, AdminAuditLogger.Event.MODIFY);
            }
        }
    }

    @Override
    public boolean isFinishAvailable() {
        return this.getFinishAvailable();
    }
}

