/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ActivationState;
import com.pingidentity.fsm.state.impl.AttributeRequesterState;
import com.pingidentity.fsm.state.impl.ConnRoleAndProtocolState;
import com.pingidentity.fsm.state.impl.ConnectionOptionsState;
import com.pingidentity.fsm.state.impl.ConnectionTemplateState;
import com.pingidentity.fsm.state.impl.CredentialsState;
import com.pingidentity.fsm.state.impl.ExtendedPropertyManagementState;
import com.pingidentity.fsm.state.impl.GeneralInfoState;
import com.pingidentity.fsm.state.impl.ImportMetadataCertState;
import com.pingidentity.fsm.state.impl.ImportMetadataState;
import com.pingidentity.fsm.state.impl.MetadataSummaryState;
import com.pingidentity.fsm.state.impl.SpBrowserSsoState;
import com.pingidentity.fsm.state.impl.WsTrustSpState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.ImportMetadataApi;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.module.connection.admin.AdminConnectionModuleSupport;
import com.pingidentity.module.connection.admin.ConnectionModuleState;
import com.pingidentity.templates.connection.ConnectionTemplateUtil;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.apache.tapestry.IRequestCycle;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlObject;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.EnabledProfiles;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.NotificationBanner;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SpConnectionConfigTasklet
extends ConnectionTasklet
implements NeededCredentialsApi,
SamlProfilesApi,
WebSsoApi,
ImportMetadataApi,
AttributeNamesApi {
    private static final long serialVersionUID = 20050515L;
    private SpConnection spConnection;
    final ConnectionTemplateState connectionTemplateState;
    final ConnRoleAndProtocolState connRoleAndProtocolState;
    final ConnectionOptionsState connectionOptionsState;
    final ImportMetadataState importMetadataState;
    final ImportMetadataCertState importMetadataCertState;
    final MetadataSummaryState metadataSummaryState;
    final GeneralInfoState generalInfoState;
    final SpBrowserSsoState spBrowserSsoState;
    final WsTrustSpState wsTrustSpState;
    final AttributeRequesterState attributeRequesterState;
    final CredentialsState credentialsState;
    final ActivationState activationState;
    final ExtendedPropertyManagementState extendedPropertyManagementState;
    final List<ConnectionModuleState> connectionModuleStates;

    public SpConnectionConfigTasklet(Visit visit) {
        super("SpConnectionConfigTasklet", "SP Connection");
        this.setSystemVisit(visit);
        this.connectionTemplateState = new ConnectionTemplateState(this);
        this.connRoleAndProtocolState = new ConnRoleAndProtocolState(this);
        this.connectionOptionsState = new ConnectionOptionsState(this);
        this.importMetadataState = new ImportMetadataState(this);
        this.importMetadataCertState = new ImportMetadataCertState(this);
        this.metadataSummaryState = new MetadataSummaryState(this);
        this.generalInfoState = new GeneralInfoState(this);
        this.spBrowserSsoState = new SpBrowserSsoState(this);
        this.wsTrustSpState = new WsTrustSpState(this);
        this.attributeRequesterState = new AttributeRequesterState(this);
        this.credentialsState = new CredentialsState(this);
        this.activationState = new ActivationState(this);
        this.activationState.setSummaryTitle("Summary");
        this.extendedPropertyManagementState = new ExtendedPropertyManagementState((IWizard)this, true);
        AdminConnectionModuleSupport support = AdminConnectionModuleSupport.getInstance();
        this.connectionModuleStates = support.getConnectionStates(this);
        this.setInitialState(this.connRoleAndProtocolState);
        this.setCancelAvailable(true);
    }

    @Override
    public void reconfigureTransitions() {
        Class<?> stateClass;
        this.clearAllStatesOutgoingTransitions();
        boolean isExistingConnection = this.isExistingConnection();
        this.importMetadataState.setExistingConnection(isExistingConnection);
        this.connectionTemplateState.addOutgoingTransition(this, this.connRoleAndProtocolState);
        this.connRoleAndProtocolState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.connectionOptionsState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled();
            }
        });
        this.connRoleAndProtocolState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importMetadataState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return (SpConnectionConfigTasklet.this.connRoleAndProtocolState.isStandardConnection() || SpConnectionConfigTasklet.this.isExistingConnection()) && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.getProtocolType() != null && SpConnectionConfigTasklet.this.getProtocolType() != Protocol.WSFED;
            }
        });
        this.connRoleAndProtocolState.addOutgoingTransition(this, this.generalInfoState);
        this.connectionOptionsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importMetadataState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return (SpConnectionConfigTasklet.this.connRoleAndProtocolState.isStandardConnection() || SpConnectionConfigTasklet.this.isExistingConnection()) && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.getProtocolType() != null && SpConnectionConfigTasklet.this.getProtocolType() != Protocol.WSFED;
            }
        });
        this.connectionOptionsState.addOutgoingTransition(this, this.generalInfoState);
        this.importMetadataState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.importMetadataCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.importMetadataState.isSignedMetadataWoKeyInfo();
            }
        });
        this.importMetadataState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.metadataSummaryState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.importMetadataState.isUnsignedOrSignedWithKeyInfo() && SpConnectionConfigTasklet.this.importMetadataState.isMetadataSummaryRequired();
            }
        });
        this.importMetadataState.addOutgoingTransition(this, this.generalInfoState);
        this.importMetadataCertState.addOutgoingTransition(this, this.metadataSummaryState);
        this.metadataSummaryState.addOutgoingTransition(this, this.generalInfoState);
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.extendedPropertyManagementState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.showExtendedPropertiesState();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.spBrowserSsoState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustSpState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustStsEnabled() && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustEnabledInServerSettings();
            }
        });
        this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeRequesterState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.connectionOptionsState.isAttributeQueryEnabled();
            }
        });
        for (ConnectionModuleState moduleState : this.connectionModuleStates) {
            stateClass = moduleState.getClass();
            this.generalInfoState.addOutgoingTransition(new TaskletTransition(this, (TaskletState)((Object)moduleState)){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isConnectionModuleSelected(stateClass);
                }
            });
        }
        this.generalInfoState.addOutgoingTransition(this, this.activationState);
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.spBrowserSsoState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.isBrowserSsoStateEnabled() && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileCheckboxEnabled();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustSpState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustStsEnabled() && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustEnabledInServerSettings();
            }
        });
        this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeRequesterState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.connectionOptionsState.isAttributeQueryEnabled();
            }
        });
        for (ConnectionModuleState moduleState : this.connectionModuleStates) {
            stateClass = moduleState.getClass();
            this.extendedPropertyManagementState.addOutgoingTransition(new TaskletTransition(this, (TaskletState)((Object)moduleState)){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isConnectionModuleSelected(stateClass);
                }
            });
        }
        this.extendedPropertyManagementState.addOutgoingTransition(this, this.activationState);
        this.spBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustSpState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustStsEnabled() && SpConnectionConfigTasklet.this.connRoleAndProtocolState.isWsTrustEnabledInServerSettings();
            }
        });
        this.spBrowserSsoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeRequesterState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.connectionOptionsState.isAttributeQueryEnabled();
            }
        });
        this.spBrowserSsoState.addOutgoingTransition(this, this.credentialsState);
        this.wsTrustSpState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.attributeRequesterState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && SpConnectionConfigTasklet.this.connectionOptionsState.isAttributeQueryEnabled();
            }
        });
        this.wsTrustSpState.addOutgoingTransition(this, this.credentialsState);
        this.attributeRequesterState.addOutgoingTransition(this, this.credentialsState);
        for (ConnectionModuleState moduleState : this.connectionModuleStates) {
            stateClass = moduleState.getClass();
            this.credentialsState.addOutgoingTransition(new TaskletTransition(this, (TaskletState)((Object)moduleState)){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isConnectionModuleSelected(stateClass);
                }
            });
        }
        this.credentialsState.addOutgoingTransition(this, this.activationState);
        for (int i = 0; i < this.connectionModuleStates.size(); ++i) {
            TaskletState currentModuleState = (TaskletState)((Object)this.connectionModuleStates.get(i));
            for (int k = i + 1; k < this.connectionModuleStates.size(); ++k) {
                ConnectionModuleState transitionState = this.connectionModuleStates.get(k);
                final Class<?> transitionStateClass = transitionState.getClass();
                currentModuleState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)((Object)transitionState)){
                    private static final long serialVersionUID = 20050515L;

                    @Override
                    public boolean validate() {
                        return SpConnectionConfigTasklet.this.connRoleAndProtocolState.isConnectionModuleSelected(transitionStateClass);
                    }
                });
            }
            currentModuleState.addOutgoingTransition(this, this.activationState);
        }
    }

    public void gotoGeneralInfoState(IRequestCycle cycle) {
        this.setGotoState(this.generalInfoState.toString());
        this.goToState(cycle);
    }

    @Override
    public void gotoSummaryState(IRequestCycle cycle) {
        this.setGotoState(this.activationState.getTaskletId());
        this.goToState(cycle);
    }

    @Override
    public Protocol getProtocolType() {
        return this.connRoleAndProtocolState.getProtocol();
    }

    @Override
    public void finish() {
        this.saveToDisk();
        super.finish();
    }

    public SpConnection buildConnectionForSaveToDisk() {
        SpConnection connection = new SpConnection();
        if (!this.isBrowserSsoStateEnabled()) {
            EnabledProfiles enabledProfiles = connection.getEnabledProfiles();
            enabledProfiles.setIdpInitiatedSSOEnabled(false);
            enabledProfiles.setIdpInitiatedSLOEnabled(false);
            enabledProfiles.setSpInitiatedSSOEnabled(false);
            enabledProfiles.setSpInitiatedSLOEnabled(false);
        }
        if (this.spConnection != null) {
            connection.setId(this.spConnection.getId());
        }
        this.save(connection);
        return connection;
    }

    public void saveToDisk() {
        boolean newConnection;
        SpConnection connection = this.buildConnectionForSaveToDisk();
        if (!(this.spConnection == null || !this.spConnection.getEntityId().equals(connection.getEntityId()) && this.isCopied() || this.isLoadedFromDraft())) {
            connection.setCreationTime(this.spConnection.getCreationTime());
        } else {
            connection.setCreationTime((Calendar)new XmlCalendar(new Date()));
        }
        ConnectionManager connectionManager = MgmtFactory.getConnectionManager();
        connectionManager.saveSpConnection(connection);
        NotificationBanner notificationBanner = NotificationBanner.getNotificationBannerForConnection((ConnectionBase)connection);
        this.getSystemVisit().setNotificationBannerContent(notificationBanner);
        boolean bl = newConnection = this.spConnection == null;
        if ((newConnection || this.isLoadedFromDraft()) && this.isSalesforceConnection()) {
            ConnectionTemplateUtil connTemplateUtil = new ConnectionTemplateUtil();
            connTemplateUtil.loadSalesforceIdpConnection(this.getConnId(), this.getVirtualEntityIds(), this.getConnectionName(), this.getSystemVisit(), this.getCycle());
        }
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)connection, DependencyType.PROTOCOL_SETTINGS);
    }

    @Override
    public boolean isBrowserSsoStateEnabled() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled();
    }

    @Override
    public String getFinishLabel() {
        return "Save";
    }

    @Override
    public String getConnId() {
        return this.generalInfoState.getConnId();
    }

    @Override
    public String getConnIdOnDisk() {
        return this.generalInfoState.getConnIdOnDisk();
    }

    @Override
    public List<String> getVirtualEntityIds() {
        return this.generalInfoState.getVirtualServerIdNames();
    }

    @Override
    public String getConnectionName() {
        return this.generalInfoState.getConnectionName();
    }

    public void setConnectionName(String connectionName) {
        this.generalInfoState.setConnectionName(connectionName);
    }

    public String getRole() {
        return "SP";
    }

    @Override
    public String getTaskletId() {
        return this.getConnectionType() + this.getConnId();
    }

    @Override
    public int compareTo(Tasklet o) {
        return this.getConnId().toLowerCase().compareTo(((ConnectionTasklet)o).getConnId().toLowerCase());
    }

    @Override
    public String getStatus() {
        return this.activationState.isConnectionActive() ? "Active" : "Inactive";
    }

    @Override
    public String getClassType() {
        return this.activationState.isConnectionActive() ? "active" : "disabled";
    }

    public boolean isConnectionActive() {
        return this.activationState.isConnectionActive();
    }

    public boolean isConnectionActiveFromDisk() {
        return this.activationState.isConnectionActiveFromDisk();
    }

    @Override
    public ConnectionType getConnectionType() {
        return ConnectionType.SP;
    }

    public SpConnection getSpConnection() {
        return this.spConnection;
    }

    public void setSpConnection(SpConnection spConnection) {
        this.spConnection = spConnection;
    }

    @Override
    public ConnectionBase getBase() {
        return this.getSpConnection();
    }

    @Override
    public boolean isBaseUrlConfigured() {
        return this.generalInfoState.isBaseUrlConfigured();
    }

    @Override
    public String getBaseUrlProtocol() {
        if (this.isBaseUrlConfigured()) {
            try {
                URL url = new URL(this.generalInfoState.getBaseUrlString());
                return url.getProtocol();
            }
            catch (MalformedURLException u) {
                return "";
            }
        }
        return "";
    }

    @Override
    public String getBaseUrlString() {
        return this.generalInfoState.getBaseUrlString();
    }

    @Override
    public void renameConnectionId(String newConnId) {
        this.generalInfoState.setConnId(newConnId);
    }

    @Override
    public boolean isAnySsoSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isAnySsoSelected();
    }

    @Override
    public boolean isAttributeQuerySelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isAttributeQueryEnabled();
    }

    @Override
    public boolean isAnySloSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isAnySloSelected();
    }

    @Override
    public boolean isIdpSSOSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isIdpSSOSelected();
    }

    @Override
    public boolean isIdpSLOSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isIdpSLOSelected();
    }

    @Override
    public boolean isSomethingOtherThanIdpInitiatedSsoSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isSomethingOtherThanIdpInitiatedSsoSelected();
    }

    @Override
    public boolean isSpSSOSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isSpSSOSelected();
    }

    @Override
    public boolean isSpSLOSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isSpSLOSelected();
    }

    @Override
    public boolean isOnlySpSSOSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isOnlySpSSOSelected();
    }

    @Override
    public boolean onlyIdpSsoSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.onlyIdpSsoSelected();
    }

    @Override
    public boolean isAnySpSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isAnySpSelected();
    }

    @Override
    public boolean isSomethingOtherThanSpInitiatedSsoSelected() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled() && this.connectionOptionsState.isBrowserSsoEnabled() && this.spBrowserSsoState.isSomethingOtherThanSpInitiatedSsoSelected();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.spBrowserSsoState.isBackChannelAuthenticationNeeded() || this.attributeRequesterState.isBackChannelAuthenticationNeeded();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.spBrowserSsoState.isDigitalSignatureVerificationNeeded() || this.attributeRequesterState.isDigitalSignatureVerificationNeeded();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.spBrowserSsoState.isDigitalSignatureNeeded() || this.attributeRequesterState.isDigitalSignatureNeeded() || this.isWsFedProtocol() || this.connRoleAndProtocolState.isWsTrustStsEnabled();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return this.spBrowserSsoState.isEncryptionCertificateNeeded() || this.attributeRequesterState.isEncryptionCertificateNeeded() || this.wsTrustSpState.isHolderOfKeyConfirmationMethod() || this.wsTrustSpState.isEncryptSaml20();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return this.spBrowserSsoState.isDecryptionKeyNeeded() || this.attributeRequesterState.isDecryptionKeyNeeded();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.spBrowserSsoState.getAllAttributeNames();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.spBrowserSsoState.getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.spBrowserSsoState.getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.spBrowserSsoState.getSortedMutableAttributeNames();
    }

    @Override
    public boolean isInboundArtifact() {
        return this.spBrowserSsoState.isInboundArtifact();
    }

    @Override
    public boolean isSoapSlo() {
        return this.spBrowserSsoState.isSoapSlo();
    }

    @Override
    public boolean isArtifactSsoSlo() {
        return this.spBrowserSsoState.isArtifactSsoSlo();
    }

    @Override
    public boolean isInboundSoap() {
        return this.spBrowserSsoState.isInboundSoap();
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        return this.spBrowserSsoState.isAnyOutboundSoapNotUsingHttps();
    }

    @Override
    public ArrayList<SummaryInfo> getMetadataSummary() {
        ArrayList<SummaryInfo> summaryList = this.importMetadataState.getMetadataSummary();
        if (this.importMetadataState.isSignedMetadataWoKeyInfo()) {
            this.importMetadataCertState.getSummary(summaryList);
        }
        return summaryList;
    }

    public boolean isSalesforceConnection() {
        return this.connectionTemplateState.isSalesforceConnection();
    }

    @Override
    public void importConnection() {
        this.importMetadataState.importConnection();
    }

    @Override
    public XmlObject getMetadataXml() {
        return this.importMetadataState.getMetadataXml();
    }

    public String getSelectedTargetType() {
        return this.connRoleAndProtocolState.getSelectedTargetType();
    }

    public String getSelectedConnectionModuleType(Class<? extends ConnectionModuleState> connectionModuleStateClass) {
        return this.connRoleAndProtocolState.getSelectedConnectionModuleType(connectionModuleStateClass);
    }

    public void setSummaryStateClickable(boolean itClickable) {
        this.activationState.setItClickable(itClickable);
    }

    @Override
    public boolean isBrowserSsoProfileEnabled() {
        return this.connRoleAndProtocolState.isBrowserSsoProfileEnabled();
    }

    @Override
    public boolean isWsTrustStsEnabled() {
        return this.connRoleAndProtocolState.isWsTrustStsEnabled();
    }

    public void setConnTemplateAsInitialStateIfAllowed() {
        if (MgmtFactory.getLocalSettingsManager().getLocalSettings().isEnableSamlIdP() && this.connectionTemplateState.hasConnectionTemplates()) {
            this.grayAllStates();
            this.setInitialState(this.connectionTemplateState);
        }
    }

    @Override
    public boolean isInboundProvisioningEnabled() {
        return false;
    }

    @Override
    public boolean isInboundProvisioningGroupsEnabled() {
        return false;
    }

    @Override
    public boolean isOutboundProvisioningEnabled() {
        return this.connRoleAndProtocolState.isConnectionModuleSelected("SaasProvisioner");
    }

    @Override
    public boolean isOAuthSamlAssertionMappingEnabled() {
        return false;
    }

    @Override
    public boolean isC2cEnabled() {
        return true;
    }

    public boolean isWsFedJwt() {
        return this.connRoleAndProtocolState.getWsFedTokenType() == WsTrustTokenType.JWT;
    }

    public WsTrustTokenType getWsFedTokenType() {
        return this.connRoleAndProtocolState.getWsFedTokenType();
    }

    @Override
    public String getMetadataUrlId() {
        return this.importMetadataState.getMetadataUrlId();
    }

    @Override
    public Integer getMetadataType() {
        return this.importMetadataState.getMetadataType();
    }

    @Override
    public boolean save(Object dataToDisk) {
        boolean saveSuccesful = super.save(dataToDisk);
        this.importMetadataState.reset();
        return saveSuccesful;
    }

    public void populateTemplate(SpConnection templateConnection) {
        this.populate(templateConnection);
        for (ConnectionModuleState moduleState : this.connectionModuleStates) {
            moduleState.resetForNewConnection();
        }
    }

    @Override
    public String getSystemId() {
        return this.spConnection == null ? null : this.spConnection.getId();
    }

    @Override
    public void metaDataReset() {
        this.credentialsState.metaDataReset();
    }
}

