/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.AllowableSamlBindingsState;
import com.pingidentity.fsm.state.impl.ArtifactConfigState;
import com.pingidentity.fsm.state.impl.AssertionConsumerServiceState;
import com.pingidentity.fsm.state.impl.ConfigArtifactLifetimeState;
import com.pingidentity.fsm.state.impl.DefaultTargetUrlState;
import com.pingidentity.fsm.state.impl.SelectSpXmlAssertionEncryptionState;
import com.pingidentity.fsm.state.impl.SloServiceUrlConfigState;
import com.pingidentity.fsm.state.impl.SpSignaturePolicyState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsFedServiceUrlState;
import com.pingidentity.fsm.state.impl.WsTrustVersionState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.NeededCredentialsApi;
import com.pingidentity.fsm.tasklet.api.SamlProfilesApi;
import com.pingidentity.fsm.tasklet.api.WebSsoApi;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.fsm.tasklet.impl.SpBrowserSsoTasklet;
import com.pingidentity.fsm.tasklet.impl.SpConnectionConfigTasklet;
import java.util.ArrayList;
import java.util.List;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.websso.Protocol;
import org.sourceid.wstrust.model.WsTrustTokenType;

public class SpProtocolSettingsTasklet
extends MultiProtocolTasklet
implements NeededCredentialsApi,
WebSsoApi {
    private static final long serialVersionUID = 20050515L;
    final AssertionConsumerServiceState assertionConsumerServiceState;
    final SloServiceUrlConfigState sloServiceUrlConfigState;
    final DefaultTargetUrlState defaultTargetUrlState;
    final AllowableSamlBindingsState allowableSamlBindingsState;
    final ArtifactConfigState artifactConfigState;
    final ConfigArtifactLifetimeState configArtifactLifetimeState;
    final SpSignaturePolicyState spSignaturePolicyState;
    final SelectSpXmlAssertionEncryptionState selectSpXmlAssertionEncryptionState;
    final SummaryCardState summaryCardState;
    final WsFedServiceUrlState wsFedServiceUrlState;
    final WsTrustVersionState wsTrustVersionState;

    public SpProtocolSettingsTasklet(Visit visit) {
        super("SpProtocolSettingsTasklet", "Protocol Settings");
        this.setSystemVisit(visit);
        this.wsFedServiceUrlState = new WsFedServiceUrlState(this, true);
        this.assertionConsumerServiceState = new AssertionConsumerServiceState(this);
        this.sloServiceUrlConfigState = new SloServiceUrlConfigState(this);
        this.defaultTargetUrlState = new DefaultTargetUrlState(this);
        this.allowableSamlBindingsState = new AllowableSamlBindingsState(this);
        this.artifactConfigState = new ArtifactConfigState(this);
        this.configArtifactLifetimeState = new ConfigArtifactLifetimeState(this);
        this.spSignaturePolicyState = new SpSignaturePolicyState(this);
        this.selectSpXmlAssertionEncryptionState = new SelectSpXmlAssertionEncryptionState(this);
        this.summaryCardState = new SummaryCardState(this);
        if (!MgmtFactory.getJCEManager().allowXmlEncryption()) {
            this.selectSpXmlAssertionEncryptionState.setNoteKey("SpWebSsoTasklet_SelectSpXmlAssertionEncryptionState_Luna");
            this.selectSpXmlAssertionEncryptionState.setAllowXmlEncryption(false);
        }
        this.wsTrustVersionState = new WsTrustVersionState(this);
        this.setCancelAvailable(true);
    }

    @Override
    public void configureTasklet() {
        if (this.getInitialState() != null) {
            this.clearAllStatesOutgoingTransitions();
        }
        if (Protocol.WSFED.equals((Object)this.getProtocolType())) {
            this.wsTrustVersionState.addOutgoingTransition(this, this.wsFedServiceUrlState);
            this.wsFedServiceUrlState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectSpXmlAssertionEncryptionState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return WsTrustTokenType.SAML20 == SpProtocolSettingsTasklet.this.getWsFedTokenType();
                }
            });
            this.selectSpXmlAssertionEncryptionState.addOutgoingTransition(this, this.summaryCardState);
            this.wsFedServiceUrlState.addOutgoingTransition(this, this.summaryCardState);
            this.setInitialState(this.wsTrustVersionState);
            this.wsFedServiceUrlState.updateKeyContext(this.isJwtSelected());
        } else {
            this.sloServiceUrlConfigState.setDomainTranslator(this.getProtocolType());
            this.assertionConsumerServiceState.setDomainTranslator(this.getProtocolType());
            this.assertionConsumerServiceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.defaultTargetUrlState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isConnectionProtocol1x();
                }
            });
            this.assertionConsumerServiceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.sloServiceUrlConfigState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isAnySloSelected();
                }
            });
            this.assertionConsumerServiceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.allowableSamlBindingsState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isSpSSOSelected();
                }
            });
            this.assertionConsumerServiceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configArtifactLifetimeState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.onlyIdpSsoSelected() && SpProtocolSettingsTasklet.this.isOutboundArtifactBindingUsed();
                }
            });
            this.assertionConsumerServiceState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.spSignaturePolicyState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.onlyIdpSsoSelected() && !SpProtocolSettingsTasklet.this.isOutboundArtifactBindingUsed();
                }
            });
            this.defaultTargetUrlState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configArtifactLifetimeState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isOutboundArtifactBindingUsed();
                }
            });
            this.defaultTargetUrlState.addOutgoingTransition(this, this.spSignaturePolicyState);
            this.sloServiceUrlConfigState.addOutgoingTransition(this, this.allowableSamlBindingsState);
            this.allowableSamlBindingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configArtifactLifetimeState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isOutboundArtifactBindingUsed() || SpProtocolSettingsTasklet.this.isSloArtifactBindingUsed();
                }
            });
            this.allowableSamlBindingsState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.artifactConfigState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isInboundArtifact() && !SpProtocolSettingsTasklet.this.isOutboundArtifactBindingUsed();
                }
            });
            this.allowableSamlBindingsState.addOutgoingTransition(this, this.spSignaturePolicyState);
            this.configArtifactLifetimeState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.artifactConfigState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isInboundArtifact();
                }
            });
            this.configArtifactLifetimeState.addOutgoingTransition(this, this.spSignaturePolicyState);
            this.artifactConfigState.addOutgoingTransition(this, this.spSignaturePolicyState);
            this.spSignaturePolicyState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.selectSpXmlAssertionEncryptionState){
                private static final long serialVersionUID = 20050515L;

                @Override
                public boolean validate() {
                    return SpProtocolSettingsTasklet.this.isConnectionProtocol20();
                }
            });
            this.spSignaturePolicyState.addOutgoingTransition(this, this.summaryCardState);
            this.selectSpXmlAssertionEncryptionState.addOutgoingTransition(this, this.summaryCardState);
            this.setInitialState(this.assertionConsumerServiceState);
        }
    }

    @Override
    public void finish() {
        SpConnection spConnection = new SpConnection();
        this.save(spConnection);
        this.setPopulateData(spConnection);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public Protocol getProtocolType() {
        return ((SpBrowserSsoTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public boolean isBackChannelAuthenticationNeeded() {
        return this.isOutboundArtifactBindingUsed() || this.isSloArtifactBindingUsed() || this.isInboundArtifact() || this.isInboundSoap() || this.isSoapSlo();
    }

    @Override
    public boolean isDigitalSignatureVerificationNeeded() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null && this.allowableSamlBindingsState.isPostOrRedirectSelected() && this.isAnySloSelected() || this.isAnySsoSelected() && this.spSignaturePolicyState.isAuthnRequestsSigned();
    }

    @Override
    public boolean isDigitalSignatureNeeded() {
        return this.assertionConsumerServiceState.isPostOrRedirectBindingUsed() || this.sloServiceUrlConfigState.isPostOrRedirectBindingUsed() || this.isAnySsoSelected() && this.spSignaturePolicyState.isAlwaysSignAssertion();
    }

    @Override
    public boolean isEncryptionCertificateNeeded() {
        return (this.isAnySsoSelected() || WsTrustTokenType.SAML20 == this.getWsFedTokenType()) && !this.selectSpXmlAssertionEncryptionState.isNoneSelected();
    }

    @Override
    public boolean isDecryptionKeyNeeded() {
        return this.isAnySsoSelected() && this.selectSpXmlAssertionEncryptionState.isSloSubjectNameIDEncrypted();
    }

    @Override
    public boolean isInboundArtifact() {
        if (this.isAnySloSelected() || !this.isAnySloSelected() && this.isSpSSOSelected()) {
            return this.allowableSamlBindingsState.isArtifactBinding();
        }
        return false;
    }

    @Override
    public boolean isArtifactSsoSlo() {
        return this.isOutboundArtifactBindingUsed() || this.isSloArtifactBindingUsed();
    }

    @Override
    public boolean isSoapSlo() {
        boolean soapSlo = false;
        if (this.isAnySloSelected()) {
            soapSlo |= this.sloServiceUrlConfigState.isSoapBindingUsed();
        }
        return soapSlo;
    }

    @Override
    public boolean isInboundSoap() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isSoapBindingSelected() : false;
    }

    private boolean isInboundPost() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isPostBinding() : false;
    }

    private boolean isInboundRedirect() {
        return this.findState(this.allowableSamlBindingsState.getStateName()) != null ? this.allowableSamlBindingsState.isRedirectBinding() : false;
    }

    public String getArtifactLifetime() {
        return this.configArtifactLifetimeState.getArtifactLifetime();
    }

    public List<String> getSignaturePolicyList() {
        ArrayList<String> policies = new ArrayList<String>();
        if (this.getProtocolType() != null && this.getProtocolType().equals((Object)Protocol.SAML20) && !this.spSignaturePolicyState.isSignResponseAsRequired() && !this.selectSpXmlAssertionEncryptionState.isEntireAssertionEncrypted()) {
            policies.add("SAML Response Not Signed");
        } else {
            policies.add("SAML-standard");
        }
        if (this.spSignaturePolicyState.isAlwaysSignAssertion()) {
            policies.add("SAML Assertion Signed");
        }
        if (this.spSignaturePolicyState.isShowAuthnRequestsSigned() && this.spSignaturePolicyState.isAuthnRequestsSigned()) {
            policies.add("Authn requests over POST & Redirect");
        }
        return policies;
    }

    @Override
    public boolean isAnyOutboundSoapNotUsingHttps() {
        return this.isAnyArsNotUsingHttps() || this.isAnySoapSloNotUsingHttps();
    }

    private boolean onlyIdpSsoSelected() {
        return this.findParent(SamlProfilesApi.class).onlyIdpSsoSelected();
    }

    private boolean isAnySloSelected() {
        return this.findParent(SamlProfilesApi.class).isAnySloSelected();
    }

    private boolean isSpSSOSelected() {
        return this.findParent(SamlProfilesApi.class).isSpSSOSelected();
    }

    private boolean isOutboundArtifactBindingUsed() {
        return this.assertionConsumerServiceState.isArtifactBindingUsed();
    }

    private boolean isSloArtifactBindingUsed() {
        boolean artifactBinding = false;
        if (this.isAnySloSelected()) {
            artifactBinding = this.sloServiceUrlConfigState.isArtifactBindingUsed();
        }
        return artifactBinding;
    }

    private boolean isAnySoapSloNotUsingHttps() {
        boolean anySoapSloNotUsingHttps = false;
        if (this.isSoapSlo()) {
            anySoapSloNotUsingHttps |= this.sloServiceUrlConfigState.isAnySoapNotUsingHttps(true);
        }
        return anySoapSloNotUsingHttps;
    }

    private boolean isAnyArsNotUsingHttps() {
        boolean anyArsNotUsingHttps = false;
        if (this.findState(this.artifactConfigState.getStateName()) != null) {
            anyArsNotUsingHttps |= this.artifactConfigState.anyEndpointNotUsingHttps();
        }
        return anyArsNotUsingHttps;
    }

    private boolean isAnySsoSelected() {
        return this.findParent(SamlProfilesApi.class).isAnySsoSelected() || this.isConnectionProtocol1x();
    }

    public List<String> getOutboundSsoBindingList() {
        ArrayList<String> bindings = new ArrayList<String>();
        if (this.assertionConsumerServiceState.isAnyBindingUsed()) {
            if (this.assertionConsumerServiceState.isPostBindingUsed()) {
                bindings.add("POST");
            }
            if (this.assertionConsumerServiceState.isRedirectBindingUsed()) {
                bindings.add("Redirect");
            }
            if (this.assertionConsumerServiceState.isArtifactBindingUsed()) {
                bindings.add("Artifact");
            }
        }
        return bindings;
    }

    public List<String> getOutboundSloBindingList() {
        ArrayList<String> bindings = new ArrayList<String>();
        if (this.sloServiceUrlConfigState.isAnyBindingUsed()) {
            if (this.sloServiceUrlConfigState.isPostBindingUsed()) {
                bindings.add("POST");
            }
            if (this.sloServiceUrlConfigState.isRedirectBindingUsed()) {
                bindings.add("Redirect");
            }
            if (this.sloServiceUrlConfigState.isArtifactBindingUsed()) {
                bindings.add("Artifact");
            }
            if (this.sloServiceUrlConfigState.isSoapBindingUsed()) {
                bindings.add("SOAP");
            }
        }
        return bindings;
    }

    public List<String> getInboundBindingList() {
        ArrayList<String> bindings = new ArrayList<String>();
        if (this.allowableSamlBindingsState.isAnyBindingSelected()) {
            if (this.isInboundPost()) {
                bindings.add("POST");
            }
            if (this.isInboundRedirect()) {
                bindings.add("Redirect");
            }
            if (this.isInboundArtifact()) {
                bindings.add("Artifact");
            }
            if (this.isInboundSoap()) {
                bindings.add("SOAP");
            }
        }
        return bindings;
    }

    public List<String> getEncryptionPolicyList() {
        ArrayList<String> policies = new ArrayList<String>();
        if (this.selectSpXmlAssertionEncryptionState.isNoneSelected()) {
            policies.add("No Encryption");
        } else {
            if (this.selectSpXmlAssertionEncryptionState.isEntireAssertionEncrypted()) {
                policies.add("SAML Assertion");
            }
            if (this.selectSpXmlAssertionEncryptionState.getEncryptSamlSubject()) {
                policies.add("SAML_Subject");
            }
            if (this.selectSpXmlAssertionEncryptionState.isOneOrMoreAttributesEncrypted()) {
                policies.add("One or more attributes");
            }
        }
        return policies;
    }

    public String getDefaultTargetUrl() {
        return this.defaultTargetUrlState.getDefaultTargetResource();
    }

    private boolean isJwtSelected() {
        SpConnectionConfigTasklet spConnTasklet = this.findParent(SpConnectionConfigTasklet.class);
        if (spConnTasklet != null) {
            return spConnTasklet.isWsFedJwt();
        }
        return false;
    }

    public WsTrustTokenType getWsFedTokenType() {
        SpConnectionConfigTasklet spConnTasklet = this.findParent(SpConnectionConfigTasklet.class);
        if (spConnTasklet != null) {
            return spConnTasklet.getWsFedTokenType();
        }
        return null;
    }

    public String getWsTrustVersion() {
        if (this.wsTrustVersionState != null) {
            return this.wsTrustVersionState.getVersionNumber();
        }
        return null;
    }

    @Override
    public void populate(Object dataFromDisk) {
        super.populate(dataFromDisk);
        if (this.isWsFedProtocol()) {
            this.selectSpXmlAssertionEncryptionState.setNoteKey("SpProtocolSettingsTasklet_SelectSpXmlAssertionEncryptionState_WsFed");
        }
    }
}

