/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.PasswordGenerationState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.UserInformationState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import java.util.List;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class UserInfoTasklet
extends Tasklet {
    private static final long serialVersionUID = 20050515L;
    private UserInformationState userInformationState;
    private PasswordGenerationState passwordGenerationState;
    private SummaryCardState summaryCardState;

    public UserInfoTasklet(Visit visit) {
        super("UserInfoTasklet", "User Information");
        this.setSystemVisit(visit);
        this.userInformationState = new UserInformationState(this);
        this.passwordGenerationState = new PasswordGenerationState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.userInformationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.passwordGenerationState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return UserInfoTasklet.this.userInformationState.getNewUser();
            }
        });
        this.userInformationState.addOutgoingTransition(this, this.summaryCardState);
        this.passwordGenerationState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.userInformationState);
        this.setCancelAvailable(true);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public AdministrativeUser getUserChanges() {
        AdministrativeUser user = new AdministrativeUser();
        this.userInformationState.getUserChanges(user);
        if (user.getSalt() == null || user.getHash() == null) {
            user.setPassword(this.passwordGenerationState.getGeneratedPassword());
            user.setNewPassword(this.passwordGenerationState.getGeneratedPassword());
            user.setLocalAccount(true);
        }
        return user;
    }

    public boolean isNewUser() {
        return this.userInformationState.getNewUser();
    }

    public void setNewUser(boolean newUser) {
        this.userInformationState.setNewUser(newUser);
        this.summaryCardState.setItClickable(!newUser);
    }

    public void setUsers(List<AdministrativeUser> users) {
        this.userInformationState.setUsers(users);
    }
}

