/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.c2ccontract.C2cContract;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConfigAdapterMappingState;
import com.pingidentity.fsm.state.impl.CreateAttributeContractState;
import com.pingidentity.fsm.state.impl.SelectIdpAccountLinkingState;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AccountLinkingApi;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.api.AuthnSourceListApi;
import com.pingidentity.fsm.tasklet.impl.IdpC2cContractMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConfigAdapterMappingTasklet;
import com.pingidentity.fsm.tasklet.impl.MultiProtocolTasklet;
import com.pingidentity.util.StringPairPropertySelectionModel;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.domain.AuthnAdapterInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.SpAdapterManager;
import org.sourceid.websso.Protocol;

public class UserSessionCreationTasklet
extends MultiProtocolTasklet
implements AccountLinkingApi,
AttributeNamesApi,
AuthnSourceListApi {
    private static final long serialVersionUID = 20050515L;
    final SelectIdpAccountLinkingState selectIdpAccountLinkingState;
    final CreateAttributeContractState createAttributeContractState;
    final ConfigAdapterMappingState configAdapterMappingState;
    final SummaryCardState summaryCardState;

    public UserSessionCreationTasklet(Visit visit) {
        super("UserSessionCreationTasklet", "User-Session Creation");
        this.setSystemVisit(visit);
        this.selectIdpAccountLinkingState = new SelectIdpAccountLinkingState(this);
        this.createAttributeContractState = new CreateAttributeContractState(this);
        this.configAdapterMappingState = new ConfigAdapterMappingState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.selectIdpAccountLinkingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configAdapterMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return UserSessionCreationTasklet.this.isAccountLinkingEnabled() && !UserSessionCreationTasklet.this.hasAdditionalAttributes();
            }
        });
        this.selectIdpAccountLinkingState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.createAttributeContractState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return UserSessionCreationTasklet.this.isAccountLinkingEnabled() && UserSessionCreationTasklet.this.hasAdditionalAttributes();
            }
        });
        this.selectIdpAccountLinkingState.addOutgoingTransition(this, this.createAttributeContractState);
        this.createAttributeContractState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.configAdapterMappingState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return !UserSessionCreationTasklet.this.selectIdpAccountLinkingState.isNone();
            }
        });
        this.createAttributeContractState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.summaryCardState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return UserSessionCreationTasklet.this.selectIdpAccountLinkingState.isNone();
            }
        });
        this.configAdapterMappingState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.selectIdpAccountLinkingState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        IdpConnection idpConnection = new IdpConnection();
        this.save(idpConnection);
        this.setPopulateData(idpConnection);
        super.finish();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public Protocol getProtocolType() {
        return ((MultiProtocolTasklet)this.getParentTasklet()).getProtocolType();
    }

    @Override
    public boolean isAccountLinkingEnabled() {
        return this.selectIdpAccountLinkingState.isLinking();
    }

    @Override
    public boolean hasAdditionalAttributes() {
        return this.selectIdpAccountLinkingState.getAddlAttrs();
    }

    @Override
    public boolean isTransientIdentifierEnabled() {
        return false;
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        if (this.retrieveMutableAttributeNames()) {
            return this.createAttributeContractState.getContract().getAllAttrNamesSorted();
        }
        return this.createAttributeContractState.getContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.createAttributeContractState.getContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.retrieveMutableAttributeNames() ? this.createAttributeContractState.getContract().getSortedMutableAttributeNames() : new ArrayList();
    }

    @Override
    public Set<String> getAllAttributeNames() {
        if (this.retrieveMutableAttributeNames()) {
            return this.createAttributeContractState.getContract().getAllAttributeNames();
        }
        return this.createAttributeContractState.getContract().getImmutableAttributeNames();
    }

    protected boolean retrieveMutableAttributeNames() {
        return !this.isAccountLinkingEnabled() || this.hasAdditionalAttributes();
    }

    @Override
    public StringPairPropertySelectionModel getAdapterList() {
        StringPairPropertySelectionModel adapterList = new StringPairPropertySelectionModel(true);
        SpAdapterManager spAdapterManager = MgmtFactory.getSpAdapterManager();
        List<IdpConfigAdapterMappingTasklet> tasklets = this.configAdapterMappingState.getAdapterTasklets();
        ArrayList<ConfigurablePluginInstance> connectionBasedRelatedPlugins = new ArrayList<ConfigurablePluginInstance>();
        for (AuthnAdapterInstance adapter : spAdapterManager.getInstances()) {
            String parentId;
            ConfigurablePluginInstance parentInstance;
            boolean adapterInUse = this.adapterInUseByThisConnection(adapter, tasklets);
            if (adapterInUse && adapter.isConnectionBasedPlugin() && (parentInstance = spAdapterManager.getInstance(parentId = adapter.getParentId())) != null) {
                connectionBasedRelatedPlugins.add(parentInstance);
            }
            if (adapterInUse || adapter.isConnectionBasedPlugin()) continue;
            adapterList.add(adapter.getName(), adapter);
        }
        for (ConfigurablePluginInstance instance : connectionBasedRelatedPlugins) {
            adapterList.remove(instance.getName());
        }
        adapterList.sort();
        return adapterList;
    }

    private boolean adapterInUseByThisConnection(AuthnAdapterInstance adapter, List<? extends Tasklet> tasklets) {
        if (tasklets != null) {
            for (Tasklet tasklet : tasklets) {
                IdpConfigAdapterMappingTasklet idp = (IdpConfigAdapterMappingTasklet)tasklet;
                if (idp.getSelectedPlugin() == null || !adapter.getId().equals(idp.getSelectedPlugin().getId())) continue;
                return true;
            }
        }
        return false;
    }

    public List<String> getAdapterIdsUsedInMappings() {
        ArrayList<String> adapterIds = new ArrayList<String>();
        List<IdpConfigAdapterMappingTasklet> tasklets = this.configAdapterMappingState.getAdapterTasklets();
        if (tasklets != null) {
            for (Tasklet tasklet : tasklets) {
                IdpConfigAdapterMappingTasklet idp = (IdpConfigAdapterMappingTasklet)tasklet;
                ConfigurablePluginInstance instance = idp.getSelectedPlugin();
                if (instance == null) continue;
                adapterIds.add(instance.getId());
            }
        }
        return adapterIds;
    }

    public boolean isAdditionalAttributesRequired() {
        return this.selectIdpAccountLinkingState.getAddlAttrs();
    }

    @Override
    public StringPairPropertySelectionModel getC2cContractList() {
        StringPairPropertySelectionModel contractList = new StringPairPropertySelectionModel(true);
        HashMap<String, String> contractNames2Id = new HashMap<String, String>();
        for (C2cContract c2cContract : MgmtFactory.getC2cContractManager().getContracts()) {
            contractNames2Id.put(c2cContract.getName(), c2cContract.getId());
        }
        for (IdpC2cContractMappingTasklet idpC2cContractMappingTasklet : this.configAdapterMappingState.getC2cTasklets()) {
            idpC2cContractMappingTasklet.refreshName();
        }
        for (IdpC2cContractMappingTasklet idpC2cContractMappingTasklet : this.configAdapterMappingState.getC2cTasklets()) {
            contractNames2Id.remove(idpC2cContractMappingTasklet.getContractName());
        }
        for (Map.Entry entry : contractNames2Id.entrySet()) {
            contractList.add((String)entry.getKey(), entry.getValue());
        }
        contractList.sort();
        return contractList;
    }

    public List<IdpC2cContractMappingTasklet> getC2cTasklets() {
        return this.configAdapterMappingState.getC2cTasklets();
    }

    public void refreshContract() {
        this.createAttributeContractState.onStateActivated();
    }
}

