/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.WsTrustRequestContractState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.WsTrustRequestContract;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.WsTrustRequestContractManager;

public class WsTrustRequestContractTasklet
extends Tasklet {
    private static final long serialVersionUID = 1L;
    final WsTrustRequestContractState requestContractState;
    private boolean markedForDelete;
    private boolean saveCalled;

    public WsTrustRequestContractTasklet(Visit visit) {
        this.setMenuName("Request Contract");
        this.setSystemVisit(visit);
        this.requestContractState = new WsTrustRequestContractState(this);
        this.setInitialState(this.requestContractState);
        this.setCancelAvailable(true);
    }

    @Override
    public void finish() {
        this.setSaveCalled(true);
        this.requestContractState.setNewRequestContract(false);
        this.setPopulateData(this.requestContractState.getCurrentContract());
        WsTrustRequestContract requestContract = new WsTrustRequestContract();
        this.save(requestContract);
        WsTrustRequestContractManager requestContractManager = (WsTrustRequestContractManager)GlobalRegistry.getService(WsTrustRequestContractManager.class);
        requestContractManager.store(requestContract);
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)requestContract, DependencyType.STS);
        super.finish();
    }

    public String getRequestContractName() {
        return this.requestContractState.getRequestContractName();
    }

    public String getRequestContractId() {
        return this.requestContractState.getRequestContractId();
    }

    public boolean isMarkedForDelete() {
        return this.markedForDelete;
    }

    public void setMarkedForDelete(boolean markedForDelete) {
        this.markedForDelete = markedForDelete;
    }

    @Override
    public String getClassType() {
        return this.markedForDelete ? "disabled" : "";
    }

    public boolean isInUse() {
        for (SpConnection spConnection : MgmtFactory.getConnectionManager().getFilteredSpConnections()) {
            if (!spConnection.doesWsTrustSettingsExist() || !spConnection.getWsTrustSettings().isRequestContractDefined()) continue;
            String connectionContractId = spConnection.getWsTrustSettings().getRequestContractId();
            if (!this.getRequestContractId().equals(connectionContractId)) continue;
            return true;
        }
        return false;
    }

    public WsTrustRequestContract getRequestContract() {
        WsTrustRequestContract requestContract = new WsTrustRequestContract();
        this.requestContractState.save(requestContract);
        return requestContract;
    }

    public boolean isSaveCalled() {
        return this.saveCalled;
    }

    public void setSaveCalled(boolean saveCalled) {
        this.saveCalled = saveCalled;
    }

    @Override
    public boolean isSaveAllAvailable() {
        return false;
    }
}

