/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.crypto.Cert;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsTrustRestrictByCertState;
import com.pingidentity.fsm.state.impl.WsTrustRestrictBySubjectDnState;
import com.pingidentity.fsm.state.impl.WsTrustSelectSslTypeState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.InUseCertsApi;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.ConnectionCerts;

public class WsTrustStsSslAuthTasklet
extends Tasklet
implements InUseCertsApi {
    private static final long serialVersionUID = 1L;
    private ConnectionCerts dsigConnectionCerts = new ConnectionCerts();
    final SummaryCardState summaryCardState;
    final WsTrustSelectSslTypeState wsTrustSelectSslTypeState;
    final WsTrustRestrictBySubjectDnState wsTrustRestrictBySubjectDnState;
    final WsTrustRestrictByCertState wsTrustRestrictByCertState;
    private static final Log log = LogFactory.getLog(WsTrustStsSslAuthTasklet.class);

    public WsTrustStsSslAuthTasklet(Visit visit) {
        super("WsTrustStsSslAuthTasklet", "Mutual SSL Authentication");
        this.setSystemVisit(visit);
        this.wsTrustSelectSslTypeState = new WsTrustSelectSslTypeState(this);
        this.wsTrustRestrictBySubjectDnState = new WsTrustRestrictBySubjectDnState(this);
        this.wsTrustRestrictByCertState = new WsTrustRestrictByCertState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.wsTrustSelectSslTypeState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustRestrictBySubjectDnState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return WsTrustStsSslAuthTasklet.this.wsTrustSelectSslTypeState.isRestrictBySubjectDn();
            }
        });
        this.wsTrustRestrictBySubjectDnState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustRestrictByCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return WsTrustStsSslAuthTasklet.this.wsTrustSelectSslTypeState.isRestrictByIssuerCert();
            }
        });
        this.wsTrustRestrictBySubjectDnState.addOutgoingTransition(this, this.summaryCardState);
        this.wsTrustSelectSslTypeState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustRestrictByCertState){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return WsTrustStsSslAuthTasklet.this.wsTrustSelectSslTypeState.isRestrictByIssuerCert();
            }
        });
        this.wsTrustRestrictByCertState.addOutgoingTransition(this, this.summaryCardState);
        this.wsTrustSelectSslTypeState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.wsTrustSelectSslTypeState);
        this.setCancelAvailable(true);
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.setPopulateData(data);
        super.populateAllStates(data);
        return true;
    }

    @Override
    public void finish() {
        WsTrustStsData wsTrustData = new WsTrustStsData();
        this.save(wsTrustData);
        this.setPopulateData(wsTrustData);
        super.finish();
    }

    @Override
    public void cancel() {
        for (TaskletState tempState : this.getStateList()) {
            log.debug((Object)(this.getTaskletName() + " cancel:" + tempState.getMessageSimpleName()));
            tempState.cancel(this.getPopulateData());
        }
    }

    @Override
    public ConnectionCerts getDsigConnectionCerts() {
        return this.dsigConnectionCerts;
    }

    @Override
    public void setDsigConnectionCerts(ConnectionCerts certs) {
        this.dsigConnectionCerts = certs;
    }

    public Cert getInUseSecondaryVerificationCert() {
        return null;
    }

    @Override
    public LinkedHashSet<Cert> getInUseVerificationCerts() {
        return new LinkedHashSet<Cert>(this.wsTrustRestrictByCertState.getInUseConnectionCerts());
    }

    @Override
    public Cert getInUseXmlEncryptionCert() {
        return null;
    }

    @Override
    public Set<Cert> getInUseXmlEncryptionCerts() {
        return this.getInUseVerificationCerts();
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletState state = (TaskletState)this.getSourceState();
        TaskletTransition tt = null;
        do {
            state.getSummary(summaryList);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public void gotoSummaryState(IRequestCycle cycle) {
        if (this.wsTrustSelectSslTypeState.isRestrictByIssuerCert() || this.wsTrustSelectSslTypeState.isRestrictBySubjectDn()) {
            super.gotoSummaryState(cycle);
        }
    }

    public void setRestrictBySubjectDnBreadcrumbs() {
        this.wsTrustRestrictBySubjectDnState.onStateActivated();
        this.wsTrustRestrictBySubjectDnState.setItClickable(this.wsTrustRestrictBySubjectDnState.hasAtLeastOneSubjectDn());
    }

    public void setRestrictByIssuerCertBreadcrumb() {
        this.wsTrustRestrictByCertState.onStateActivated();
        this.wsTrustRestrictByCertState.setItClickable(this.wsTrustRestrictByCertState.hasAtLeastOneEntry());
    }

    public boolean isRestrictBySubjectDn() {
        return this.wsTrustSelectSslTypeState.isRestrictBySubjectDn();
    }

    public boolean isRestrictByIssuerCert() {
        return this.wsTrustSelectSslTypeState.isRestrictByIssuerCert();
    }

    public String getAuthnOptionsStr() {
        return this.wsTrustSelectSslTypeState.getAuthnOptionsStr();
    }

    public List<String> getSubjectDNsList() {
        return this.wsTrustRestrictBySubjectDnState.getSubjectDNsList();
    }

    public String getIssuerCertsStr() {
        return this.wsTrustRestrictByCertState.getIssuerCertsStr();
    }
}

