/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.WsTrustSelectStsSystemAuthState;
import com.pingidentity.fsm.state.impl.WsTrustStsHttpBasicAuthState;
import com.pingidentity.fsm.state.impl.WsTrustStsSslAuthState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.SummaryInfo;
import com.pingidentity.fsm.tasklet.data.WsTrustStsData;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class WsTrustStsSystemAuthTasklet
extends Tasklet {
    private static final long serialVersionUID = 1L;
    final SummaryCardState summaryCardState;
    final WsTrustSelectStsSystemAuthState wsTrustSelectStsSystemAuthState;
    final WsTrustStsHttpBasicAuthState wsTrustStsHttpBasicAuth;
    final WsTrustStsSslAuthState wsTrustStsSslAuth;
    private static final Log log = LogFactory.getLog(WsTrustStsSystemAuthTasklet.class);

    public WsTrustStsSystemAuthTasklet(Visit visit) {
        super("WsTrustStsSystemAuthTasklet", "WS-Trust STS Settings");
        this.setSystemVisit(visit);
        this.wsTrustSelectStsSystemAuthState = new WsTrustSelectStsSystemAuthState(this);
        this.wsTrustStsHttpBasicAuth = new WsTrustStsHttpBasicAuthState(this);
        this.wsTrustStsSslAuth = new WsTrustStsSslAuthState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.wsTrustSelectStsSystemAuthState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustStsHttpBasicAuth){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return WsTrustStsSystemAuthTasklet.this.wsTrustSelectStsSystemAuthState.isEnableHttpBasic();
            }
        });
        this.wsTrustStsHttpBasicAuth.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustStsSslAuth){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return WsTrustStsSystemAuthTasklet.this.wsTrustSelectStsSystemAuthState.isEnableSsl();
            }
        });
        this.wsTrustStsHttpBasicAuth.addOutgoingTransition(this, this.summaryCardState);
        this.wsTrustSelectStsSystemAuthState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.wsTrustStsSslAuth){
            private static final long serialVersionUID = 20050515L;

            @Override
            public boolean validate() {
                return WsTrustStsSystemAuthTasklet.this.wsTrustSelectStsSystemAuthState.isEnableSsl();
            }
        });
        this.wsTrustStsSslAuth.addOutgoingTransition(this, this.summaryCardState);
        this.wsTrustSelectStsSystemAuthState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.wsTrustSelectStsSystemAuthState);
        this.setCancelAvailable(true);
    }

    public boolean doesUserExist(String username) {
        return this.wsTrustStsHttpBasicAuth.doesUserExist(username);
    }

    public boolean isAuthenticationEnabled() {
        return this.wsTrustSelectStsSystemAuthState.isEnableHttpBasic() || this.wsTrustSelectStsSystemAuthState.isEnableSsl();
    }

    @Override
    public boolean populateAllStates(Object data) {
        this.setPopulateData(data);
        super.populateAllStates(data);
        return true;
    }

    @Override
    public void finish() {
        WsTrustStsData wsTrustData = new WsTrustStsData();
        this.save(wsTrustData);
        this.setPopulateData(wsTrustData);
        super.finish();
    }

    @Override
    public void cancel() {
        for (TaskletState tempState : this.getStateList()) {
            log.debug((Object)(this.getTaskletName() + " cancel:" + tempState.getMessageSimpleName()));
            tempState.cancel(this.getPopulateData());
        }
    }

    @Override
    public void getSummary(ArrayList<SummaryInfo> summaryList) {
        TaskletState state = (TaskletState)this.getSourceState();
        TaskletTransition tt = null;
        do {
            state.getSummary(summaryList);
            tt = (TaskletTransition)state.getOutgoingTransition();
            if (tt == null) continue;
            state = (TaskletState)tt.getTarget();
        } while (tt != null);
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    private boolean hasAlreadyConfigured() {
        return this.wsTrustSelectStsSystemAuthState.isEnableHttpBasic() || this.wsTrustSelectStsSystemAuthState.isEnableSsl();
    }

    public void setHttpBasicAuthBreadcrumbs() {
        this.wsTrustStsHttpBasicAuth.onStateActivated();
        this.wsTrustStsHttpBasicAuth.setItClickable(this.wsTrustStsHttpBasicAuth.hasAtLeastOneUser());
    }

    public void setSslAuthBreadcrumb() {
        this.wsTrustStsSslAuth.onStateActivated();
        this.wsTrustStsSslAuth.setItClickable(this.wsTrustStsSslAuth.isRestrictBySubjectDn() || this.wsTrustStsSslAuth.isRestrictByIssuerCert());
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public String getAuthnMethodsStr() {
        return this.wsTrustSelectStsSystemAuthState.getAuthnMethodsStr();
    }

    public boolean isEnableHttpBasic() {
        return this.wsTrustSelectStsSystemAuthState.isEnableHttpBasic();
    }

    public String getBasicAuthUsersStr() {
        return this.wsTrustStsHttpBasicAuth.getBasicAuthUsersStr();
    }

    public boolean isEnableSsl() {
        return this.wsTrustSelectStsSystemAuthState.isEnableSsl();
    }

    public boolean isRestrictBySubjectDn() {
        return this.wsTrustStsSslAuth.isRestrictBySubjectDn();
    }

    public boolean isRestrictByIssuerCert() {
        return this.wsTrustStsSslAuth.isRestrictByIssuerCert();
    }

    public String getAuthnOptionsStr() {
        return this.wsTrustStsSslAuth.getAuthnOptionsStr();
    }

    public List<String> getSubjectDNsList() {
        return this.wsTrustStsSslAuth.getSubjectDNsList();
    }

    public String getIssuerCertsStr() {
        return this.wsTrustStsSslAuth.getIssuerCertsStr();
    }
}

