/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.localidentity;

import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.localidentity.DataStoreMappingState;
import com.pingidentity.fsm.state.impl.localidentity.DataStoreSelectionState;
import com.pingidentity.fsm.state.impl.localidentity.LdapGeneralInfoState;
import com.pingidentity.fsm.state.impl.localidentity.LdapWriteIdentityState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.api.AttributeSourceApi;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.util.SAML2MappingModel;
import java.util.List;
import java.util.stream.Collectors;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.TokenAuthorizationIssuanceCriterion;

public class DataStoreConfigTasklet
extends Tasklet
implements AttributeSourceApi {
    private final DataStoreSelectionState dataStoreSelectionState;
    private final LdapGeneralInfoState ldapGeneralInfoState;
    private final LdapWriteIdentityState ldapWriteIdentityState;
    private final DataStoreMappingState dataStoreMappingState;
    private final SummaryCardState summaryState;

    public DataStoreConfigTasklet(Visit visit) {
        super("DataStoreConfigTasklet", "Data Store Configuration");
        this.setSystemVisit(visit);
        this.dataStoreSelectionState = new DataStoreSelectionState(this, "localIdentityDataStoreSelection");
        this.ldapGeneralInfoState = new LdapGeneralInfoState(this);
        this.ldapWriteIdentityState = new LdapWriteIdentityState(this);
        this.dataStoreMappingState = new DataStoreMappingState(this);
        this.summaryState = new SummaryCardState(this);
        this.createTransitions();
        this.setCancelAvailable(true);
    }

    private void createTransitions() {
        this.dataStoreSelectionState.addOutgoingTransition(this, this.ldapGeneralInfoState);
        this.ldapGeneralInfoState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.ldapWriteIdentityState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return DataStoreConfigTasklet.this.findParent(LocalIdentityProfileTasklet.class).isRegistrationEnabled();
            }
        });
        this.ldapGeneralInfoState.addOutgoingTransition(this, this.dataStoreMappingState);
        this.ldapWriteIdentityState.addOutgoingTransition(this, this.dataStoreMappingState);
        this.dataStoreMappingState.addOutgoingTransition(this, this.summaryState);
        this.setInitialState(this.dataStoreSelectionState);
    }

    @Override
    public boolean includeAdditionalValues() {
        return false;
    }

    @Override
    public AttributeSourceApi.ConnectionType getConnectionType() {
        return null;
    }

    @Override
    public String getDescription() {
        return null;
    }

    @Override
    public String getType() {
        return null;
    }

    @Override
    public String getDataSourceType() {
        return null;
    }

    @Override
    public List<String> getSelectedColumns() {
        return null;
    }

    @Override
    public List<String> getSelectedAttributes() {
        return this.ldapGeneralInfoState.getSelectedAttributes();
    }

    @Override
    public List<String> getSelectedFields() {
        return null;
    }

    @Override
    public List<String> getAllColumns() {
        return null;
    }

    @Override
    public List<String> getAllAttributes() {
        return this.ldapGeneralInfoState.getAllAttributes();
    }

    @Override
    public List<String> getAllFields() {
        return null;
    }

    @Override
    public DataSource getSelectedDataSource() {
        return this.dataStoreSelectionState.getSelectedDataSource();
    }

    @Override
    public String getTableName() {
        return null;
    }

    @Override
    public ConfigurablePluginInstance getSelectedPlugin() {
        return null;
    }

    @Override
    public String getSelectedAdapterDataSource() {
        return null;
    }

    @Override
    public List<String> getContractToFulfill() {
        List<LocalIdentityField<?>> fields = this.findParent(LocalIdentityProfileTasklet.class).getFields();
        return fields.stream().filter(field -> !field.isMarkedForDelete()).map(field -> field.getData().getId()).collect(Collectors.toList());
    }

    @Override
    public boolean isDataStoreAvailable(DataSource dataSource) {
        return false;
    }

    @Override
    public SAML2MappingModel getMappingModel() {
        return null;
    }

    @Override
    public List<? extends TokenAuthorizationIssuanceCriterion> getIssuanceCriterion() {
        return null;
    }

    @Override
    public CustomDataSource getSelectedCustomDataSource() {
        return null;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void removeDataStoreAttribute(String dataStoreValueToRemove) {
        this.ldapGeneralInfoState.remove(dataStoreValueToRemove);
    }
}

