/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.localidentity;

import com.pingidentity.fsm.IWizard;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.localidentity.FieldConfigState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.localidentity.LocalIdentityProfileTasklet;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import java.util.List;

public class FieldConfigTasklet
extends Tasklet {
    private final FieldConfigState fieldConfigState;
    private final SummaryCardState summaryState;

    public FieldConfigTasklet(Visit visit) {
        this(visit, true);
    }

    public FieldConfigTasklet(Visit visit, boolean isNewField) {
        super("FieldConfigTasklet", "Field Configuration");
        this.setSystemVisit(visit);
        this.setCancelAvailable(true);
        this.fieldConfigState = new FieldConfigState((IWizard)this, isNewField);
        this.summaryState = new SummaryCardState(this);
        this.summaryState.setItClickable(true);
        this.fieldConfigState.addOutgoingTransition(this, this.summaryState);
        this.setInitialState(this.fieldConfigState);
    }

    @Override
    public void setMode(Mode mode) {
        super.setMode(mode);
    }

    public String getFieldTypeName() {
        return this.fieldConfigState.getType().getLabel();
    }

    public String getFieldTypeId() {
        return this.fieldConfigState.getId();
    }

    public String getFieldTypeLabel() {
        return this.fieldConfigState.getLabel();
    }

    public boolean isRegistrationAndProfileEnabled() {
        return this.isRegistrationEnabled() && this.isProfileEnabled();
    }

    public boolean isRegistrationEnabled() {
        LocalIdentityProfileTasklet tasklet = this.getParent();
        return tasklet.isRegistrationEnabled();
    }

    public boolean isProfileEnabled() {
        LocalIdentityProfileTasklet tasklet = this.getParent();
        return tasklet.isProfileEnabled();
    }

    public LocalIdentityField<?> getLocalIdentityField() {
        return this.fieldConfigState.toLocalIdentityField();
    }

    public List<LocalIdentityField<?>> getFieldList() {
        LocalIdentityProfileTasklet tasklet = this.getParent();
        return tasklet.getFields();
    }

    public String getFieldId() {
        return this.fieldConfigState.getId();
    }

    public boolean canBeUniqueIdField() {
        return this.fieldConfigState.getFieldAttributes().containsKey("Unique ID Field");
    }

    public boolean isUniqueIdField() {
        return this.fieldConfigState.getFieldAttributes().getOrDefault("Unique ID Field", false);
    }

    private LocalIdentityProfileTasklet getParent() {
        return this.findParent(LocalIdentityProfileTasklet.class);
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public void setUnique(boolean unique) {
        if (this.fieldConfigState.getFieldAttributes().containsKey("Unique ID Field")) {
            this.fieldConfigState.getFieldAttributes().put("Unique ID Field", unique);
        }
    }

    public boolean isShowOnRegistration() {
        return this.fieldConfigState.isShowOnRegistration();
    }

    public boolean isShowOnProfile() {
        return this.fieldConfigState.isShowOnProfile();
    }

    public void setShowOnRegistration(boolean showOnRegistration) {
        this.fieldConfigState.setShowOnRegistration(showOnRegistration);
    }

    public void setShowOnProfile(boolean showOnProfile) {
        this.fieldConfigState.setShowOnProfile(showOnProfile);
    }

    public void onLoad() {
        if (this.isModeCreate()) {
            this.setPopulateData(this.getLocalIdentityField());
        }
    }
}

