/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.localidentity;

import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.IWizardState;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.localidentity.DataStoreConfigState;
import com.pingidentity.fsm.state.impl.localidentity.FieldConfigState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityAuthSourcesState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityEmailVerificationState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentityGeneralInfoState;
import com.pingidentity.fsm.state.impl.localidentity.LocalIdentitySummaryState;
import com.pingidentity.fsm.state.impl.localidentity.ProfileConfigState;
import com.pingidentity.fsm.state.impl.localidentity.RegistrationConfigState;
import com.pingidentity.fsm.state.impl.localidentity.fields.FieldsConfigState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.TaskletTransition;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.localidentity.fieldtypes.LocalIdentityField;
import com.pingidentity.localidentity.mgmt.LocalIdentityManager;
import java.util.List;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class LocalIdentityProfileTasklet
extends Tasklet {
    private static final long serialVersionUID = 20200508L;
    private final transient LocalIdentityManager profileManager = MgmtFactory.getLocalIdentityProfileManager();
    private final LocalIdentityGeneralInfoState generalInfoState;
    private final LocalIdentityAuthSourcesState authSourcesState;
    private final LocalIdentityEmailVerificationState emailVerificationState;
    private final FieldsConfigState fieldConfigState;
    private final RegistrationConfigState registrationConfigState;
    private final DataStoreConfigState dataStoreConfigState;
    private final ProfileConfigState profileConfigState;
    private final LocalIdentitySummaryState summaryState;

    public LocalIdentityProfileTasklet(Visit visit) {
        super("LocalIdentityProfileTasklet", "Local Identity Profile");
        this.setSystemVisit(visit);
        this.generalInfoState = new LocalIdentityGeneralInfoState(this);
        this.authSourcesState = new LocalIdentityAuthSourcesState(this);
        this.emailVerificationState = new LocalIdentityEmailVerificationState(this);
        this.fieldConfigState = new FieldsConfigState(this);
        this.registrationConfigState = new RegistrationConfigState(this);
        this.dataStoreConfigState = new DataStoreConfigState(this);
        this.profileConfigState = new ProfileConfigState(this);
        this.summaryState = new LocalIdentitySummaryState(this);
        this.createTransitions();
        this.setCancelAvailable(true);
    }

    private void createTransitions() {
        this.generalInfoState.addOutgoingTransition(this, this.authSourcesState);
        this.authSourcesState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.fieldConfigState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return LocalIdentityProfileTasklet.this.isRegistrationEnabled() || LocalIdentityProfileTasklet.this.isProfileEnabled();
            }
        });
        this.authSourcesState.addOutgoingTransition(this, this.summaryState);
        this.fieldConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.emailVerificationState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return LocalIdentityProfileTasklet.this.isRegistrationEnabled() || LocalIdentityProfileTasklet.this.isProfileEnabled();
            }
        });
        this.emailVerificationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.registrationConfigState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return LocalIdentityProfileTasklet.this.isRegistrationEnabled();
            }
        });
        this.emailVerificationState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.profileConfigState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return LocalIdentityProfileTasklet.this.isProfileEnabled();
            }
        });
        this.emailVerificationState.addOutgoingTransition(this, this.dataStoreConfigState);
        this.registrationConfigState.addOutgoingTransition(new TaskletTransition(this, (IWizardState)this.profileConfigState){
            private static final long serialVersionUID = 1L;

            @Override
            public boolean validate() {
                return LocalIdentityProfileTasklet.this.isProfileEnabled();
            }
        });
        this.registrationConfigState.addOutgoingTransition(this, this.dataStoreConfigState);
        this.profileConfigState.addOutgoingTransition(this, this.dataStoreConfigState);
        this.dataStoreConfigState.addOutgoingTransition(this, this.summaryState);
        this.setInitialState(this.generalInfoState);
    }

    @Override
    public void finish() {
        LocalIdentityProfile profile = new LocalIdentityProfile();
        this.save(profile);
        this.setMode(Mode.edit);
        this.profileManager.saveProfile(profile);
        DependencyErrorUIValidatorImpl affectedItemValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)profile, DependencyType.AUTHN_POLICY_ATTRS);
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)affectedItemValidator, (Object)profile, DependencyType.FRAGMENT_ATTRS);
        super.finish();
    }

    @Override
    public void reconfigureTransitions() {
        this.createTransitions();
    }

    public boolean isProfileEnabled() {
        return this.generalInfoState.isProfilePageEnabled();
    }

    public boolean isRegistrationEnabled() {
        return this.generalInfoState.isRegistrationEnabled();
    }

    public String getProfileName() {
        return this.generalInfoState.getName();
    }

    public String getProfileId() {
        return this.generalInfoState.getId();
    }

    public boolean isInUse() {
        return MgmtFactory.getLocalIdentityProfileManager().isProfileInUse(this.getProfileId());
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    public List<LocalIdentityField<?>> getFields() {
        return this.fieldConfigState.getFieldListCopy();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryState;
    }

    @Override
    public boolean next(IRequestCycle cycle) {
        if (this.getCurrentState() instanceof FieldConfigState || this.getCurrentState() instanceof LocalIdentityGeneralInfoState) {
            boolean registrationAndProfileEnabled = this.isRegistrationEnabled() && this.isProfileEnabled();
            this.getFields().forEach(field -> {
                if (!registrationAndProfileEnabled) {
                    this.fieldConfigState.resetAppliesTo();
                }
            });
        }
        return super.next(cycle);
    }

    public boolean isEmailVerificationEnabled() {
        return this.emailVerificationState.isEmailVerificationEnabled();
    }
}

