/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.impl.oauth.exchange;

import com.pingidentity.admin.api.validator.oauth.exchange.UiProcessorMappingTokenTypeValidator;
import com.pingidentity.dependency.error.DependencyErrorHandler;
import com.pingidentity.dependency.error.DependencyErrorUIValidator;
import com.pingidentity.dependency.error.DependencyErrorUIValidatorImpl;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.SummaryCardState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorMappingState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorPolicyContractState;
import com.pingidentity.fsm.state.impl.oauth.exchange.ProcessorPolicyManagementState;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.api.AttributeNamesApi;
import com.pingidentity.fsm.tasklet.data.DependencyType;
import com.pingidentity.fsm.tasklet.impl.oauth.exchange.BasePolicyManagementTasklet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorMapping;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicies;
import org.sourceid.oauth20.exchange.domain.TokenExchangeProcessorPolicy;
import org.sourceid.oauth20.exchange.manager.TokenExchangeProcessorPolicyManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.wstrust.mgmt.TokenProcessorInstance;
import org.sourceid.wstrust.mgmt.TokenProcessorManager;

public class ProcessorPolicyManagementTasklet
extends BasePolicyManagementTasklet
implements AttributeNamesApi {
    private static final long serialVersionUID = 20200508L;
    private static final String MENU_NAME = "Token Exchange Processor Policy";
    private final transient TokenExchangeProcessorPolicyManager processorPolicyManager = MgmtFactory.getTokenExchangeProcessorPolicyManager();
    private ProcessorPolicyManagementState processorPolicyManagementState;
    private ProcessorPolicyContractState processorPolicyContractState;
    private ProcessorMappingState processorMappingState;
    private SummaryCardState summaryCardState;

    public ProcessorPolicyManagementTasklet(Visit visit) {
        super("ProcessorPolicyManagementTasklet", MENU_NAME);
        this.setSystemVisit(visit);
        this.processorPolicyManagementState = new ProcessorPolicyManagementState(this);
        this.processorPolicyContractState = new ProcessorPolicyContractState(this);
        this.processorMappingState = new ProcessorMappingState(this);
        this.summaryCardState = new SummaryCardState(this);
        this.processorPolicyManagementState.addOutgoingTransition(this, this.processorPolicyContractState);
        this.processorPolicyContractState.addOutgoingTransition(this, this.processorMappingState);
        this.processorMappingState.addOutgoingTransition(this, this.summaryCardState);
        this.setInitialState(this.processorPolicyManagementState);
        this.setCancelAvailable(true);
        this.setSaveDraftAvailable(false);
    }

    @Override
    public String getId() {
        return this.processorPolicyManagementState.getId();
    }

    @Override
    public void delete() {
        TokenExchangeProcessorPolicies tepps = this.processorPolicyManager.getTokenExchangeProcessorPolicies();
        TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy = this.getTokenExchangeProcessorPolicy();
        tepps.removePolicy(tokenExchangeProcessorPolicy.getId());
        this.processorPolicyManager.saveTokenExchangeProcessorPolicies(tepps);
        this.doDependencyErrors(tokenExchangeProcessorPolicy);
    }

    private void doDependencyErrors(TokenExchangeProcessorPolicy tepp) {
        DependencyErrorUIValidatorImpl dependencyErrorUIValidator = new DependencyErrorUIValidatorImpl(this);
        DependencyErrorHandler dependencyErrorHandler = new DependencyErrorHandler();
        dependencyErrorHandler.performDependencyValidation((DependencyErrorUIValidator)dependencyErrorUIValidator, (Object)tepp, DependencyType.TOKEN_EXCHANGE_PROCESSOR_POLICY);
        for (TokenExchangeProcessorMapping mapping : tepp.getTokenExchangeProcessorMappings().values()) {
            this.processTokenProcessorDependency(dependencyErrorUIValidator, dependencyErrorHandler, mapping.getSubjectTokenProcessorId());
            this.processTokenProcessorDependency(dependencyErrorUIValidator, dependencyErrorHandler, mapping.getActorTokenProcessorId());
        }
    }

    public String getName() {
        return this.processorPolicyManagementState.getName();
    }

    @Override
    public TaskletState getSummaryState() {
        return this.summaryCardState;
    }

    @Override
    public boolean isSaveDraftAvailable() {
        return false;
    }

    @Override
    public void finish() {
        TokenExchangeProcessorPolicies tepps = this.processorPolicyManager.getTokenExchangeProcessorPolicies();
        TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy = this.getTokenExchangeProcessorPolicy();
        tepps.addPolicy(tokenExchangeProcessorPolicy);
        if (StringUtils.isBlank((String)tepps.getDefaultInstanceId())) {
            tepps.setDefaultInstanceId(tokenExchangeProcessorPolicy.getId());
        }
        this.processorPolicyManager.saveTokenExchangeProcessorPolicies(tepps);
        this.doDependencyErrors(tokenExchangeProcessorPolicy);
        super.finish();
    }

    @Override
    public void cancel() {
        Object origData = this.getPopulateData();
        if (origData != null) {
            TokenExchangeProcessorPolicy policy = (TokenExchangeProcessorPolicy)origData;
            super.cancel();
            this.setPopulateData(policy);
        } else {
            super.cancel();
        }
    }

    public TokenExchangeProcessorPolicy getTokenExchangeProcessorPolicy() {
        TokenExchangeProcessorPolicy tokenExchangeProcessorPolicy = new TokenExchangeProcessorPolicy();
        this.save(tokenExchangeProcessorPolicy);
        return tokenExchangeProcessorPolicy;
    }

    @Override
    public Set<String> getAllAttributeNames() {
        return this.processorPolicyContractState.getContract().getAllAttributeNames();
    }

    @Override
    public List<String> getAllAttrNamesSorted() {
        return this.processorPolicyContractState.getContract().getAllAttrNamesSorted();
    }

    @Override
    public List<String> getSortedImmutableAttributeNames() {
        return this.processorPolicyContractState.getContract().getSortedImmutableAttributeNames();
    }

    @Override
    public List<String> getSortedMutableAttributeNames() {
        return this.processorPolicyContractState.getContract().getSortedMutableAttributeNames();
    }

    public boolean isActorTokenRequired() {
        return this.processorPolicyManagementState.isActorTokenRequired();
    }

    public List<UiProcessorMappingTokenTypeValidator.TokenTypePair> getTokenTypePairs(String taskletId) {
        return this.processorMappingState.getTokenTypePairs(taskletId);
    }

    public String getDescription() {
        return this.getName();
    }

    private void processTokenProcessorDependency(DependencyErrorUIValidator dependencyErrorUIValidator, DependencyErrorHandler dependencyErrorHandler, String tokenProcessorId) {
        if (StringUtils.isNotEmpty((String)tokenProcessorId)) {
            TokenProcessorManager tokenProcessorManager = MgmtFactory.getTokenProcessorManager();
            TokenProcessorInstance tokenProcessorInstance = (TokenProcessorInstance)tokenProcessorManager.getInstance(tokenProcessorId);
            dependencyErrorHandler.performDependencyValidation(dependencyErrorUIValidator, (Object)tokenProcessorInstance, DependencyType.TOKEN_PROCESSOR);
        }
    }
}

