/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.fsm.tasklet.util;

import com.pingidentity.component.common.Pagination;
import com.pingidentity.fsm.tasklet.Tasklet;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.ArrayList;
import java.util.List;

public class DisplayPaginationHelper {
    public static Integer getLookAheadAvailableIndex(Object paginationState, List<Tasklet> tasklets) {
        if (paginationState != null && tasklets != null && tasklets.size() > 0) {
            int currentPage = ((Pagination.State)paginationState).getCurrentPage();
            int pagesPerBlock = ((Pagination.State)paginationState).MAX_PAGES_PER_BLOCK;
            return DisplayPaginationHelper.getLookAheadAvailableMaxIndexForPaginationBlock(currentPage, 20, pagesPerBlock, tasklets);
        }
        return -1;
    }

    @SuppressFBWarnings(value={"RV_RETURN_VALUE_IGNORED_NO_SIDE_EFFECT"}, justification="this is a side effect of the look ahead algorithm")
    private static Integer getLookAheadAvailableMaxIndexForPaginationBlock(int currentPage, int maxItemsPerPage, int pagesPerBlock, List<Tasklet> tasklets) {
        int availableItemIndex = currentPage == 1 || currentPage == 2 || currentPage == 3 ? maxItemsPerPage * pagesPerBlock - maxItemsPerPage : maxItemsPerPage * (currentPage + 2) - maxItemsPerPage;
        boolean indexNotFound = true;
        while (indexNotFound) {
            try {
                tasklets.get(availableItemIndex);
                indexNotFound = false;
            }
            catch (IndexOutOfBoundsException ex) {
                availableItemIndex -= maxItemsPerPage;
            }
        }
        return availableItemIndex;
    }

    public static List<Tasklet> getPagedTasklets(Object paginationState, List<Tasklet> tasklets) {
        ArrayList<Tasklet> serializableList = new ArrayList<Tasklet>();
        int totalTasklets = tasklets.size();
        if (paginationState != null) {
            int currentPage = ((Pagination.State)paginationState).getCurrentPage();
            int startIndex = (currentPage - 1) * 20;
            int toIndex = Math.min(startIndex + 20, totalTasklets);
            serializableList.addAll(tasklets.subList(startIndex, toIndex));
        }
        return new ArrayList<Tasklet>(serializableList);
    }
}

