/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.c2ccontract.C2cContractAttributeMapping;
import com.pingidentity.c2ccontract.C2cContractToAssertionMapping;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.InUsePopUp;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.oauth20.domain.ApcToUserKeyAttrMapping;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.SpConnection;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class C2cContractInUsePopUp
extends InUsePopUp {
    private ConnectionManager connMgr = MgmtFactory.getConnectionManager();
    private final List<InUseItem> authnSelectorsUsingResource = new LinkedList<InUseItem>();

    @Override
    protected void loadIdpConnectionsUsingResource() {
        this.idpConnectionsUsingResource.clear();
        Collection idpConnections = this.connMgr.getFilteredIdpConnections();
        block0: for (IdpConnection idp : idpConnections) {
            for (C2cContractAttributeMapping c2cAttributeMapping : idp.getC2cContractMappings()) {
                if (!this.id.equals(c2cAttributeMapping.getContractId())) continue;
                this.idpConnectionsUsingResource.add(new InUseItem(idp.getName(), idp.getEntityId()));
                continue block0;
            }
        }
    }

    @Override
    protected void loadLocalIdentityProfilesUsingResource() {
        List inUseItems = MgmtFactory.getLocalIdentityProfileManager().getProfiles().stream().filter(lip -> this.id.equals(lip.getContractId())).map(lip -> new InUseItem(lip.getName(), lip.getId())).collect(Collectors.toList());
        this.lipsUsingResource.clear();
        this.lipsUsingResource.addAll(inUseItems);
    }

    @Override
    protected void loadSpConnectionsUsingResource() {
        this.spConnectionsUsingResource.clear();
        Collection spConnections = this.connMgr.getFilteredSpConnections();
        block0: for (SpConnection sp : spConnections) {
            for (C2cContractToAssertionMapping c2cMapping : sp.getC2cMappings()) {
                if (!this.id.equals(c2cMapping.getContractId())) continue;
                this.spConnectionsUsingResource.add(new InUseItem(sp.getName(), sp.getEntityId()));
                continue block0;
            }
        }
    }

    @Override
    protected void loadApc2SpAdapterMappingsUsingResource() {
        this.apc2SpAdapterMappingsUsingResource.clear();
        List mappings = MgmtFactory.getApc2SpAdapterManager().getMappingsUsingSource(this.id);
        for (Direct2SpAdapterMapping mapping : mappings) {
            String name = this.buildApc2SpAdapterMappingName((Source2TargetMapping)mapping);
            if (this.currentItemsContains(name, this.apc2SpAdapterMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.apc2SpAdapterMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadApcToUserKeyMappingsUsingResource() {
        this.oauthApcToUserKeyMappingsUsingResource.clear();
        ApcToUserKeyAttrMapping mapping = MgmtFactory.getAuthzServerManager().getApcToUserKeyMapping(this.id);
        if (mapping != null) {
            String name = this.buildApcToUserKeyName(mapping.getApcId());
            InUseItem item = new InUseItem(name);
            this.oauthApcToUserKeyMappingsUsingResource.add(item);
        }
    }

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        this.authnSelectorsUsingResource.clear();
        super.activateExternalPage(objs, cycle);
        this.loadAuthnSelectorsUsingResource();
    }

    public boolean isShowAuthnSelectorsUsingResource() {
        return !this.authnSelectorsUsingResource.isEmpty();
    }

    public List<InUseItem> getAuthnSelectorsUsingResource() {
        return this.authnSelectorsUsingResource;
    }

    @Override
    protected void loadFragmentsUsingResource() {
        this.fragmentsUsingResource.clear();
        List fragments = InUseDetectionUtil.getInstance().getFragmentsWithPolicyContractInUse(this.id);
        for (PolicyFragment fragment : fragments) {
            String name = fragment.getName();
            if (this.currentItemsContains(name, this.fragmentsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.fragmentsUsingResource.add(item);
        }
    }

    private void loadAuthnSelectorsUsingResource() {
        List trees = InUseDetectionUtil.getInstance().getAuthnSelectionTreesWithPolicyContractInUse(this.id);
        for (AuthnSelectionTree tree : trees) {
            String name = this.getNameForAuthnSelectionTree(tree);
            if (this.currentItemsContains(name, this.authnSelectorsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.authnSelectorsUsingResource.add(item);
        }
    }

    @Override
    protected void loadIdpAdaptersUsingResource() {
        this.idpAdaptersUsingResource.clear();
        List instances = InUseDetectionUtil.getInstance().getIdpAdaptersWithApcInUse(this.id);
        for (IdpAuthnAdapterInstance instance : instances) {
            InUseItem item = new InUseItem(instance.getName(), instance.getId());
            this.idpAdaptersUsingResource.add(item);
        }
    }
}

