/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.InUsePopUp;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class FragmentInUsePopUp
extends InUsePopUp {
    private final List<InUseItem> authnSelectionTreesUsingResource = new LinkedList<InUseItem>();

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        super.activateExternalPage(objs, cycle);
        this.loadAuthnSelectionTreesUsingResource();
    }

    public boolean isShowAuthnSelectionTreesUsingResource() {
        return !this.authnSelectionTreesUsingResource.isEmpty();
    }

    public List<InUseItem> getAuthnSelectionTreesUsingResource() {
        return this.authnSelectionTreesUsingResource;
    }

    private void loadAuthnSelectionTreesUsingResource() {
        this.authnSelectionTreesUsingResource.clear();
        List trees = InUseDetectionUtil.getInstance().getAuthnSelectionTreesWithFragmentInUse(this.id);
        for (AuthnSelectionTree tree : trees) {
            String name = this.getNameForAuthnSelectionTree(tree);
            if (this.currentItemsContains(name, this.authnSelectionTreesUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.authnSelectionTreesUsingResource.add(item);
        }
    }

    @Override
    protected void loadFragmentsUsingResource() {
        this.fragmentsUsingResource.clear();
        List fragments = InUseDetectionUtil.getInstance().getFragmentsWithFragmentInUse(this.id);
        for (PolicyFragment fragment : fragments) {
            String name = fragment.getName();
            if (this.currentItemsContains(name, this.fragmentsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.fragmentsUsingResource.add(item);
        }
    }

    @Override
    protected void loadLocalIdentityProfilesUsingResource() {
        this.lipsUsingResource.clear();
        PolicyFragment fragment = MgmtFactory.getPolicyFragmentManager().getFragment(this.id);
        List inUseItems = MgmtFactory.getLocalIdentityProfileManager().getProfiles().stream().filter(lip -> lip.getRegistrationConfig() != null && fragment.getId().equals(lip.getRegistrationConfig().getRegistrationWorkflowFragmentId())).map(lip -> new InUseItem(lip.getName(), lip.getId())).collect(Collectors.toList());
        this.lipsUsingResource.addAll(inUseItems);
    }
}

