/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.component.common.VersionComponent;
import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.state.impl.ConnMgmtState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.ConnectionType;
import com.pingidentity.fsm.tasklet.data.Mode;
import com.pingidentity.fsm.tasklet.impl.ConnectionTasklet;
import com.pingidentity.fsm.tasklet.impl.DependencyErrorManagementTasklet;
import com.pingidentity.fsm.tasklet.impl.IdpConnectionConfigTasklet;
import com.pingidentity.fsm.tasklet.impl.MainMenuTasklet;
import com.pingidentity.fsm.tasklet.impl.SingleStateTasklet;
import com.pingidentity.page.ValidatePage;
import com.pingidentity.pingone.PingOneAdminService;
import java.util.ArrayList;
import javax.servlet.ServletContext;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IActionListener;
import org.apache.tapestry.ILocation;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IMessages;
import org.apache.tapestry.IRender;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.asset.ContextAsset;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageValidateListener;
import org.apache.tapestry.resource.ContextResourceLocation;
import org.sourceid.openid.connect.domain.OAuthClientConnection;
import org.sourceid.openid.connect.domain.OIDCProviderConnection;
import org.sourceid.saml20.domain.mgmt.AdminAuthManager;
import org.sourceid.saml20.domain.mgmt.AdminUserManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public abstract class Frame
extends ValidatePage
implements PageValidateListener {
    private IMessages messages;

    public abstract IActionListener getSubmitListener();

    public abstract void setSubmitListener(IActionListener var1);

    public void onNext(IRequestCycle cycle) {
        this.getCurrentTasklet(cycle).next(cycle);
    }

    public void onPrevious(IRequestCycle cycle) {
        this.getCurrentTasklet(cycle).previous(cycle);
    }

    public void onCancel(IRequestCycle cycle) {
        Tasklet currentTasklet = this.getCurrentTasklet(cycle);
        if (currentTasklet.isSkipPopToParent()) {
            currentTasklet.onCancelWithoutPop(cycle);
        } else {
            currentTasklet.onCancel(cycle);
        }
    }

    public void onFinish(IRequestCycle cycle) {
        Tasklet tasklet = this.getCurrentTasklet(cycle);
        boolean continueProcessing = tasklet.onFinish(cycle);
        if (continueProcessing && tasklet.isSkipPopToParent()) {
            if (!tasklet.gotoSummaryIfPopSkipped()) {
                tasklet.setCurrentState(tasklet.getInitialState());
            } else {
                tasklet.reconfigureTransitions();
                tasklet.gotoSummaryState(cycle);
            }
        }
    }

    public void onFinishAll(IRequestCycle cycle) {
        Tasklet tasklet = this.getCurrentTasklet(cycle);
        while (!(tasklet instanceof MainMenuTasklet) && !(tasklet instanceof DependencyErrorManagementTasklet) && tasklet.onFinish(cycle) && !tasklet.isSkipPopToParent()) {
            tasklet = this.getCurrentTasklet(cycle);
            tasklet.formListener(cycle);
        }
    }

    public void onSaveDraft(IRequestCycle cycle) {
        boolean wasDraftSuccessful;
        String role;
        ConnectionTasklet t = this.getCurrentTasklet(cycle).findParent(ConnectionTasklet.class);
        String string = role = t instanceof IdpConnectionConfigTasklet ? "IdP" : "SP";
        if (t != null && !(wasDraftSuccessful = t.saveDraft(cycle))) {
            Tasklet currentTasklet = this.getCurrentTasklet(cycle);
            if (currentTasklet instanceof SingleStateTasklet) {
                SingleStateTasklet connsTasklet = (SingleStateTasklet)currentTasklet;
                if (connsTasklet.getCurrentState() instanceof ConnMgmtState) {
                    ConnMgmtState connMgmtState = (ConnMgmtState)connsTasklet.getCurrentState();
                    connMgmtState.setDraftSuccessful(false);
                    this.onNext(cycle);
                }
            } else if (currentTasklet instanceof MainMenuTasklet) {
                MainMenuTasklet mainMenuTasklet = (MainMenuTasklet)currentTasklet;
                if (LicenseManager.canAddConnection()) {
                    Tasklet tasklet = currentTasklet;
                    ConnMgmtState state = new ConnMgmtState(tasklet);
                    if (role.equals("IdP")) {
                        tasklet = mainMenuTasklet.createTaskletToLoad(SingleStateTasklet.class, "IdpConnectionsTasklet", "IdP Connections");
                        state.setConnectionType(ConnectionType.IDP);
                    } else {
                        tasklet = mainMenuTasklet.createTaskletToLoad(SingleStateTasklet.class, "SpConnectionsTasklet", "SP Connections");
                        state.setConnectionType(ConnectionType.SP);
                    }
                    tasklet.setFinishAvailable(!tasklet.showFinishButtonIfAuditor());
                    tasklet.setCycle(cycle);
                    tasklet.setInitialState(state);
                    tasklet.setMode(Mode.edit);
                    tasklet.populate(null);
                    tasklet.setMode(Mode.create);
                    state.setDraftSuccessful(false);
                    mainMenuTasklet.loadTasklet(tasklet);
                    this.onNext(cycle);
                }
            }
        }
    }

    public void onResumeDraft(IRequestCycle cycle) {
        Tasklet t = this.getCurrentTasklet(cycle);
        if (t instanceof ConnectionTasklet) {
            ConnectionTasklet connectionTasklet = (ConnectionTasklet)t;
            connectionTasklet.resumeDraft(cycle);
        }
    }

    public void onMain(IRequestCycle cycle) {
        this.getCurrentTasklet(cycle).goToTasklet(cycle, "Main");
    }

    public void onLogout(IRequestCycle cycle) {
        Visit visit = this.getPingVisit();
        visit.logout(cycle.getRequestContext().getSession());
        PingOneAdminService pingOneAdminService = MgmtFactory.getPingOneAdminService();
        if (visit.isPingOneSso()) {
            visit.setPingOneSso(false);
            if (pingOneAdminService.isAssociated()) {
                throw new RedirectException(pingOneAdminService.getOIDCProviderConnection().getEndSessionEndpoint());
            }
        }
        if (AdminAuthManager.getInstance().isCert()) {
            throw new PageRedirectException("CertPostLogout");
        }
        if (AdminAuthManager.getInstance().isOidc()) {
            AdminUserManager adminUserManager = MgmtFactory.getAdminUserManager();
            OAuthClientConnection connection = adminUserManager.getConnection();
            String endSessionEndpoint = ((OIDCProviderConnection)connection).getEndSessionEndpoint();
            if (StringUtils.isEmpty((String)endSessionEndpoint)) {
                throw new PageRedirectException("CertPostLogout");
            }
            throw new RedirectException(endSessionEndpoint);
        }
        if (pingOneAdminService.isAssociated() && pingOneAdminService.getSettings().isEnableAdminConsoleSso()) {
            ILink directLogin = this.getEngine().getService("page").getLink(cycle, null, (Object[])new String[]{"directLogin"});
            throw new RedirectException(directLogin.getURL());
        }
        ILink login = this.getEngine().getService("page").getLink(cycle, null, (Object[])new String[]{"login"});
        throw new RedirectException(login.getURL());
    }

    public String getHelpLink() {
        return this.getPingVisit().getCurrentState().getHelpName();
    }

    private Tasklet getCurrentTasklet(IRequestCycle cycle) {
        Tasklet t = this.getPingVisit().getCurrentTasklet();
        t.setCycle(cycle);
        return t;
    }

    public boolean isCurrentTaskletInCreateMode() {
        return this.getPingVisit().getCurrentTasklet().isModeCreate();
    }

    public void formListener(IRequestCycle cycle) {
        super.validateCSRFToken(cycle);
        Tasklet currentTasklet = this.getCurrentTasklet(cycle);
        currentTasklet.formListener(cycle);
        IActionListener submitListener = this.getSubmitListener();
        if (submitListener != null) {
            submitListener.actionTriggered(null, cycle);
            submitListener = null;
        } else {
            currentTasklet.goToState(cycle);
            currentTasklet.executeSubmitListener(cycle);
        }
    }

    public String getNote() {
        String tryKey;
        String msg;
        Tasklet tasklet = this.getPingVisit().getCurrentTasklet();
        TaskletState state = (TaskletState)tasklet.getCurrentState();
        IMessages msgs = this.getMessages();
        String failoverKey = state.getNoteKey();
        String keyContext = state.getKeyContext();
        Object[] arguments = state.getFormatObjects();
        if (keyContext != null && (msg = msgs.getMessage(tryKey = failoverKey + "_" + keyContext, null)) != null) {
            if (arguments == null) {
                return msg;
            }
            return msgs.format(tryKey, arguments);
        }
        if (arguments == null) {
            return msgs.getMessage(failoverKey);
        }
        return msgs.format(failoverKey, arguments);
    }

    public String getTaskletStateId() {
        Tasklet tasklet = this.getPingVisit().getCurrentTasklet();
        TaskletState state = (TaskletState)tasklet.getCurrentState();
        return state.getTaskletStateId();
    }

    public void setTaskletStateId(String nullValue) {
    }

    @Override
    public void pageValidate(PageEvent event) {
        super.pageValidate(event);
        Visit visit = this.getPingVisit();
        if (visit.getMessages() == null) {
            this.messages = this.getMessages();
            visit.setMessages(this.messages);
        }
    }

    public IRender getMetaRender() {
        return new MetaRender();
    }

    public Object getStyleSheets() {
        ArrayList<ContextAsset> styleSheets = new ArrayList<ContextAsset>();
        ServletContext servletContext = this.getRequestCycle().getRequestContext().getRequest().getServletContext();
        ILocation location = this.getLocation();
        String mainCssPath = this.addVersionToPath("/images/v3/css/main.css");
        ContextResourceLocation resourceLocation = new ContextResourceLocation(servletContext, mainCssPath);
        ContextAsset mainCss = new ContextAsset(resourceLocation, location);
        styleSheets.add(mainCss);
        return styleSheets;
    }

    private String addVersionToPath(String url) {
        return url + "?v=" + VersionComponent.getVersion();
    }

    private class MetaRender
    implements IRender {
        private MetaRender() {
        }

        public void render(IMarkupWriter writer, IRequestCycle cycle) {
            writer.beginEmpty("meta");
            writer.attribute("http-equiv", "X-UA-Compatible");
            writer.attribute("content", "IE=Edge");
            writer.println();
        }
    }
}

