/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.common.util.SimpleFileUtil;
import com.pingidentity.page.ValidatePage;
import com.pingidentity.validator.PFValidationDelegate;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IMarkupWriter;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.request.IUploadFile;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.util.license.LicenseManager;

public class LicenseImport
extends ValidatePage {
    private IUploadFile licenseFile;

    public void onFormImport(IRequestCycle cycle) {
        this.importLicense();
    }

    @Override
    public void pageValidate(PageEvent event) {
    }

    public void renderPage(IMarkupWriter writer, IRequestCycle cycle) {
        if (LicenseManager.isValidForGui()) {
            throw new PageRedirectException("login");
        }
        super.renderPage(writer, cycle);
    }

    public void importLicense() {
        ArrayList errors = new ArrayList();
        PFValidationDelegate delegate = (PFValidationDelegate)((Object)this.getBeans().getBean("delegate"));
        if (this.licenseFile == null || StringUtils.isBlank((String)this.licenseFile.getFileName())) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("License_not_selected"), ValidationConstraint.REQUIRED);
            return;
        }
        if (this.licenseFile.getSize() == 0L) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("License_empty"), ValidationConstraint.REQUIRED);
            return;
        }
        String importedBytes = null;
        try {
            importedBytes = SimpleFileUtil.readIUploadFileToString((IUploadFile)this.licenseFile);
        }
        catch (IOException ioe) {
            delegate.setFormComponent(null);
            delegate.record(this.getMessage("License_import_error"), ValidationConstraint.REQUIRED);
            return;
        }
        LicenseManager.testLicenseForImport((String)importedBytes, errors, null);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                delegate.setFormComponent(null);
                delegate.record(error, ValidationConstraint.REQUIRED);
            }
            return;
        }
        LicenseManager.importLicense((String)importedBytes, errors);
        if (!errors.isEmpty()) {
            for (String error : errors) {
                delegate.setFormComponent(null);
                delegate.record(error, ValidationConstraint.REQUIRED);
            }
        }
    }

    public IUploadFile getLicense() {
        return this.licenseFile;
    }

    public void setLicense(IUploadFile license) {
        this.licenseFile = license;
    }
}

