/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.page.InUsePopUp;
import java.util.ArrayList;
import java.util.List;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;

public class LocalIdentityProfileInUsePopUp
extends InUsePopUp {
    private List<InUseItem> authnSelectorsUsingResource = new ArrayList<InUseItem>();

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        super.activateExternalPage(objs, cycle);
        this.loadAuthnTreesUsingResource();
    }

    @Override
    protected void loadIdpAdaptersUsingResource() {
        this.idpAdaptersUsingResource.clear();
        List idpAdapters = InUseDetectionUtil.getInstance().getIdpAdaptersWithLocalIdentityInUse(this.id);
        this.addInUseAdapters(idpAdapters);
    }

    public boolean isShowAuthnSelectorsUsingResource() {
        return !this.authnSelectorsUsingResource.isEmpty();
    }

    public List<InUseItem> getAuthnSelectorsUsingResource() {
        return this.authnSelectorsUsingResource;
    }

    private void loadAuthnTreesUsingResource() {
        this.authnSelectorsUsingResource.clear();
        List trees = InUseDetectionUtil.getInstance().getAuthnSelectionTreesWithLocalIdentityInUse(this.id);
        for (AuthnSelectionTree tree : trees) {
            String name = this.getNameForAuthnSelectionTree(tree);
            if (this.currentItemsContains(name, this.authnSelectorsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.authnSelectorsUsingResource.add(item);
        }
    }

    @Override
    protected void loadFragmentsUsingResource() {
        this.fragmentsUsingResource.clear();
        List fragments = InUseDetectionUtil.getInstance().getFragmentsWithLocalIdentityInUse(this.id);
        for (PolicyFragment fragment : fragments) {
            String name = fragment.getName();
            if (this.currentItemsContains(name, this.fragmentsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.fragmentsUsingResource.add(item);
        }
    }
}

