/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.authnselection.AuthnSelectionTree;
import com.pingidentity.authnselection.fragment.PolicyFragment;
import com.pingidentity.captcha.util.CaptchaProviderUtil;
import com.pingidentity.email.util.NotificationSupportHelper;
import com.pingidentity.fsm.state.impl.IdentityStoreProvisionerManagementState;
import com.pingidentity.fsm.state.impl.IdpAdapterManagementState;
import com.pingidentity.fsm.state.impl.ManageAuthorizationDetailProcessorsState;
import com.pingidentity.fsm.state.impl.ManageCaptchaProvidersState;
import com.pingidentity.fsm.state.impl.ManageSecretManagersState;
import com.pingidentity.fsm.state.impl.NotificationSenderManagementState;
import com.pingidentity.fsm.state.impl.PasswordCredentialValidatorMgmtState;
import com.pingidentity.fsm.state.impl.SpAdapterManagementState;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.InUseItem;
import com.pingidentity.localidentity.LocalIdentityProfile;
import com.pingidentity.page.InUsePopUp;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.a2a.domain.Direct2SpAdapterMapping;
import org.sourceid.a2a.domain.Source2TargetMapping;
import org.sourceid.mgmt.AuditLoggingManager;
import org.sourceid.oauth20.authorizationdetails.domain.AuthorizationDetailType;
import org.sourceid.oauth20.domain.AuthzServerManager;
import org.sourceid.oauth20.domain.Client;
import org.sourceid.oauth20.domain.ClientCredentialAccessTokenMapping;
import org.sourceid.oauth20.domain.ClientManager;
import org.sourceid.oauth20.domain.ClientSetting;
import org.sourceid.oauth20.domain.UserAuthorizationConsentPageSetting;
import org.sourceid.oauth20.domain.UserKeyToAccessTokenMapping;
import org.sourceid.openid.ciba.domain.CibaServerPolicy;
import org.sourceid.openid.connect.domain.OpenIdConnectProviderPolicy;
import org.sourceid.saml20.domain.AuditLoggingSettings;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.BearerAccessTokenMgmtPluginInstance;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.ConnectionBase;
import org.sourceid.saml20.domain.CustomDataSource;
import org.sourceid.saml20.domain.DataSource;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.IdpConnection;
import org.sourceid.saml20.domain.NotificationMode;
import org.sourceid.saml20.domain.NotificationSettings;
import org.sourceid.saml20.domain.OAuthAssertionGrantMapping;
import org.sourceid.saml20.domain.UrlToTargetMapping;
import org.sourceid.saml20.domain.mgmt.ConnectionManager;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.NotificationMgr;
import org.sourceid.saml20.domain.mgmt.impl.PluginManagementSupport;
import org.sourceid.saml20.domain.util.InUseDetectionUtil;
import org.sourceid.saml20.service.AdapterAuthnSourceKey;
import org.sourceid.saml20.service.AuthnSourceKey;
import org.sourceid.saml20.service.TargetSessionId;

public class PluginInUsePopUp
extends InUsePopUp {
    private final List<InUseItem> authnSelectionTreesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> authzServerUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> targetUrlUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> identityPluginsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> openIdConnectPoliciesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> authnSelectorsUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> notificationEventsUsingResource = new ArrayList<InUseItem>();
    private final List<InUseItem> dataSourcesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> secretManagersUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> authorizationDetailTypesUsingResource = new LinkedList<InUseItem>();
    private final List<InUseItem> authorizationDetailProcessorsUsingResource = new LinkedList<InUseItem>();
    private PluginManagementSupport.PluginManagementType resourceType;

    @Override
    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        this.resourceType = (PluginManagementSupport.PluginManagementType)objs[1];
        super.activateExternalPage(objs, cycle);
        this.loadAuthnSelectionTreesUsingResource();
        this.loadAuthnSelectorsUsingResource();
        this.loadAuthzServerUsingResource();
        this.loadTargetUrlUsingResource();
        this.loadIdentityPluginsUsingResource();
        this.loadOpenIdConnectPoliciesUsingResource();
        this.loadClientManagerUsingResource();
        this.loadClientSettingUsingResource();
        this.loadAccessTokenManagersUsingResource();
        this.loadAccessTokenMappingsUsingResource();
        this.loadSAMLGrantMappingsUsingResource();
        this.loadNotificationEventsUsingResource();
        this.loadLocalIdentityProfilesUsingResource();
        this.loadCibaRequestHandlingPoliciesUsingResource();
        this.loadDataSourcesUsingResource();
        this.loadSecretManagersUsingResource();
        this.loadAuthorizationDetailTypesUsingResource();
        this.loadAuthorizationDetailProcessorsUsingResource();
    }

    @Override
    protected void loadCibaRequestHandlingPoliciesUsingResource() {
        this.cibaRequestHandlingPoliciesUsingResource.clear();
        List policies = PluginManagementSupport.PluginManagementType.PCV == this.resourceType ? InUseDetectionUtil.getInstance().getCibaRequestHandlingPoliciesWithPCVInUse(this.id) : InUseDetectionUtil.getInstance().getCibaRequestHandlingPoliciesWithOOBAuthInUse(this.id);
        for (CibaServerPolicy.RequestHandlingPolicy policy : policies) {
            String name = policy.getName();
            if (this.currentItemsContains(name, this.cibaRequestHandlingPoliciesUsingResource)) continue;
            InUseItem item = new InUseItem(name, policy.getId());
            this.cibaRequestHandlingPoliciesUsingResource.add(item);
        }
    }

    private void loadOpenIdConnectPoliciesUsingResource() {
        this.openIdConnectPoliciesUsingResource.clear();
        List policyGroups = InUseDetectionUtil.getInstance().getOpenIdConnectPolicyGroupsWithAccessTokenMappingInUse(this.id);
        for (OpenIdConnectProviderPolicy.PolicyGroup policyGroup : policyGroups) {
            String name = policyGroup.getName();
            if (this.currentItemsContains(name, this.openIdConnectPoliciesUsingResource)) continue;
            InUseItem item = new InUseItem(name, policyGroup.getPolicyId());
            this.openIdConnectPoliciesUsingResource.add(item);
        }
    }

    private String getDefaultAtmInstanceId() {
        BearerAccessTokenMgmtPluginInstance defaultInstance = (BearerAccessTokenMgmtPluginInstance)MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getDefaultInstance();
        return defaultInstance != null ? defaultInstance.getId() : null;
    }

    private void loadClientManagerUsingResource() {
        if (this.resourceType == PluginManagementSupport.PluginManagementType.ACCESS_TOKEN_MANAGEMENT) {
            String defaultAtmId = this.getDefaultAtmInstanceId();
            this.clientManagerUsingResource.clear();
            ClientManager cm = MgmtFactory.getClientManager();
            LinkedList<Client> clients = new LinkedList<Client>();
            try {
                if (StringUtils.isNotBlank((String)defaultAtmId) && defaultAtmId.equals(this.id)) {
                    clients.addAll(cm.getClientsByAtmId(null));
                }
                clients.addAll(cm.getClientsByAtmId(this.id));
                this.clientManagerUsingResource.addAll(this.convertClientToInUseItems(clients));
            }
            catch (ClientManager.ClientManagementException clientManagementException) {
                // empty catch block
            }
        }
    }

    private void loadClientSettingUsingResource() {
        String defaultAtmId;
        ClientSetting clientSetting = MgmtFactory.getClientSettingManager().getClientSetting();
        String clientSettingDefaultId = clientSetting.getDefaultAccessTokenManagerId();
        this.clientSettingUsingResource.clear();
        ConfigurablePluginInstance defaultAtmInstance = MgmtFactory.getBearerAccessTokenMgmtPluginMgr().getDefaultInstance();
        String string = defaultAtmId = defaultAtmInstance == null ? null : defaultAtmInstance.getId();
        if (this.id.equals(clientSettingDefaultId) || StringUtils.isBlank((String)clientSettingDefaultId) && clientSetting.isEnableDynamicClientRegistration() && this.id.equals(defaultAtmId)) {
            this.clientSettingUsingResource.add(new InUseItem("Client Configuration Defaults", "Client Configuration Defaults"));
        }
    }

    private void loadAuthnSelectionTreesUsingResource() {
        this.authnSelectionTreesUsingResource.clear();
        List trees = InUseDetectionUtil.getInstance().getAuthnSelectionTreesWithAdapterInstanceInUse(this.resourceType, this.id);
        for (AuthnSelectionTree tree : trees) {
            String name = this.getNameForAuthnSelectionTree(tree);
            if (this.currentItemsContains(name, this.authnSelectionTreesUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.authnSelectionTreesUsingResource.add(item);
        }
        if (InUseDetectionUtil.getInstance().isDefaultAdapterForAuthnSelection(this.resourceType, this.id)) {
            InUseItem item = new InUseItem("Default Authentication Source");
            this.authnSelectionTreesUsingResource.add(item);
        }
    }

    @Override
    protected void loadFragmentsUsingResource() {
        this.fragmentsUsingResource.clear();
        List fragments = InUseDetectionUtil.getInstance().getFragmentsWithAdapterInstanceInUse(this.resourceType, this.id);
        for (PolicyFragment fragment : fragments) {
            String name = fragment.getName();
            if (this.currentItemsContains(name, this.fragmentsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.fragmentsUsingResource.add(item);
        }
    }

    private void loadAuthnSelectorsUsingResource() {
        if (PluginManagementSupport.PluginManagementType.IDP_ADAPTER == this.resourceType) {
            this.authnSelectorsUsingResource.clear();
            for (AuthnSelectorInstance selector : MgmtFactory.getAuthnSelectorManager().getSelectorsUsingAuthnSource((AuthnSourceKey)new AdapterAuthnSourceKey(this.id))) {
                this.authnSelectorsUsingResource.add(new InUseItem(selector.getName(), selector.getId()));
            }
        }
    }

    @Override
    protected void loadIdpConnectionsUsingResource() {
        this.idpConnectionsUsingResource.clear();
        ArrayList idpConnections = new ArrayList();
        idpConnections.addAll(InUseDetectionUtil.getInstance().getIdpConnectionsWithInstanceInUse(this.resourceType, this.id));
        this.populateConnectionsUsingResource(idpConnections, this.idpConnectionsUsingResource);
        TaskletState state = this.getCurrentState();
        if (state instanceof SpAdapterManagementState) {
            SpAdapterManagementState mgmtState = (SpAdapterManagementState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                if (!instance.isConnectionBasedPlugin()) continue;
                ArrayList idpConnsWithOverride = new ArrayList();
                idpConnsWithOverride.addAll(InUseDetectionUtil.getInstance().getIdpConnectionsWithInstanceInUse(this.resourceType, instance.getId()));
                this.populateConnectionsUsingResource(idpConnsWithOverride, this.idpConnectionsUsingResource);
            }
        }
    }

    @Override
    protected void loadSpConnectionsUsingResource() {
        this.spConnectionsUsingResource.clear();
        ArrayList spConnections = new ArrayList();
        spConnections.addAll(InUseDetectionUtil.getInstance().getSpConnectionsWithInstanceInUse(this.resourceType, this.id));
        this.populateConnectionsUsingResource(spConnections, this.spConnectionsUsingResource);
        TaskletState state = this.getCurrentState();
        if (state instanceof IdpAdapterManagementState) {
            IdpAdapterManagementState mgmtState = (IdpAdapterManagementState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                if (!instance.isConnectionBasedPlugin()) continue;
                ArrayList spConnsWithOverride = new ArrayList();
                spConnsWithOverride.addAll(InUseDetectionUtil.getInstance().getSpConnectionsWithInstanceInUse(this.resourceType, instance.getId()));
                this.populateConnectionsUsingResource(spConnsWithOverride, this.spConnectionsUsingResource);
            }
        }
    }

    private void populateConnectionsUsingResource(List<? extends ConnectionBase> connections, List<InUseItem> connectionsUsingResource) {
        for (ConnectionBase connectionBase : connections) {
            String name = connectionBase.getName();
            if (this.currentItemsContains(name, connectionsUsingResource)) continue;
            String entityId = connectionBase.getEntityId();
            InUseItem item = new InUseItem(name, entityId);
            connectionsUsingResource.add(item);
        }
    }

    protected void loadAccessTokenManagersUsingResource() {
        this.accessTokenManagersUsingResource.clear();
        for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getAccessTokenManagersUsingResource(this.resourceType, this.id)) {
            String instanceId;
            String name = instance.getName();
            if (this.currentItemsContains(name, instanceId = instance.getId(), this.accessTokenManagersUsingResource)) continue;
            InUseItem item = new InUseItem(name, instanceId);
            this.accessTokenManagersUsingResource.add(item);
        }
    }

    protected void loadAccessTokenMappingsUsingResource() {
        this.accessTokenMappingsUsingResource.clear();
        if (PluginManagementSupport.PluginManagementType.ACCESS_TOKEN_MANAGEMENT.equals((Object)this.resourceType)) {
            InUseItem item;
            AuthzServerManager asMgr = MgmtFactory.getAuthzServerManager();
            for (UserKeyToAccessTokenMapping ukMapping : asMgr.getUserKeyToAccessTokenMappings()) {
                if (ukMapping.getTokenManagerId() == null || !ukMapping.getTokenManagerId().equals(this.id)) continue;
                item = new InUseItem(this.buildAccessTokenMappingName(ukMapping.getId()));
                this.accessTokenMappingsUsingResource.add(item);
            }
            for (ClientCredentialAccessTokenMapping ccMapping : asMgr.getClientCredentialsToAccessTokenMappings()) {
                if (ccMapping.getTokenManagerId() == null || !ccMapping.getTokenManagerId().equals(this.id)) continue;
                item = new InUseItem(this.buildAccessTokenMappingName(ccMapping.getId()));
                this.accessTokenMappingsUsingResource.add(item);
            }
        }
    }

    protected void loadSAMLGrantMappingsUsingResource() {
        this.samlGrantMappingsUsingResource.clear();
        ConnectionManager connMgr = MgmtFactory.getConnectionManager();
        for (IdpConnection idpConnection : connMgr.getAllIdpConnections()) {
            if (idpConnection.getOAuthSettings() == null) continue;
            for (OAuthAssertionGrantMapping mapping : idpConnection.getOAuthSettings().getOAuthAssertionGrantMappingList()) {
                if (mapping.getTokenManagerId() == null || !mapping.getTokenManagerId().equals(this.id)) continue;
                InUseItem item = new InUseItem(idpConnection.getName());
                this.samlGrantMappingsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadIdpAdaptersUsingResource() {
        InUseItem item;
        String instanceId;
        String name;
        this.idpAdaptersUsingResource.clear();
        boolean loadCompAdapters = true;
        TaskletState state = this.getCurrentState();
        if (state instanceof PasswordCredentialValidatorMgmtState) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getIdpAdapterInstancesUsingResource(this.resourceType, this.id)) {
                String instanceId2;
                String name2 = instance.getName();
                if (this.currentItemsContains(name2, instanceId2 = instance.getId(), this.idpAdaptersUsingResource)) continue;
                InUseItem item2 = new InUseItem(name2, instanceId2);
                this.idpAdaptersUsingResource.add(item2);
            }
        } else if (state instanceof IdpAdapterManagementState) {
            IdpAdapterManagementState mgmtState = (IdpAdapterManagementState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                if (instance.isConnectionBasedPlugin() || this.currentItemsContains(name = instance.getName(), instanceId = instance.getId(), this.idpAdaptersUsingResource)) continue;
                item = new InUseItem(name, instanceId);
                this.idpAdaptersUsingResource.add(item);
            }
            loadCompAdapters = false;
        } else if (state instanceof NotificationSenderManagementState) {
            MgmtFactory.getIdpAdapterManager().getInstances().stream().filter(adapter -> NotificationSupportHelper.isAdapterUsingPublisher((IdpAuthnAdapterInstance)adapter, (String)this.id)).forEach(adapter -> {
                InUseItem item = new InUseItem(adapter.getName(), adapter.getId());
                this.idpAdaptersUsingResource.add(item);
            });
        } else if (state instanceof ManageCaptchaProvidersState) {
            MgmtFactory.getIdpAdapterManager().getInstances().stream().filter(adapter -> CaptchaProviderUtil.isAdapterUsingCaptchaProvider((IdpAuthnAdapterInstance)adapter, (String)this.id)).forEach(adapter -> {
                InUseItem item = new InUseItem(adapter.getName(), adapter.getId());
                this.idpAdaptersUsingResource.add(item);
            });
        }
        if (loadCompAdapters) {
            List instances = InUseDetectionUtil.getInstance().getCompositeAdaptersUsingInstance(this.id);
            for (ConfigurablePluginInstance instance : instances) {
                name = instance.getName();
                if (this.currentItemsContains(name, instanceId = instance.getId(), this.idpAdaptersUsingResource)) continue;
                item = new InUseItem(name, instanceId);
                this.idpAdaptersUsingResource.add(item);
            }
        }
    }

    TaskletState getCurrentState() {
        return this.getPingVisit().getCurrentState();
    }

    @Override
    protected void loadSpAdaptersUsingResource() {
        this.spAdaptersUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof SpAdapterManagementState) {
            SpAdapterManagementState mgmtState = (SpAdapterManagementState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                String instanceId;
                String name;
                if (instance.isConnectionBasedPlugin() || mgmtState.isInstanceDeleted(instance.getId()) || this.currentItemsContains(name = instance.getName(), instanceId = instance.getId(), this.spAdaptersUsingResource)) continue;
                InUseItem item = new InUseItem(name, instanceId);
                this.spAdaptersUsingResource.add(item);
            }
        }
    }

    private void loadIdentityPluginsUsingResource() {
        this.identityPluginsUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof IdentityStoreProvisionerManagementState) {
            IdentityStoreProvisionerManagementState mgmtState = (IdentityStoreProvisionerManagementState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                String name;
                if (mgmtState.isInstanceDeleted(instance.getId()) || this.currentItemsContains(name = instance.getName(), this.identityPluginsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.identityPluginsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadResourceOwnerCredentialMappingsUsingResource() {
        this.resourceOwnerCredentialMappingsUsingResource.clear();
        if (PluginManagementSupport.PluginManagementType.PCV.equals((Object)this.resourceType)) {
            Map mappings = MgmtFactory.getAuthzServerManager().getUserKeyToAccessTokenMappingsWithPCVInUse(this.id);
            for (Map.Entry m : mappings.entrySet()) {
                String name = this.buildResourceOwnerMappingName((String)m.getKey());
                if (this.currentItemsContains(name, this.resourceOwnerCredentialMappingsUsingResource)) continue;
                InUseItem item = new InUseItem(name);
                this.resourceOwnerCredentialMappingsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadAdapter2AdapterMappingsUsingResource() {
        this.adapter2AdapterMappingsUsingResource.clear();
        List mappings = InUseDetectionUtil.getInstance().getAdapter2AdapterWithAdapterInstanceInUse(this.resourceType, this.id);
        for (Direct2SpAdapterMapping mapping : mappings) {
            String name = this.buildAdapter2AdapterMappingName((Source2TargetMapping)mapping);
            if (this.currentItemsContains(name, this.adapter2AdapterMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.adapter2AdapterMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadApc2SpAdapterMappingsUsingResource() {
        this.apc2SpAdapterMappingsUsingResource.clear();
        List mappings = MgmtFactory.getApc2SpAdapterManager().getMappingsUsingTarget(this.id);
        for (Direct2SpAdapterMapping mapping : mappings) {
            String name = this.buildApc2SpAdapterMappingName((Source2TargetMapping)mapping);
            if (this.currentItemsContains(name, this.apc2SpAdapterMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.apc2SpAdapterMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadPCVsUsingResource() {
        this.pcvsUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof PasswordCredentialValidatorMgmtState) {
            PasswordCredentialValidatorMgmtState mgmtState = (PasswordCredentialValidatorMgmtState)state;
            List instances = InUseDetectionUtil.getInstance().getPCVInstancesUsingResource(this.resourceType, this.id);
            for (ConfigurablePluginInstance instance : instances) {
                String name;
                if (mgmtState.isInstanceDeleted(instance.getId()) || this.currentItemsContains(name = instance.getName(), this.pcvsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.pcvsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadIdpAdapterMappingsUsingResource() {
        this.oauthIdpAdapterToUserKeyMappingsUsingResource.clear();
        Map mappings = MgmtFactory.getAuthzServerManager().getUserKeyToAccessTokenMappingsWithAdapterInUse(this.id);
        for (Map.Entry m : mappings.entrySet()) {
            String name = this.buildIdpAdapterMappingName((String)m.getKey());
            if (this.currentItemsContains(name, this.oauthIdpAdapterToUserKeyMappingsUsingResource)) continue;
            InUseItem item = new InUseItem(name);
            this.oauthIdpAdapterToUserKeyMappingsUsingResource.add(item);
        }
    }

    @Override
    protected void loadTokenProcessorsUsingResource() {
        this.tokenProcessorsUsingResource.clear();
        if (StringUtils.isNotBlank((String)this.id)) {
            for (ConfigurablePluginInstance instance : InUseDetectionUtil.getInstance().getTokenProcessorInstancesUsingResource(this.resourceType, this.id)) {
                String instanceId;
                String name = instance.getName();
                if (this.currentItemsContains(name, instanceId = instance.getId(), this.tokenProcessorsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instanceId);
                this.tokenProcessorsUsingResource.add(item);
            }
        }
    }

    private void loadAuthzServerUsingResource() {
        String atmIdForOAuthGrantManagement;
        this.authzServerUsingResource.clear();
        AuthzServerManager authzServerManager = MgmtFactory.getAuthzServerManager();
        ConfigurablePluginInstance selectedPcv = authzServerManager.getAdminWebServicePcv();
        if (selectedPcv != null && this.id.equals(selectedPcv.getId())) {
            this.addToAuthzServerUsingResource("OAuth Administrative Web Service Settings");
        }
        if (StringUtils.isNotBlank((String)(atmIdForOAuthGrantManagement = authzServerManager.getAtmIdForOAuthGrantManagement())) && this.id.equals(atmIdForOAuthGrantManagement)) {
            this.addToAuthzServerUsingResource("OAuth Enabled Grant Management");
        }
        if (UserAuthorizationConsentPageSetting.ADAPTER.getValue().equals(authzServerManager.getAuthzConsentSetting()) && this.id.equals(authzServerManager.getExternalConsentAdapterId())) {
            this.addToAuthzServerUsingResource("External Consent Page Adapter");
        }
    }

    private void addToAuthzServerUsingResource(String name) {
        if (!this.currentItemsContains(name, this.authzServerUsingResource)) {
            InUseItem item = new InUseItem(name);
            this.authzServerUsingResource.add(item);
        }
    }

    private void loadTargetUrlUsingResource() {
        LocalSettingsManager localSettingsMgr;
        List urlToAdapterMapping;
        this.targetUrlUsingResource.clear();
        Tasklet tasklet = this.getPingVisit().getCurrentTasklet();
        if (tasklet.getCurrentState() instanceof SpAdapterManagementState && (urlToAdapterMapping = (localSettingsMgr = MgmtFactory.getLocalSettingsManager()).getUrlToAdapterMapping().getMappings()) != null) {
            for (UrlToTargetMapping targetUrlItem : urlToAdapterMapping) {
                String name;
                String adapterId = targetUrlItem.getTargetId();
                TargetSessionId.TargetSessionType targetType = targetUrlItem.getTargetType();
                if (targetType != TargetSessionId.TargetSessionType.ADAPTER || !adapterId.equals(this.id) || this.currentItemsContains(name = targetUrlItem.getUrl(), this.targetUrlUsingResource)) continue;
                InUseItem item = new InUseItem(name);
                this.targetUrlUsingResource.add(item);
            }
        }
    }

    @Override
    public boolean isShowOauthManagersUsingResource() {
        return this.isShowIdpAdapterMappingsUsingResource() || this.isShowAuthzServerUsingResource() || this.isShowResourceOwnerCredentialMappingsUsingResource() || this.isShowClientManagerUsingResource() || this.isShowAccessTokenManagersUsingResource() || this.isShowAccessTokenMappingsUsingResource() || this.isShowSAMLGrantMappingsUsingResource() || this.isShowOpenIdConnectPoliciesUsingResource() || this.isShowCibaRequestHandlingPoliciesUsingResource();
    }

    public boolean isShowSAMLGrantMappingsUsingResource() {
        return !this.samlGrantMappingsUsingResource.isEmpty();
    }

    public boolean isShowOpenIdConnectPoliciesUsingResource() {
        return !this.openIdConnectPoliciesUsingResource.isEmpty();
    }

    public boolean isShowAuthzServerUsingResource() {
        return !this.authzServerUsingResource.isEmpty();
    }

    public boolean isShowAccessTokenManagersUsingResource() {
        return !this.accessTokenManagersUsingResource.isEmpty();
    }

    public boolean isShowAccessTokenMappingsUsingResource() {
        return !this.accessTokenMappingsUsingResource.isEmpty();
    }

    public boolean isShowAuthnSelectionTreesUsingResource() {
        return !this.authnSelectionTreesUsingResource.isEmpty();
    }

    public boolean isShowAuthnSelectorsUsingResource() {
        return !this.authnSelectorsUsingResource.isEmpty();
    }

    public boolean isShowTargetUrlUsingResource() {
        return !this.targetUrlUsingResource.isEmpty();
    }

    public boolean isShowIdentityPluginsUsingResource() {
        return !this.identityPluginsUsingResource.isEmpty();
    }

    public List<InUseItem> getAuthnSelectionTreesUsingResource() {
        return this.authnSelectionTreesUsingResource;
    }

    public List<InUseItem> getAuthnSelectorsUsingResource() {
        return this.authnSelectorsUsingResource;
    }

    public List<InUseItem> getAuthzServerUsingResource() {
        return this.authzServerUsingResource;
    }

    public List<InUseItem> getTargetUrlUsingResource() {
        return this.targetUrlUsingResource;
    }

    public List<InUseItem> getIdentityPluginsUsingResource() {
        return this.identityPluginsUsingResource;
    }

    public List<InUseItem> getOpenIdConnectPoliciesUsingResource() {
        return this.openIdConnectPoliciesUsingResource;
    }

    public boolean isShowNotificationEventsUsingResource() {
        return !this.notificationEventsUsingResource.isEmpty();
    }

    public List<InUseItem> getNotificationEventsUsingResource() {
        return this.notificationEventsUsingResource;
    }

    void loadNotificationEventsUsingResource() {
        AuditLoggingManager manager;
        AuditLoggingSettings auditLoggingSettings;
        InUseItem item;
        this.notificationEventsUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (!(state instanceof NotificationSenderManagementState)) {
            return;
        }
        NotificationMgr notificationMgr = MgmtFactory.getNotificationMgr();
        NotificationSettings settings = notificationMgr.getNotificationSettings();
        if (settings.isEnableAccountChangesNotification() && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)settings.getNotificationPublisherAccountChanges(), (String)this.id)) {
            item = new InUseItem("Administrative Account Changes");
            this.notificationEventsUsingResource.add(item);
        }
        if (settings.isEnableCertificateExpirationNotification() && settings.getCertExpirationNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER) && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)settings.getNotificationPublisherCertificates(), (String)this.id)) {
            item = new InUseItem("Certificates");
            this.notificationEventsUsingResource.add(item);
        }
        if (settings.isEnableEmailNotification() && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)settings.getNotificationPublisherLicensing(), (String)this.id)) {
            item = new InUseItem("Licensing");
            this.notificationEventsUsingResource.add(item);
        }
        if (settings.isEnableMetadataEventNotification() && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)settings.getNotificationPublisherMetadata(), (String)this.id)) {
            item = new InUseItem("SAML Metadata");
            this.notificationEventsUsingResource.add(item);
        }
        if (settings.isEnableThreadPoolExhaustionNotification() && settings.getThreadPoolExhaustionNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER) && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)settings.getNotificationPublisherThreadPoolExhaustion(), (String)this.id)) {
            item = new InUseItem("Thread Pool Exhaustion");
            this.notificationEventsUsingResource.add(item);
        }
        if (settings.isEnableBulkheadAlertNotification() && settings.getBulkheadAlertsNotificationMode().equals((Object)NotificationMode.NOTIFICATION_PUBLISHER) && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)settings.getNotificationPublisherBulkheadAlerts(), (String)this.id)) {
            item = new InUseItem("Bulkhead Alerts");
            this.notificationEventsUsingResource.add(item);
        }
        if ((auditLoggingSettings = (manager = MgmtFactory.getAuditLoggingManager()).getAuditLoggingSettings()).isTrackAuditLogFailures() && NotificationSupportHelper.isPluginUsingNotificationPublisher((String)auditLoggingSettings.getNotificationPublisherId(), (String)this.id)) {
            InUseItem item2 = new InUseItem("Audit Log Failure Alerts");
            this.notificationEventsUsingResource.add(item2);
        }
    }

    public boolean isShowDataSourcesUsingResource() {
        return !this.dataSourcesUsingResource.isEmpty();
    }

    public List<InUseItem> getDataSourcesUsingResource() {
        return this.dataSourcesUsingResource;
    }

    void loadDataSourcesUsingResource() {
        this.dataSourcesUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof ManageSecretManagersState) {
            ManageSecretManagersState mgmtState = (ManageSecretManagersState)state;
            for (DataSource instance : InUseDetectionUtil.getInstance().getDataSourceInstancesUsingResource(this.resourceType, this.id)) {
                String name;
                if (mgmtState.isInstanceDeleted(instance.getId()) || this.currentItemsContains(name = instance instanceof CustomDataSource ? instance.getDescription() : instance.getDsName(), this.dataSourcesUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.dataSourcesUsingResource.add(item);
            }
        }
    }

    public boolean isShowSecretManagersUsingResource() {
        return !this.secretManagersUsingResource.isEmpty();
    }

    public List<InUseItem> getSecretManagersUsingResource() {
        return this.secretManagersUsingResource;
    }

    void loadSecretManagersUsingResource() {
        this.secretManagersUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof ManageSecretManagersState) {
            ManageSecretManagersState mgmtState = (ManageSecretManagersState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                String name;
                if (mgmtState.isInstanceDeleted(instance.getId()) || this.currentItemsContains(name = instance.getName(), this.secretManagersUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.secretManagersUsingResource.add(item);
            }
        }
    }

    public boolean isShowAuthorizationDetailTypesUsingResource() {
        return !this.authorizationDetailTypesUsingResource.isEmpty();
    }

    public List<InUseItem> getAuthorizationDetailTypesUsingResource() {
        return this.authorizationDetailTypesUsingResource;
    }

    void loadAuthorizationDetailTypesUsingResource() {
        this.authorizationDetailTypesUsingResource.clear();
        for (AuthorizationDetailType type : InUseDetectionUtil.getInstance().getAuthorizationDetailTypesUsingResource(this.resourceType, this.id)) {
            String name = type.getType();
            if (this.currentItemsContains(name, this.authorizationDetailTypesUsingResource)) continue;
            InUseItem item = new InUseItem(name, type.getId());
            this.authorizationDetailTypesUsingResource.add(item);
        }
    }

    public boolean isShowAuthorizationDetailProcessorsUsingResource() {
        return !this.authorizationDetailProcessorsUsingResource.isEmpty();
    }

    public List<InUseItem> getAuthorizationDetailProcessorsUsingResource() {
        return this.authorizationDetailProcessorsUsingResource;
    }

    void loadAuthorizationDetailProcessorsUsingResource() {
        this.authorizationDetailProcessorsUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof ManageAuthorizationDetailProcessorsState) {
            ManageAuthorizationDetailProcessorsState mgmtState = (ManageAuthorizationDetailProcessorsState)state;
            for (ConfigurablePluginInstance instance : mgmtState.getInstancesInUseInternally(this.id)) {
                String name;
                if (mgmtState.isInstanceDeleted(instance.getId()) || this.currentItemsContains(name = instance.getName(), this.authorizationDetailProcessorsUsingResource)) continue;
                InUseItem item = new InUseItem(name, instance.getId());
                this.authorizationDetailProcessorsUsingResource.add(item);
            }
        }
    }

    @Override
    protected void loadLocalIdentityProfilesUsingResource() {
        this.lipsUsingResource.clear();
        TaskletState state = this.getCurrentState();
        if (state instanceof NotificationSenderManagementState) {
            MgmtFactory.getLocalIdentityProfileManager().getProfiles().parallelStream().filter(lip -> NotificationSupportHelper.isLipUsingPublisher((LocalIdentityProfile)lip, (String)this.id)).forEach(lip -> {
                InUseItem item = new InUseItem(lip.getName(), lip.getId());
                this.lipsUsingResource.add(item);
            });
        }
        if (state instanceof ManageCaptchaProvidersState) {
            MgmtFactory.getLocalIdentityProfileManager().getProfiles().parallelStream().filter(lip -> CaptchaProviderUtil.isLipUsingCaptchaProvider((LocalIdentityProfile)lip, (String)this.id)).forEach(lip -> {
                InUseItem item = new InUseItem(lip.getName(), lip.getId());
                this.lipsUsingResource.add(item);
            });
        }
    }
}

