/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.fsm.tasklet.data.ServiceEndpointItem;
import com.pingidentity.page.ValidatePage;
import com.pingidentity.util.documentation.DocumentationHelper;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.tapestry.IExternalPage;
import org.apache.tapestry.IRequestCycle;
import org.sourceid.saml20.domain.Endpoint;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.LocalSettingsManager;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.metadata.MetaDataFactory;
import org.sourceid.saml20.metadata.local.MetadataLocal;
import org.sourceid.websso.Protocol;
import org.sourceid.websso.domain.trans.DomainTranslator;

public class SamlEndpointsPopUp
extends ValidatePage
implements IExternalPage {
    private LocalSettings localSettings;
    private String parameter0;

    public void activateExternalPage(Object[] objs, IRequestCycle cycle) {
        this.parameter0 = (String)objs[0];
        LocalSettingsManager localSettingsMgr = MgmtFactory.getLocalSettingsManager();
        this.localSettings = localSettingsMgr.getLocalSettings();
    }

    public LocalSettings getLocalSettings() {
        return this.localSettings;
    }

    public List<ServiceEndpointItem> getIdpSingleLogoutServices() {
        if (this.localSettings.getIdpSingleLogoutServices() != null) {
            return this.convertList(this.localSettings.getIdpSingleLogoutServices().getEndpoints());
        }
        return new ArrayList<ServiceEndpointItem>();
    }

    public List<ServiceEndpointItem> getSingleSignOnServices() {
        if (this.localSettings.getSingleSignOnServices() != null) {
            return this.convertList(this.localSettings.getSingleSignOnServices().getEndpoints());
        }
        return new ArrayList<ServiceEndpointItem>();
    }

    public Map<Integer, Endpoint> getIdpArtifactResolutionServicesMap() {
        return this.localSettings.getIdpArtifactResolutionServices().getEndpointsMap();
    }

    public String getHttpHeartbeatEndpoint() {
        return "/pf/heartbeat.ping";
    }

    public String getMetadataResponseEndpoint() {
        return "/";
    }

    public String getSaml1xIsxEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getSaml1xIsxEndpoint();
    }

    public String getSaml1xSoapEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getSaml1xSoapEndpoint();
    }

    public String getIdpWsFedEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getIdpWsFedEndpoint();
    }

    public String getIdpWsTrustStsEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getIdpWsTrustStsEndpoint();
    }

    public String getSpWsTrustStsEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getSpWsTrustStsEndpoint();
    }

    public String getSpThirdPartyOidcEndpoint() {
        return "/sp/init_login.ping";
    }

    public String getJwksEndpoint() {
        return "/pf/JWKS";
    }

    public String getIdpInitiateSsoPath() {
        return this.localSettings.getIdpInitiateSsoPath();
    }

    public String getIdpInitiateSloPath() {
        return this.localSettings.getIdpInitiateSloPath();
    }

    public List<ServiceEndpointItem> getSpSingleLogoutServices() {
        if (this.localSettings.getSpSingleLogoutServices() != null) {
            return this.convertList(this.localSettings.getSpSingleLogoutServices().getEndpoints());
        }
        return new ArrayList<ServiceEndpointItem>();
    }

    public Map<Integer, Endpoint> getSpArtifactResolutionServicesMap() {
        return this.localSettings.getSpArtifactResolutionServices().getEndpointsMap();
    }

    public List<ServiceEndpointItem> getAssertionConsumerServicesList() {
        if (this.localSettings.getAssertionConsumerServices() != null) {
            return this.convertMap(this.localSettings.getAssertionConsumerServices().getEndpointsMap());
        }
        return new ArrayList<ServiceEndpointItem>();
    }

    public String getSaml1xAcsEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getSaml1xAcsEndpoint();
    }

    public String getSpWsFedEndpoint() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getSpWsFedEndpoint();
    }

    public String getSpInitiateSsoPath() {
        return this.localSettings.getSpInitiateSsoPath();
    }

    public String getSpInitiateSloPath() {
        return this.localSettings.getSpInitiateSloPath();
    }

    public String getSpDefederatePath() {
        return this.localSettings.getSpDefederatePath();
    }

    public String getInitiateCdcSSOPath() {
        MetadataLocal localMetaData = MetaDataFactory.getLocalMetaData();
        return localMetaData.getSpLocalPathMappings().getInitiateCdcSSOPath();
    }

    public String getAttributeService() {
        return this.localSettings.getAttributeService();
    }

    public String getIdpWriteCdcPath() {
        return this.localSettings.getIdpWriteCdcPath();
    }

    public String getSpStartAttrQueryPath() {
        return this.localSettings.getSpStartAttrQueryPath();
    }

    private List<ServiceEndpointItem> convertMap(Map<Integer, Endpoint> map) {
        ArrayList<ServiceEndpointItem> list = new ArrayList<ServiceEndpointItem>();
        DomainTranslator translator = DomainTranslator.getTranslator((Protocol)Protocol.SAML20);
        for (Map.Entry<Integer, Endpoint> pairs : map.entrySet()) {
            Endpoint endpoint = pairs.getValue();
            String binding = translator.toBindingGuiName(endpoint.getBinding());
            ServiceEndpointItem sei = new ServiceEndpointItem(endpoint.getLocation(), binding);
            Integer index = pairs.getKey();
            sei.setIndex(index.toString());
            list.add(sei);
        }
        return list;
    }

    private List<ServiceEndpointItem> convertList(List<Endpoint> endpointList) {
        DomainTranslator translator = DomainTranslator.getTranslator((Protocol)Protocol.SAML20);
        ArrayList<ServiceEndpointItem> list = new ArrayList<ServiceEndpointItem>();
        for (Endpoint endpoint : endpointList) {
            String binding = translator.toBindingGuiName(endpoint.getBinding());
            list.add(new ServiceEndpointItem(endpoint.getLocation(), binding));
        }
        return list;
    }

    public boolean isShowApplicationEndpoints() {
        return this.isShowIdpApplicationEndpoint() || this.isShowSpApplicationEndpoint();
    }

    public boolean isShowIdpProtocolEndpoint() {
        return this.parameter0.equals("IdP Protocol Endpoint");
    }

    public boolean isShowIdpApplicationEndpoint() {
        return this.parameter0.equals("IdP Application Endpoint");
    }

    public boolean isShowSpApplicationEndpoint() {
        return this.parameter0.equals("SP Application Endpoint");
    }

    public boolean isShowSpProtocolEndpoint() {
        return this.parameter0.equals("SP Protocol Endpoint");
    }

    public String getOnlineLinkIdpProtocolEndpoints() {
        return DocumentationHelper.getDocumentationJavascript((String)"help_idp_protocol_endpoints");
    }

    public String getOnlineLinkIdpEndpoints() {
        return DocumentationHelper.getDocumentationJavascript((String)"idp_endpoints");
    }

    public String getOnlineLinkSpProtocolEndpoints() {
        return DocumentationHelper.getDocumentationJavascript((String)"help_sp_protocol_endpoints");
    }

    public String getOnlineLinkSpEndpoints() {
        return DocumentationHelper.getDocumentationJavascript((String)"sp_endpoints");
    }
}

