/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.page;

import com.pingidentity.fsm.Visit;
import com.pingidentity.fsm.tasklet.Tasklet;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.impl.MainMenuTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.InitialSetupTasklet;
import com.pingidentity.fsm.tasklet.impl.setup.LicenseAgreementTasklet;
import com.pingidentity.page.Login;
import com.pingidentity.page.PingAdminPage;
import com.pingidentity.session.SessionValidator;
import com.pingidentity.util.InitialSetupConfigStore;
import com.pingidentity.util.UIPaths;
import java.util.List;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IPage;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.RedirectException;
import org.apache.tapestry.event.PageEvent;
import org.apache.tapestry.event.PageValidateListener;
import org.sourceid.common.IDGenerator;
import org.sourceid.config.ConfigStore;
import org.sourceid.config.ConfigStoreFarm;
import org.sourceid.saml20.domain.log.AdminAuditLogger;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.impl.Mediator;

public class ValidatePage
extends PingAdminPage
implements PageValidateListener {
    private static final Log log = LogFactory.getLog(ValidatePage.class);
    private static final String SEC_FETCH_SITE_ALLOWED_VALUES = "sec-fetch-site-allowed-values";
    private static final List<String> SEC_FETCH_SITE_ALLOWED_VALUES_DEFAULT = List.of("same-origin");
    private final InitialSetupConfigStore configStore = new InitialSetupConfigStore();
    private final ConfigStore validatePageConfigStore = ConfigStoreFarm.getConfig((String)"com.pingidentity.page.ValidatePage");
    private static final String CSRF_COOKIE = "PFCSRF";
    private static final String CSRF_PARAM = "cSRFToken";
    private static final String SAME_SITE_STRICT_COOKIE_COMMENT = "__SAME_SITE_STRICT__";

    public void pageValidate(PageEvent event) {
        String pageValue;
        Mediator mediator = MgmtFactory.getMediator();
        if (!mediator.isConsole()) {
            IPage messagePage = this.getRequestCycle().getPage("nonAdminConsole");
            throw new PageRedirectException(messagePage);
        }
        String secFetchSiteHeaderValue = this.getRequestCycle().getRequestContext().getRequest().getHeader("sec-fetch-site");
        List secFetchSiteAllowedValues = this.validatePageConfigStore.getListValue(SEC_FETCH_SITE_ALLOWED_VALUES, SEC_FETCH_SITE_ALLOWED_VALUES_DEFAULT);
        if (StringUtils.isNotBlank((CharSequence)secFetchSiteHeaderValue) && !secFetchSiteAllowedValues.isEmpty() && !secFetchSiteAllowedValues.contains(secFetchSiteHeaderValue)) {
            log.error((Object)("Unexpected request (sec-fetch-site=" + secFetchSiteHeaderValue + ")"));
            Visit visit = this.getPingVisit();
            if (visit != null) {
                visit.logout(this.getRequestCycle());
            }
            Login login = (Login)this.getRequestCycle().getPage("login");
            throw new PageRedirectException((IPage)login);
        }
        this.setupCSRFToken();
        if (this.isInitialSetupDone()) {
            HttpServletRequest request = this.getRequestCycle().getRequestContext().getRequest();
            throw new RedirectException(UIPaths.getAdminReactHomePage(request));
        }
        Visit visit = this.getPingVisit();
        if (!new SessionValidator().checkSessionValidity(this.getRequestCycle(), visit)) {
            Login login = (Login)this.getRequestCycle().getPage("login");
            throw new PageRedirectException((IPage)login);
        }
        AdminAuditLogger.setIpAddress((String)this.getRequestCycle().getRequestContext().getRequest().getRemoteAddr());
        AdminAuditLogger.setUser((String)visit.getCurrentUser().getUserName());
        AdminAuditLogger.setRoles((String)new String(visit.getCurrentUser().describeUser(true)));
        String stateValue = "null";
        TaskletState currentState = visit.getCurrentState();
        if (currentState != null) {
            stateValue = currentState.getTaskletStateId();
        }
        if ((pageValue = this.getRequestCycle().getRequestContext().getParameter("taskletStateId")) != null && !pageValue.equals("null") && !stateValue.equals(pageValue) && !pageValue.equals(visit.getLastPageViewed()) && visit.isStepsEmpty()) {
            log.debug((Object)("TaskletStateId=" + stateValue + ", Request TaskletStateId=" + pageValue));
            visit.setLastPageViewed(pageValue);
            IPage home = this.getRequestCycle().getPage("Home");
            throw new PageRedirectException(home);
        }
    }

    protected boolean isInitialSetupDone() {
        boolean hasAcceptedLicenseAgreement = this.hasAcceptedLicenseAgreement();
        boolean isSetupWizardDone = this.isSetupWizardDone();
        return !hasAcceptedLicenseAgreement || !isSetupWizardDone;
    }

    public String getCSRFToken() {
        return this.getRequestCycle().getRequestContext().getCookieValue(CSRF_COOKIE);
    }

    public void setCSRFToken(String none) {
    }

    protected void setupCSRFToken() {
        this.setupCSRFToken(false);
    }

    protected void setupCSRFToken(boolean forceUpdate) {
        if (forceUpdate || this.getRequestCycle().getRequestContext().getCookie(CSRF_COOKIE) == null) {
            String cSRFToken = IDGenerator.rndAlphaNumeric((int)20);
            Cookie csrfCookie = new Cookie(CSRF_COOKIE, cSRFToken);
            csrfCookie.setSecure(true);
            csrfCookie.setHttpOnly(true);
            csrfCookie.setComment(SAME_SITE_STRICT_COOKIE_COMMENT);
            this.getRequestCycle().getRequestContext().addCookie(csrfCookie);
        }
    }

    protected void validateCSRFToken(IRequestCycle cycle) {
        String cSRFTokenOnForm = cycle.getRequestContext().getParameter(CSRF_PARAM);
        String cSRFToken = this.getCSRFToken();
        if (cSRFToken == null || !cSRFToken.equals(cSRFTokenOnForm)) {
            this.setupCSRFToken(true);
            log.error((Object)("Unexpected request (cSRFTokenOnForm=" + cSRFTokenOnForm + ", cSRFToken=" + cSRFToken + ")"));
            Visit visit = this.getPingVisit();
            if (visit != null) {
                visit.logout(cycle);
            }
            Login login = (Login)this.getRequestCycle().getPage("login");
            throw new PageRedirectException((IPage)login);
        }
    }

    public boolean hasAcceptedLicenseAgreement() {
        return this.configStore.hasAcceptedLicenseAgreement();
    }

    public boolean isSetupWizardDone() {
        return this.configStore.isInitialSetupDone();
    }

    protected boolean alreadyAddedSetupTasklet() {
        return this.alreadyAddedTasklet(InitialSetupTasklet.class);
    }

    protected boolean alreadyAddedLicenseTasklet() {
        return this.alreadyAddedTasklet(LicenseAgreementTasklet.class);
    }

    protected void addMainMenuStep(Visit visit) {
        if (!this.alreadyAddedTasklet(MainMenuTasklet.class)) {
            MainMenuTasklet tasklet = new MainMenuTasklet(visit);
            visit.addStep(tasklet);
            if (visit.getInitialTasklet() == null) {
                visit.setInitialTasklet(tasklet);
            }
        }
    }

    private boolean alreadyAddedTasklet(Class<? extends Tasklet> taskletType) {
        Visit visit = this.getPingVisit();
        if (visit != null) {
            for (Tasklet tasklet : visit.getSteps()) {
                if (!taskletType.isInstance(tasklet)) continue;
                return true;
            }
            for (Tasklet tasklet : visit.getTaskletStack()) {
                if (!taskletType.isInstance(tasklet)) continue;
                return true;
            }
        }
        return false;
    }
}

