/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.plugins.PluginBuilder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.IdpAuthnAdapterInstance;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class HtmlFormAdapterBuilder
extends PluginBuilder<IdpAuthnAdapterInstance> {
    private static final String SESSION_STATE_FIELD = "Session State";
    private static final String SESSION_STATE_NONE = "None";
    private static final Map<String, String> sampleHtmlMapping = new HashMap<String, String>();

    public HtmlFormAdapterBuilder(String pcvID, Set<String> extendedAttrs, boolean enableSessionState, boolean isSampleConfig) {
        HashSet<String> attributes = new HashSet<String>(extendedAttrs);
        this.filterCoreAttributes(attributes);
        Table table = this.addTable("Credential Validators");
        this.addFieldToTable(table, "Password Credential Validator Instance", pcvID);
        this.setUniqueKeyField("username");
        ((IdpAuthnAdapterInstance)this.plugin).setExtendedContractAttributes(attributes);
        if (!enableSessionState) {
            this.addField(SESSION_STATE_FIELD, SESSION_STATE_NONE);
        }
        if (isSampleConfig) {
            this.addSampleMapping();
        }
    }

    @Override
    protected String getPluginDescriptorClass() {
        return "com.pingidentity.adapters.htmlform.idp.HtmlFormIdpAuthnAdapter";
    }

    @Override
    protected PluginManager<?, IdpAuthnAdapterInstance> getPluginManager() {
        return MgmtFactory.getIdpAdapterManager();
    }

    @Override
    protected String getDefaultName() {
        return "HTML Form Adapter";
    }

    private void setUniqueKeyField(String key) {
        ((IdpAuthnAdapterInstance)this.plugin).setOwnUniqueKeyFields(Collections.singletonList(key));
    }

    private void addSampleMapping() {
        AttributeMapping mapping = new AttributeMapping();
        for (Map.Entry<String, String> defaultMappingEntry : sampleHtmlMapping.entrySet()) {
            mapping.addAttributeMapping(defaultMappingEntry.getKey(), SourceType.TEXT, defaultMappingEntry.getValue());
        }
        ((IdpAuthnAdapterInstance)this.plugin).setAttributeMapping(mapping);
    }

    static {
        sampleHtmlMapping.put("mail", "test@example.com");
        sampleHtmlMapping.put("givenName", "fname");
        sampleHtmlMapping.put("sn", "lname");
        sampleHtmlMapping.put("isMemberOf", "testGroup");
    }
}

