/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.common.util.Obfuscator;
import com.pingidentity.pingid.PingIdInitialSetupAdminService;
import com.pingidentity.plugins.PluginBuilder;
import com.pingidentity.plugins.pcvs.pingid.PingIdPCV;
import com.pingidentity.plugins.pcvs.pingid.vpnagent.VPNAgentConfigEnum;
import java.util.Arrays;
import org.apache.commons.lang.StringUtils;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.PasswordCredentialValidatorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PasswordCredentialValidatorManager;

public class PingIdRadiusPCVBuilder
extends PluginBuilder<PasswordCredentialValidatorInstance> {
    public static final String PLUGIN_NAME = "PingID PCV";
    private static final PingIdInitialSetupAdminService pingIdAdminConfig = MgmtFactory.getPingIdInitialSetupAdminService();

    public PingIdRadiusPCVBuilder(String clientIp, String clientSecret, String portNumber, String pingIdProperties, String usernameAttribute, String datastoreName, String searchBase, String searchFilter, boolean isValidateLDAP, String ldapPcvId, boolean isDsSaved) {
        this.addRadiusRow(clientIp, clientSecret);
        this.addField(VPNAgentConfigEnum.PINGID_PROPERTIES_FILE.getName(), Obfuscator.obfuscate((String)pingIdProperties));
        this.addAdvancedField(VPNAgentConfigEnum.PINGID_USERNAME_ATTRIBUTE.getName(), usernameAttribute);
        this.addField(VPNAgentConfigEnum.POLICY_OUTAGE_CONFIG.getName(), VPNAgentConfigEnum.POLICY_TECH_ERROR_BYPASS.getName());
        this.addField(VPNAgentConfigEnum.RADIUS_SERVER_PORT.getName(), portNumber);
        this.addField(VPNAgentConfigEnum.FIELD_LDAP_DATASOURCE.getName(), "");
        this.addField(VPNAgentConfigEnum.SEARCH_BASE.getName(), "");
        this.addField(VPNAgentConfigEnum.DISTINGUISHED_NAME_PATTERN.getName(), "");
        this.addField(VPNAgentConfigEnum.POLICY_USER_NOT_REGISTERED.getName(), VPNAgentConfigEnum.POLICY_USER_NOT_REGISTERED_REGISTER.getName());
        this.addTable("Delegate PCV's");
        if (isDsSaved) {
            if (StringUtils.isNotEmpty((String)datastoreName)) {
                this.addField(VPNAgentConfigEnum.FIELD_LDAP_DATASOURCE.getName(), datastoreName.trim());
            }
            if (StringUtils.isNotEmpty((String)searchBase)) {
                this.addField(VPNAgentConfigEnum.SEARCH_BASE.getName(), searchBase);
                this.addField(VPNAgentConfigEnum.SCOPE_OF_SEARCH.getName(), VPNAgentConfigEnum.LDAP_SCOPE_SUBTREE.getName());
            }
            if (StringUtils.isNotEmpty((String)searchFilter)) {
                this.addField(VPNAgentConfigEnum.SEARCH_FILTER.getName(), searchFilter);
            }
            if (isValidateLDAP) {
                this.addRow("Delegate PCV's", VPNAgentConfigEnum.DELEGATE_PCV.getName(), ldapPcvId);
                ((PasswordCredentialValidatorInstance)this.plugin).getConfiguration().setId(((PasswordCredentialValidatorInstance)this.plugin).getId());
            }
        }
    }

    private void addRow(String tableName, String fieldName, String fieldValue) {
        Table table = this.addTable(tableName);
        Field ipField = new Field(fieldName, fieldValue);
        this.addRowToTable(table, Arrays.asList(ipField));
    }

    private void addRadiusRow(String clientIp, String clientSecret) {
        Table radiusTables = this.addTable(VPNAgentConfigEnum.TABLE_RADIUS_CLIENTS.getName());
        Field ipField = new Field(VPNAgentConfigEnum.CLIENT_IP.getName(), clientIp);
        Field secretField = new Field(VPNAgentConfigEnum.CLIENT_SHARED_SECRET.getName(), clientSecret);
        this.addRowToTable(radiusTables, Arrays.asList(ipField, secretField));
    }

    @Override
    public void save() {
        super.save();
        if (this.getPluginManager().getValidator(((PasswordCredentialValidatorInstance)this.plugin).getId()) != null) {
            pingIdAdminConfig.savePcvId(((PasswordCredentialValidatorInstance)this.plugin).getId());
        }
    }

    @Override
    protected String getPluginDescriptorClass() {
        return PingIdPCV.class.getCanonicalName();
    }

    protected PasswordCredentialValidatorManager getPluginManager() {
        return MgmtFactory.getCredentialValidatorManager();
    }

    @Override
    protected String getDefaultName() {
        return PLUGIN_NAME;
    }
}

