/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.admin.api.model.fieldpaths.PluginInstancePaths;
import com.pingidentity.admin.api.validator.PluginConfigValidator;
import com.pingidentity.pf.common.api.validator.error.ValidationError;
import com.pingidentity.sdk.GuiConfigDescriptor;
import com.pingidentity.sdk.GuiConfigDescriptorBuilder;
import com.pingidentity.sdk.PluginDescriptor;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.RandomStringUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.adapter.conf.Configuration;
import org.sourceid.saml20.adapter.conf.Field;
import org.sourceid.saml20.adapter.conf.FieldList;
import org.sourceid.saml20.adapter.conf.Row;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.ConfigurablePluginInstance;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public abstract class PluginBuilder<T extends ConfigurablePluginInstance> {
    private final Log log = LogFactory.getLog(this.getClass());
    protected T plugin = this.getPluginManager().newInstance();

    protected abstract String getPluginDescriptorClass();

    protected abstract PluginManager<?, T> getPluginManager();

    protected abstract String getDefaultName();

    public PluginBuilder() {
        this.plugin.setConfiguration(new Configuration());
        this.fillInDefaults();
        this.plugin.setId(RandomStringUtils.randomAlphanumeric((int)10));
        this.plugin.setName(this.getDefaultName());
        this.plugin.setDescriptor(this.getPluginDescriptor());
    }

    protected void fillInDefaults() {
        GuiConfigDescriptorBuilder guiConfigDescriptorBuilder = this.getPluginDescriptor().getGuiConfigDescriptorBuilder();
        if (guiConfigDescriptorBuilder != null) {
            GuiConfigDescriptor guiDescriptor = guiConfigDescriptorBuilder.buildNewGuiDescriptor();
            guiDescriptor.getFields().stream().filter(descriptor -> !StringUtils.isEmpty((String)descriptor.getDefaultValue())).forEach(descriptor -> this.addField(descriptor.getName(), descriptor.getDefaultValue()));
            guiDescriptor.getAdvancedFields().stream().filter(descriptor -> !StringUtils.isEmpty((String)descriptor.getDefaultValue())).forEach(descriptor -> this.addAdvancedField(descriptor.getName(), descriptor.getDefaultValue()));
        }
    }

    public void save() {
        if (this.validate()) {
            this.log.debug((Object)("Saving plugin " + this.plugin.getName()));
            Configuration config = this.plugin.getConfiguration();
            List basic = config.getFields();
            List adv = config.getAdvancedFields().getFields();
            basic.addAll(adv);
            this.plugin.setConfiguration(new Configuration(basic, config.getTables(), adv));
            this.getPluginManager().saveInstance(this.plugin);
        }
    }

    public boolean validate() {
        PluginConfigValidator validator = new PluginConfigValidator(this.plugin.getConfiguration(), this.plugin.getDescriptor(), PluginInstancePaths.getConfiguration(), this.getFieldIndices(), this.getTableIndices());
        if (!validator.validate()) {
            this.log.error((Object)"Creating plugin failed.");
            for (ValidationError error : validator.getErrors()) {
                this.log.debug((Object)error.getMessage());
            }
        }
        return validator.validate();
    }

    public Map<String, Integer> getFieldIndices() {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        int i = 0;
        for (Field field : this.plugin.getConfiguration().getFields()) {
            indices.put(field.getName(), i);
            ++i;
        }
        return indices;
    }

    public Map<String, Integer> getTableIndices() {
        HashMap<String, Integer> indices = new HashMap<String, Integer>();
        int i = 0;
        for (Table table : this.plugin.getConfiguration().getTables()) {
            indices.put(table.getName(), i);
            ++i;
        }
        return indices;
    }

    public PluginDescriptor getPluginDescriptor() {
        for (PluginDescriptor descriptor : this.getPluginManager().getInstalledDescriptors()) {
            if (!descriptor.getPluginClassName().equals(this.getPluginDescriptorClass())) continue;
            return descriptor;
        }
        return null;
    }

    public void addField(String fieldName, String fieldValue) {
        if (this.doesFieldExist(fieldName)) {
            this.changeFieldValue(fieldName, fieldValue);
        } else {
            Configuration config = this.plugin.getConfiguration();
            Field newField = new Field(fieldName, fieldValue);
            List fields = this.plugin.getConfiguration().getFields();
            fields.add(newField);
            this.plugin.setConfiguration(new Configuration(fields, config.getTables(), config.getAdvancedFields().getFields()));
        }
    }

    public void addAdvancedField(String fieldName, String fieldValue) {
        if (this.doesAdvancedFieldExist(fieldName)) {
            this.changeAdvancedFieldValue(fieldName, fieldValue);
        } else {
            Configuration config = this.plugin.getConfiguration();
            Field newField = new Field(fieldName, fieldValue);
            List fields = config.getAdvancedFields().getFields();
            fields.add(newField);
            this.plugin.setConfiguration(new Configuration(config.getFields(), config.getTables(), fields));
        }
    }

    protected boolean doesFieldExist(String fieldName) {
        return this.plugin.getConfiguration().getField(fieldName) != null;
    }

    protected boolean doesAdvancedFieldExist(String fieldName) {
        return this.plugin.getConfiguration().getAdvancedFields().getField(fieldName) != null;
    }

    protected void changeFieldValue(String fieldName, String fieldValue) {
        Configuration config = this.plugin.getConfiguration();
        List<Field> fields = this.changeFieldValue(fieldName, fieldValue, (FieldList)config);
        this.plugin.setConfiguration(new Configuration(fields, config.getTables(), config.getAdvancedFields().getFields()));
    }

    protected void changeAdvancedFieldValue(String fieldName, String fieldValue) {
        Configuration config = this.plugin.getConfiguration();
        List<Field> fields = this.changeFieldValue(fieldName, fieldValue, config.getAdvancedFields());
        this.plugin.setConfiguration(new Configuration(config.getFields(), config.getTables(), fields));
    }

    private List<Field> changeFieldValue(String fieldName, String fieldValue, FieldList existingFields) {
        List fields = existingFields.getFields();
        this.removeField(fieldName);
        Field newValueField = new Field(fieldName, fieldValue);
        fields.add(newValueField);
        return fields;
    }

    public void removeField(String fieldName) {
        Configuration config = this.plugin.getConfiguration();
        Field field = this.getField(fieldName);
        if (field != null) {
            config.getFields().remove(field);
        }
    }

    protected Field getField(String fieldName) {
        return this.plugin.getConfiguration().getField(fieldName);
    }

    protected Table addTable(String tableName) {
        if (this.doesTableExist(tableName)) {
            return this.getTable(tableName);
        }
        Table table = new Table(tableName, new LinkedList());
        this.plugin.getConfiguration().getTables().add(table);
        return table;
    }

    protected boolean doesTableExist(String tableName) {
        return this.getTable(tableName) != null;
    }

    protected Table getTable(String tableName) {
        List tables = this.plugin.getConfiguration().getTables();
        for (Table table : tables) {
            if (!tableName.equals(table.getName())) continue;
            return table;
        }
        return null;
    }

    protected void addFieldToTable(String tableName, String fieldName, String fieldValue) {
        this.addFieldToTable(this.getTable(tableName), fieldName, fieldValue);
    }

    protected void addFieldToTable(Table table, String fieldName, String fieldValue) {
        Field newField = new Field(fieldName, fieldValue);
        this.addRowToTable(table, Collections.singletonList(newField));
    }

    void addRowToTable(Table table, List<Field> fields) {
        Row row = new Row(fields);
        table.getRows().add(row);
    }

    protected void changeTableFieldValue(Table table, String fieldName, String fieldValue) {
        for (Row row : table.getRows()) {
            for (Field field : row.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                Field newField = new Field(fieldName, fieldValue);
                row.getFields().remove(field);
                row.getFields().add(newField);
                return;
            }
        }
    }

    protected boolean doesTableContainField(Table table, String fieldName) {
        for (Row row : table.getRows()) {
            for (Field field : row.getFields()) {
                if (!fieldName.equals(field.getName())) continue;
                return true;
            }
        }
        return false;
    }

    public T getPlugin() {
        return this.plugin;
    }

    public void setName(String name) {
        this.plugin.setName(name);
    }

    public void setId(String id) {
        this.plugin.setId(id);
    }

    public boolean isPluginNameInUse(String pluginName) {
        for (ConfigurablePluginInstance plugin : this.getPluginManager().getInstances()) {
            if (!plugin.getName().equalsIgnoreCase(pluginName)) continue;
            return true;
        }
        return false;
    }

    private boolean isPluginIDInUse(String id) {
        for (ConfigurablePluginInstance plugin : this.getPluginManager().getInstances()) {
            if (!plugin.getId().equalsIgnoreCase(id)) continue;
            return true;
        }
        return false;
    }

    private String findValidSuffix(String name) {
        String tempName;
        String id = this.createIdFromName(name);
        if (!this.isPluginNameInUse(name) && !this.isPluginIDInUse(id)) {
            return "";
        }
        Integer suffix = 0;
        do {
            Integer n = suffix;
            Integer n2 = suffix = Integer.valueOf(suffix + 1);
            tempName = this.createName(name, suffix.toString());
            id = this.createIdFromName(tempName, suffix.toString());
        } while (this.isPluginNameInUse(tempName) || this.isPluginIDInUse(id));
        return suffix.toString();
    }

    private String createName(String name, String suffix) {
        if (!StringUtils.isEmpty((String)suffix)) {
            name = (String)name + " " + suffix;
        }
        return name;
    }

    private String createIdFromName(String name) {
        return this.createIdFromName(name, "");
    }

    private String createIdFromName(String name, String suffix) {
        String alphaNumericName = name.replaceAll("[^A-Za-z0-9]", "");
        Object id = alphaNumericName.replaceAll("\\s", "");
        if (((String)id).length() > 33) {
            id = !StringUtils.isBlank((String)suffix) ? ((String)id).substring(0, 33 - suffix.length() - 1) : ((String)id).substring(0, 32);
        }
        if (!StringUtils.isBlank((String)suffix)) {
            id = (String)id + suffix;
        }
        return id;
    }

    public void setNameAndId(String name) {
        String suffix = this.findValidSuffix(name);
        this.setId(this.createIdFromName(name, suffix));
        this.setName(this.createName(name, suffix));
    }

    protected void filterCoreAttributes(Set<String> extendedAttrs) {
        extendedAttrs.removeAll(this.plugin.getAttributeContract().getImmutableAttributeNames());
    }
}

