/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.plugins;

import com.pingidentity.plugins.PluginBuilder;
import java.util.List;
import org.sourceid.saml20.adapter.conf.Table;
import org.sourceid.saml20.domain.AuthnSelectorInstance;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.saml20.domain.mgmt.PluginManager;

public class UserAgentSelectorBuilder
extends PluginBuilder<AuthnSelectorInstance> {
    private static final String TABLE_USER_AGENTS = "Results";
    private static final String FIELD_USER_AGENT = "Match Expression";
    private static final String HEADER_NAME_FIELD = "Header Name";
    private static final String USER_AGENT_HEADER = "User-Agent";

    public UserAgentSelectorBuilder(List<String> userAgentsToMatch) {
        Table table = this.addTable(TABLE_USER_AGENTS);
        for (String userAgent : userAgentsToMatch) {
            this.addFieldToTable(table, FIELD_USER_AGENT, this.wrapInWildCard(userAgent));
        }
        this.addField(HEADER_NAME_FIELD, USER_AGENT_HEADER);
    }

    @Override
    protected String getPluginDescriptorClass() {
        return "com.pingidentity.pf.selectors.http.HTTPHeaderAdapterSelector";
    }

    @Override
    protected PluginManager<?, AuthnSelectorInstance> getPluginManager() {
        return MgmtFactory.getAuthnSelectorManager();
    }

    @Override
    protected String getDefaultName() {
        return "user-agent-selector";
    }

    private String wrapInWildCard(String userAgent) {
        StringBuilder wildCardedStr = new StringBuilder();
        if (!userAgent.startsWith("*")) {
            wildCardedStr.append("*");
        }
        wildCardedStr.append(userAgent);
        if (!userAgent.endsWith("*")) {
            wildCardedStr.append("*");
        }
        return wildCardedStr.toString();
    }
}

