/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.sso;

import com.pingidentity.common.util.PropertyInfo;
import com.pingidentity.fsm.Visit;
import com.pingidentity.sso.OIDCAdminAuthenticationHandler;
import com.pingidentity.sso.OIDCAuthenticationResult;
import com.pingidentity.sso.service.OIDCAdminAuthenticationProxy;
import com.pingidentity.util.PingAbstractService;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tapestry.IComponent;
import org.apache.tapestry.IRequestCycle;
import org.apache.tapestry.PageRedirectException;
import org.apache.tapestry.engine.IEngineServiceView;
import org.apache.tapestry.engine.ILink;
import org.apache.tapestry.request.ResponseOutputStream;
import org.sourceid.config.GlobalRegistry;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;

public class FinishSsoService
extends PingAbstractService {
    private static final Log log = LogFactory.getLog(FinishSsoService.class);
    OIDCAdminAuthenticationProxy oIDCAdminAuthenticationProxy = (OIDCAdminAuthenticationProxy)GlobalRegistry.getService(OIDCAdminAuthenticationProxy.class);
    static final String PINGFEDERATE_APP_ENDPOINT = "/pingfederate/app";
    static final String SERVICE_NAME = "finishsso";

    public ILink getLink(IRequestCycle requestCycle, IComponent component, Object[] parameters) {
        return this.constructLink(requestCycle, SERVICE_NAME, new String[0], parameters, true);
    }

    public String getName() {
        return SERVICE_NAME;
    }

    public void service(IEngineServiceView engineServiceView, IRequestCycle requestCycle, ResponseOutputStream responseStream) {
        log.debug((Object)"Handling OIDC SSO authentication response");
        Visit pingVisit = this.getPingVisit(requestCycle);
        OIDCAdminAuthenticationHandler ssoHelper = this.oIDCAdminAuthenticationProxy.getHandlerInstance();
        OIDCAuthenticationResult result = ssoHelper.validateAuthnResponse(requestCycle);
        pingVisit.setOIDCAuthenticationResult(result);
        throw new PageRedirectException("login");
    }

    static String getEndpoint(HttpServletRequest request) {
        Object url = request.getRequestURL().toString();
        if (request.getPathInfo() != null && ((String)url).endsWith(request.getPathInfo())) {
            url = ((String)url).substring(0, ((String)url).length() - request.getPathInfo().length());
        }
        url = (String)url + "?service=finishsso";
        return url;
    }

    public static String getEndpoint() {
        String hostname = MgmtFactory.getPingOneAdminService().getSettings().getAdminConsoleHostname();
        if (StringUtils.isEmpty((String)hostname)) {
            throw new RuntimeException("Admin console hostname not initialized");
        }
        return "https://" + hostname + ":" + PropertyInfo.getAdminHttpsPort() + "/pingfederate/app?service=finishsso";
    }
}

