/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.templates.connection;

import com.pingidentity.pingcommons.util.Closer;
import com.pingidentity.templates.connection.ConnectionTemplate;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import org.sourceid.saml20.metadata.Role;

public class ConnectionTemplateManager {
    private static final String IDP_TEMPLATE_DESCRIPTOR = "PF-INF/idp-connection-template-descriptor";
    private static final String SP_TEMPLATE_DESCRIPTOR = "PF-INF/sp-connection-template-descriptor";
    private static List<String> idpConnectionTemplates = ConnectionTemplateManager.generateConnectionTemplates(Role.IDP);
    private static List<String> spConnectionTemplates = ConnectionTemplateManager.generateConnectionTemplates(Role.SP);

    public List<ConnectionTemplate> getConnectionTemplates(Role connectionRole) {
        List<String> connectionTemplateClasses = connectionRole == Role.IDP ? idpConnectionTemplates : spConnectionTemplates;
        ArrayList<ConnectionTemplate> connectionTemplates = new ArrayList<ConnectionTemplate>();
        for (String connectionTemplateClassName : connectionTemplateClasses) {
            ConnectionTemplate connectionTemplate = ConnectionTemplateManager.createConnectionTemplateInstance(connectionTemplateClassName);
            connectionTemplates.add(connectionTemplate);
        }
        return connectionTemplates;
    }

    public ConnectionTemplate getConnectionTemplate(Role connectionRole, String templateId) {
        List<ConnectionTemplate> templates = this.getConnectionTemplates(connectionRole);
        for (ConnectionTemplate template : templates) {
            if (!template.getId().equals(templateId)) continue;
            return template;
        }
        return null;
    }

    private static ConnectionTemplate createConnectionTemplateInstance(String className) {
        ConnectionTemplate connectionTemplate = null;
        try {
            Class<?> connectionTemplateClass = Class.forName(className);
            connectionTemplate = (ConnectionTemplate)connectionTemplateClass.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return connectionTemplate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<String> generateConnectionTemplates(Role role) {
        ArrayList<String> connectionTemplates = new ArrayList<String>();
        String descriptorFileName = role == Role.IDP ? IDP_TEMPLATE_DESCRIPTOR : SP_TEMPLATE_DESCRIPTOR;
        Enumeration<URL> resources = null;
        BufferedReader bufferedReader = null;
        try {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            Enumeration<URL> en = resources = classLoader.getResources(descriptorFileName);
            while (en.hasMoreElements()) {
                URL url = en.nextElement();
                try {
                    Object content = url.getContent();
                    if (!(content instanceof InputStream)) continue;
                    InputStream is = (InputStream)content;
                    bufferedReader = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8.toString()));
                    String connectionTemplateClassName = bufferedReader.readLine();
                    while (connectionTemplateClassName != null) {
                        if (!connectionTemplates.contains(connectionTemplateClassName)) {
                            connectionTemplates.add(connectionTemplateClassName);
                        }
                        connectionTemplateClassName = bufferedReader.readLine();
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            Closer.close(bufferedReader);
        }
        return connectionTemplates;
    }
}

