/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import com.pingidentity.provisioner.domain.ProvisionerGlobalSettings;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.sourceid.saml20.domain.JdbcDataSource;
import org.sourceid.saml20.domain.LocalSettings;
import org.sourceid.saml20.domain.mgmt.MgmtFactory;
import org.sourceid.util.license.LicenseManager;

public class ProvisionerGlobalSettingsHelper {
    private static final Log log = LogFactory.getLog(ProvisionerGlobalSettingsHelper.class);

    public static boolean canEnableProvisioning() {
        if (!LicenseManager.getLicense().isFeatureEnabled("SaasProvisioning")) {
            return false;
        }
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        ProvisionerGlobalSettings provisionerGlobalConfig = (ProvisionerGlobalSettings)localSettings.getConnectionModuleGlobalConfiguration(ProvisionerGlobalSettings.class);
        if (provisionerGlobalConfig == null) {
            throw new RuntimeException("Failed to retrieve global config object for module SaasProvisioner");
        }
        if (provisionerGlobalConfig.isEnabledInGui()) {
            return true;
        }
        boolean hasHsqldbDataSource = false;
        for (JdbcDataSource dataSource : MgmtFactory.getDataSourceManager().getJdbcDataSources()) {
            if (!dataSource.isEmbeddedHsqldb()) continue;
            hasHsqldbDataSource = true;
            break;
        }
        return hasHsqldbDataSource;
    }

    public static void enableProvisioning() {
        LocalSettings localSettings = MgmtFactory.getLocalSettingsManager().getLocalSettings();
        ProvisionerGlobalSettings provisionerGlobalConfig = (ProvisionerGlobalSettings)localSettings.getConnectionModuleGlobalConfiguration(ProvisionerGlobalSettings.class);
        if (provisionerGlobalConfig == null) {
            throw new RuntimeException("Failed to retrieve global config object for module SaasProvisioner");
        }
        if (!provisionerGlobalConfig.isEnabledInGui()) {
            log.info((Object)"Enabling SaaS provisioning globally");
            JdbcDataSource defaultDataSource = null;
            for (JdbcDataSource dataSource : MgmtFactory.getDataSourceManager().getJdbcDataSources()) {
                if (!dataSource.isEmbeddedHsqldb()) continue;
                defaultDataSource = dataSource;
                break;
            }
            if (defaultDataSource == null) {
                throw new RuntimeException("Missing default JDBC data source, cannot enable SaaS provisioning");
            }
            provisionerGlobalConfig.setEnabledInGui(true);
            provisionerGlobalConfig.setInternalDataSourceId(defaultDataSource.getId());
            MgmtFactory.getLocalSettingsManager().saveLocalSettings(localSettings);
        }
    }
}

