/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import com.pingidentity.common.mgr.ExpressionManager;
import com.pingidentity.component.common.DataMap;
import com.pingidentity.fsm.tasklet.TaskletState;
import com.pingidentity.fsm.tasklet.data.TestDataItem;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.valid.IValidationDelegate;
import org.apache.tapestry.valid.ValidationConstraint;
import org.sourceid.saml20.domain.AttrMappingValue;
import org.sourceid.saml20.domain.AttributeMapping;
import org.sourceid.saml20.domain.SourceType;
import org.sourceid.saml20.domain.SourceTypeString;
import org.sourceid.saml20.domain.mgmt.impl.AdministrativeUser;

public class SAML2MappingModel
implements DataMap.Model,
Serializable {
    private static final long serialVersionUID = 20050515L;
    private Map<String, String> lastSourceCache = new HashMap<String, String>();
    private Map<String, String> lastValueCache = new HashMap<String, String>();
    protected AttributeMapping mapping;
    private String targetName;
    private boolean testingExpression;
    private List<TestDataItem> testDataList = new ArrayList<TestDataItem>();
    private boolean isUserProvisioningModel;
    private Object expressionTestState;
    private AdministrativeUser administrativeUser;

    public SAML2MappingModel(AdministrativeUser administrativeUser) {
        this.mapping = new AttributeMapping();
        this.administrativeUser = administrativeUser;
    }

    public SAML2MappingModel(String targetName, AttributeMapping mapping, AdministrativeUser administrativeUser) {
        this(targetName, mapping, false, administrativeUser);
    }

    public SAML2MappingModel(String targetName, AttributeMapping mapping, boolean assumeMapping, AdministrativeUser administrativeUser) {
        this.administrativeUser = administrativeUser;
        this.targetName = targetName;
        if (assumeMapping) {
            this.mapping = mapping;
        } else {
            this.mapping = mapping == null ? new AttributeMapping() : new AttributeMapping(mapping);
            for (Map.Entry e : this.mapping.getAttributeMap().entrySet()) {
                String target = (String)e.getKey();
                String source = ((AttrMappingValue)e.getValue()).getTypeString();
                String value = ((AttrMappingValue)e.getValue()).getValue();
                this.lastValueCache.put(target + ":" + source, value);
                this.lastSourceCache.put(target, source);
            }
        }
    }

    @Override
    public AttributeMapping getMapping() {
        return this.mapping;
    }

    @Override
    public void updateSource(String target, List<AttrMappingValue> values) {
        this.mapping.removeAttributeMapping(target);
        this.mapping.putAttributeMapping(target, values);
    }

    @Override
    public void updateSource(String target, String newSource, String oldSource, String oldValue) {
        this.lastValueCache.put(target + ":" + oldSource, oldValue);
        SourceType stype = SourceTypeString.strToType((String)newSource);
        if (stype != null) {
            String lastValue = this.lastValueCache.get(target + ":" + newSource);
            this.mapping.addAttributeMapping(target, stype, lastValue);
        } else {
            this.mapping.removeAttributeMapping(target);
        }
    }

    @Override
    public void updateValue(String target, String source, String newValue, String oldValue) {
        SourceType stype = SourceTypeString.strToType((String)source);
        if (newValue != null) {
            this.mapping.addAttributeMapping(target, stype, newValue);
        } else {
            this.mapping.addAttributeMapping(target, stype, "");
        }
    }

    @Override
    public Set<String> getTargets() {
        return this.mapping.getAttributeMapping().keySet();
    }

    @Override
    public void remove(String target) {
        this.mapping.removeAttributeMapping(target);
    }

    @Override
    public List<String> getSources(String target) {
        List attributeList = this.mapping.getAttributeMappingValues(target);
        if (attributeList != null && attributeList.size() > 0) {
            ArrayList<String> list = new ArrayList<String>(attributeList.size());
            for (AttrMappingValue value : attributeList) {
                list.add(value.getTypeString());
            }
            return list;
        }
        return null;
    }

    @Override
    public String getSource(String target) {
        AttrMappingValue v = null;
        List list = this.mapping.getAttributeMappingValues(target);
        v = list != null && list.size() > 0 ? (AttrMappingValue)list.get(0) : this.mapping.getAttributeMapping(target);
        return v != null ? v.getTypeString() : null;
    }

    @Override
    public String getValue(String target) {
        AttrMappingValue v = null;
        List list = this.mapping.getAttributeMappingValues(target);
        v = list != null && list.size() > 0 ? (AttrMappingValue)list.get(0) : this.mapping.getAttributeMapping(target);
        return v != null ? v.getValue() : null;
    }

    @Override
    public boolean contains(String target) {
        return this.mapping.getAttributeMapping(target) != null;
    }

    public void validate(IValidationDelegate delegate, Collection<String> targets, DataMap.Sources sources, TaskletState parent) {
        this.cleanMappings(new HashSet<String>(targets));
        Map attribMap = this.mapping.getAttributeMapping();
        this.validateAllTargetsAreInModel(delegate, targets, parent, attribMap);
        for (Map.Entry entry : attribMap.entrySet()) {
            Object[] objects = new Object[]{entry.getKey()};
            for (AttrMappingValue amv : (List)entry.getValue()) {
                if (!this.isUserProvisioningModel) {
                    this.validateIfNotUserProvisioningModel(delegate, sources, parent, objects, amv);
                    continue;
                }
                if (amv.getType() == SourceType.SYSTEM_MANAGED) {
                    return;
                }
                if (StringUtils.isBlank((String)amv.getValue()) && amv.getType() != SourceType.TEXT) {
                    delegate.setFormComponent(null);
                    delegate.record(parent.getMessage("Does_not_have_mapped_value", objects), ValidationConstraint.REQUIRED);
                    continue;
                }
                if (sources.isValidSourceValue(amv.getTypeString(), amv.getValue())) continue;
                delegate.setFormComponent(null);
                if (sources.getCustomizedErrorMessage() != null) {
                    delegate.record(sources.getCustomizedErrorMessage(), ValidationConstraint.REQUIRED);
                    continue;
                }
                ExpressionManager expressionManager = ExpressionManager.getInstance();
                if (amv.getType() == SourceType.EXPRESSION) {
                    if (expressionManager.isEvaluateExpressionsOff()) {
                        delegate.record(parent.getMessage("Expressions_turned_off", objects), ValidationConstraint.REQUIRED);
                        continue;
                    }
                    if (this.administrativeUser.isExpressionAdmin() || !this.lastSourceCache.isEmpty() && (this.lastSourceCache.get(entry.getKey()) == null || !SourceTypeString.getTypeString((SourceType)SourceType.EXPRESSION).equals(this.lastSourceCache.get(entry.getKey())))) continue;
                    delegate.record(parent.getMessage("Expression_admin_role_required", objects), ValidationConstraint.REQUIRED);
                    continue;
                }
                delegate.record(parent.getMessage("Must_have_valid_value", objects), ValidationConstraint.REQUIRED);
            }
        }
    }

    protected void validateIfNotUserProvisioningModel(IValidationDelegate delegate, DataMap.Sources sources, TaskletState parent, Object[] objects, AttrMappingValue amv) {
        if (StringUtils.isBlank((String)amv.getValue())) {
            delegate.setFormComponent(null);
            delegate.record(parent.getMessage("Does_not_have_mapped_value", objects), ValidationConstraint.REQUIRED);
        } else if (!sources.isValidSourceValue(DataMap.Sources.createSourceKey(amv.getTypeString(), amv.getAttributeSourceId()), amv.getValue())) {
            delegate.setFormComponent(null);
            if (sources.getCustomizedErrorMessage() != null) {
                delegate.record(sources.getCustomizedErrorMessage(), ValidationConstraint.REQUIRED);
            } else {
                ExpressionManager expressionManager = ExpressionManager.getInstance();
                if (amv.getType() == SourceType.EXPRESSION && expressionManager.isEvaluateExpressionsOff()) {
                    delegate.record(parent.getMessage("Expressions_turned_off", objects), ValidationConstraint.REQUIRED);
                } else if (this.administrativeUser.isExpressionAdmin()) {
                    delegate.record(parent.getMessage("Must_have_valid_value", objects), ValidationConstraint.REQUIRED);
                }
            }
        }
    }

    protected void validateAllTargetsAreInModel(IValidationDelegate delegate, Collection<String> targets, TaskletState parent, Map<String, List<AttrMappingValue>> attribMap) {
        for (String target : targets) {
            if (attribMap.containsKey(target)) continue;
            Object[] objects = new Object[]{target};
            delegate.setFormComponent(null);
            delegate.record(parent.getMessage("Must_be_mapped", objects), ValidationConstraint.REQUIRED);
        }
    }

    @Override
    public String getTargetName() {
        return this.targetName;
    }

    @Override
    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    @Override
    public boolean isTestingExpression() {
        return this.testingExpression;
    }

    @Override
    public void setTestingExpression(boolean testingExpression) {
        this.testingExpression = testingExpression;
    }

    @Override
    public List<TestDataItem> getTestDataList() {
        return this.testDataList;
    }

    @Override
    public void setTestDataList(List<TestDataItem> testDataList) {
        this.testDataList = testDataList;
    }

    public boolean isUserProvisioningModel() {
        return this.isUserProvisioningModel;
    }

    public void setUserProvisioningModel(boolean isUserProvisioningModel) {
        this.isUserProvisioningModel = isUserProvisioningModel;
    }

    @Override
    public void cleanMappings(Set<String> attributeContract) {
        Iterator<String> targetIterator = this.getTargets().iterator();
        while (targetIterator.hasNext()) {
            String target = targetIterator.next();
            if (attributeContract.contains(target)) continue;
            targetIterator.remove();
        }
    }

    @Override
    public Object getExpressionTestState() {
        return this.expressionTestState;
    }

    @Override
    public void setExpressionTestState(Object state) {
        this.expressionTestState = state;
    }

    @Override
    public boolean isDisplayValue(String selectedSource) {
        return !"No Mapping".equals(selectedSource);
    }

    @Override
    public SourceType getDefaultSourceType() {
        return null;
    }
}

