/*
 * Decompiled with CFR 0.152.
 */
package com.pingidentity.util;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Objects;
import org.apache.commons.lang.StringUtils;
import org.apache.tapestry.form.IPropertySelectionModel;

public class StringPairPropertySelectionModel
implements IPropertySelectionModel,
Serializable {
    private static final long serialVersionUID = 1L;
    private boolean initWithSelect;
    public static final String SELECT = "- SELECT -";
    private HashMap<Object, String> pairsMap = new HashMap();
    private ArrayList<SPair> pairs = new ArrayList();

    public StringPairPropertySelectionModel() {
    }

    public StringPairPropertySelectionModel(String defaultFirstEntry) {
        this.init(defaultFirstEntry);
    }

    public StringPairPropertySelectionModel(boolean putSelectAtTop) {
        if (putSelectAtTop) {
            this.init(SELECT);
        }
    }

    public StringPairPropertySelectionModel(boolean putSelectAtTop, String[] strings) {
        if (putSelectAtTop) {
            this.init(SELECT);
        }
        this.addAllStrings(strings);
    }

    public StringPairPropertySelectionModel(boolean putSelectAtTop, Collection<String> values) {
        this(putSelectAtTop, values.toArray(new String[values.size()]));
    }

    private void init(String defaultEntry) {
        this.add(defaultEntry, null);
        this.initWithSelect = true;
    }

    public void clear() {
        this.pairs.clear();
        this.pairsMap.clear();
    }

    public void add(String description, Object id) {
        SPair p = new SPair();
        p.desc = description;
        p.id = id;
        this.add(p);
    }

    public void addAllStrings(String[] strings) {
        for (int i = 0; i < Array.getLength(strings); ++i) {
            SPair p = new SPair();
            p.desc = strings[i];
            p.id = strings[i];
            this.add(p);
        }
    }

    public void add(SPair p) {
        if (p.id != null && this.pairsMap.remove(p.id) != null) {
            this.pairs.remove(p);
        }
        if (p.id != null) {
            this.pairsMap.put(p.id, p.desc);
        }
        this.pairs.add(p);
    }

    public void addAll(Collection<SPair> sPairs) {
        for (SPair sPair : sPairs) {
            this.add(sPair);
        }
    }

    public int getOptionCount() {
        return this.pairs.size();
    }

    public Object getOption(int index) {
        return this.pairs.get((int)index).id;
    }

    public String getLabel(int index) {
        if (!this.pairs.isEmpty()) {
            return this.pairs.get((int)index).desc;
        }
        return "";
    }

    public String getValue(int index) {
        return Integer.toString(index);
    }

    public Object translateValue(String value) {
        int index = 0;
        try {
            index = Integer.parseInt(value);
            if (this.pairs.size() <= index) {
                index = 0;
            }
        }
        catch (NumberFormatException nfe) {
            index = 0;
        }
        return this.pairs.get((int)index).id;
    }

    public void sort() {
        if (this.initWithSelect && this.pairs.size() > 1) {
            SPair topEntry = this.pairs.remove(0);
            Collections.sort(this.pairs);
            this.pairs.add(0, topEntry);
        } else {
            Collections.sort(this.pairs);
        }
    }

    public String getDescription(Object value) {
        return this.pairsMap.get(value);
    }

    public void remove(String name) {
        if (StringUtils.isNotBlank((String)name)) {
            Iterator<SPair> it = this.pairs.iterator();
            while (it.hasNext()) {
                SPair p = it.next();
                if (!name.equals(p.desc)) continue;
                this.pairsMap.remove(p.id);
                it.remove();
                break;
            }
        }
    }

    public void removeById(String id) {
        if (StringUtils.isNotBlank((String)id)) {
            this.pairsMap.remove(id);
            Iterator<SPair> it = this.pairs.iterator();
            while (it.hasNext()) {
                SPair p = it.next();
                if (!id.equals(p.id)) continue;
                it.remove();
                break;
            }
        }
    }

    public void removeAll() {
        this.clear();
        if (this.initWithSelect) {
            this.add(SELECT, null);
        }
    }

    public static class SPair
    implements Comparable<SPair>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private String desc;
        private Object id;
        public static final Comparator<SPair> ID_COMPARATOR = (a, b) -> a.getDesc().compareToIgnoreCase(b.getDesc());

        public SPair() {
        }

        public SPair(String desc, Object id) {
            this.desc = desc;
            this.id = id;
        }

        public boolean equals(Object o) {
            if (o instanceof SPair) {
                return Objects.equals(this.id, ((SPair)o).id);
            }
            return false;
        }

        @Override
        public int compareTo(SPair o) {
            if (o == null) {
                return 1;
            }
            if (this.desc == null && o.desc == null) {
                return 0;
            }
            if (this.desc == null) {
                return -1;
            }
            if (o.desc == null) {
                return 1;
            }
            return String.CASE_INSENSITIVE_ORDER.compare(this.desc, o.desc);
        }

        public int hashCode() {
            if (this.id == null) {
                return 0;
            }
            return this.id.hashCode();
        }

        public String getDesc() {
            return this.desc;
        }

        public void setDesc(String desc) {
            this.desc = desc;
        }

        public Object getId() {
            return this.id;
        }

        public void setId(Object id) {
            this.id = id;
        }
    }
}

